/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import weblogic.xml.security.utils.Observer;
import weblogic.xml.security.wsse.internal.SoapStreamState;
import weblogic.xml.security.wsse.internal.Utils;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;

public class MappingObserver
implements Observer {
    private final SoapStreamState state = new SoapStreamState();
    private final Map unrestrictedElementMap = new HashMap();
    private final Map headerElementMap = new HashMap();
    private final Map bodyElementMap = new HashMap();
    private final Map idElement = new HashMap();
    private boolean duplicateIds = false;
    private static final String ID_ATTR = "Id";
    public static final String UNMATCHABLE_ID = " \bUnidentifiedElement";

    public boolean consumes() {
        return false;
    }

    public Map getElements() {
        return this.unrestrictedElementMap;
    }

    public Map getHeaderElements() {
        return this.headerElementMap;
    }

    public Map getBodyElements() {
        return this.bodyElementMap;
    }

    public SortedSet getElementIds(XMLName xMLName) {
        return (SortedSet)this.unrestrictedElementMap.get(xMLName);
    }

    public SortedSet getElementHeaderIds(XMLName xMLName) {
        return (SortedSet)this.headerElementMap.get(xMLName);
    }

    public SortedSet getElementBodyIds(XMLName xMLName) {
        return (SortedSet)this.bodyElementMap.get(xMLName);
    }

    public XMLName getElementById(String string) {
        return (XMLName)this.idElement.get(string);
    }

    public final boolean duplicateIds() {
        return this.duplicateIds;
    }

    public boolean observe(XMLEvent xMLEvent) throws XMLStreamException {
        if (xMLEvent == null) {
            return false;
        }
        if (xMLEvent.isStartElement()) {
            StartElement startElement = (StartElement)xMLEvent;
            this.state.update(startElement);
            XMLName xMLName = startElement.getName();
            int n = 0;
            AttributeIterator attributeIterator = startElement.getAttributes();
            while (attributeIterator.hasNext()) {
                String string;
                Attribute attribute = attributeIterator.next();
                XMLName xMLName2 = attribute.getName();
                String string2 = xMLName2.getLocalName();
                if (!ID_ATTR.equals(string2) || !this.idNamespace(string = xMLName2.getNamespaceUri())) continue;
                ++n;
                String string3 = attribute.getValue();
                XMLName xMLName3 = this.idElement.put(string3, xMLName);
                if (xMLName3 != null) {
                    this.duplicateIds = true;
                }
                this.recordElement(xMLName, string3);
            }
            if (n == 0) {
                this.recordElement(xMLName, UNMATCHABLE_ID);
            }
        } else if (xMLEvent.isEndElement()) {
            this.state.update((EndElement)xMLEvent);
        }
        return true;
    }

    private boolean idNamespace(String string) {
        boolean bl = false;
        if (string == null) {
            bl = true;
        } else {
            for (int i = 0; i < WSSEConstants.ID_NAMESPACES.length; ++i) {
                String string2 = WSSEConstants.ID_NAMESPACES[i];
                if (!string.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void recordElement(XMLName xMLName, String string) {
        Utils.addElement(this.unrestrictedElementMap, xMLName, string);
        if (this.state.atTypeLevel()) {
            if (this.state.inHeader()) {
                Utils.addElement(this.headerElementMap, xMLName, string);
            } else if (this.state.inBody()) {
                Utils.addElement(this.bodyElementMap, xMLName, string);
            }
        }
    }
}

