/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.internal;

import weblogic.xml.security.signature.InternalReference;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.signature.SoapSignXMLOutputStream;
import weblogic.xml.security.transforms.ExcC14NTransform;
import weblogic.xml.security.transforms.IncompatibleTransformException;
import weblogic.xml.security.transforms.Transform;
import weblogic.xml.security.transforms.TransformException;
import weblogic.xml.security.utils.TaggingPreprocessor;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SigningPreprocessor
extends TaggingPreprocessor {
    public static final String FRAGMENT_URI = "#";
    private final SoapSignXMLOutputStream stream;
    private final Signature sig;
    private final String c14nAlg;

    public SigningPreprocessor(Signature signature, String string, SoapSignXMLOutputStream soapSignXMLOutputStream) {
        this.stream = soapSignXMLOutputStream;
        this.sig = signature;
        this.c14nAlg = string;
    }

    public void begin(StartElement startElement, XMLOutputStream xMLOutputStream, String string) throws XMLStreamException {
        String string2 = FRAGMENT_URI + string;
        this.addReference(string2);
        xMLOutputStream.add((XMLEvent)startElement);
    }

    private void addReference(String string) {
        InternalReference internalReference = new InternalReference(string);
        try {
            ExcC14NTransform excC14NTransform = (ExcC14NTransform)Transform.getTransform(this.c14nAlg);
            internalReference.addTransform(excC14NTransform);
        }
        catch (IncompatibleTransformException incompatibleTransformException) {
            incompatibleTransformException.printStackTrace();
        }
        catch (TransformException transformException) {
            transformException.printStackTrace();
        }
        this.sig.addReference(internalReference);
        this.stream.addReference(internalReference);
    }

    public void end(EndElement endElement, XMLOutputStream xMLOutputStream) throws XMLStreamException {
        xMLOutputStream.add((XMLEvent)endElement);
    }
}

