/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.internal;

import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;

public class SoapStreamState {
    public static final int PRE_HEADER = 0;
    public static final int IN_HEADER = 1;
    public static final int BETWEEN = 2;
    public static final int IN_BODY = 3;
    public static final int POST_BODY = 4;
    private static final int MESSAGE_LEVEL = 1;
    private static final int PART_LEVEL = 2;
    private static final int TYPE_LEVEL = 3;
    static final String SOAP_HEADER = "Header";
    static final String SOAP_BODY = "Body";
    private int state = 0;
    private int depth = 0;

    public boolean update(XMLEvent xMLEvent) {
        if (xMLEvent.isStartElement()) {
            return this.update((StartElement)xMLEvent);
        }
        if (xMLEvent.isEndElement()) {
            return this.update((EndElement)xMLEvent);
        }
        return false;
    }

    public boolean update(StartElement startElement) {
        ++this.depth;
        int n = this.state;
        switch (this.state) {
            case 0: {
                if (this.depth != 2) break;
                XMLName xMLName = startElement.getName();
                if (SOAP_HEADER.equals(xMLName.getLocalName()) && this.validSoapNamespace(xMLName.getNamespaceUri())) {
                    this.state = 1;
                    break;
                }
                if (!SOAP_BODY.equals(xMLName.getLocalName())) break;
                this.state = 3;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                XMLName xMLName;
                if (this.depth != 2 || !SOAP_BODY.equals((xMLName = startElement.getName()).getLocalName())) break;
                this.state = 3;
                break;
            }
            case 3: {
                break;
            }
        }
        return this.state != n;
    }

    public boolean update(EndElement endElement) {
        int n = this.state;
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                if (this.depth != 2) break;
                this.state = 2;
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                if (this.depth != 2) break;
                this.state = 4;
                break;
            }
        }
        --this.depth;
        return this.state != n;
    }

    boolean validSoapNamespace(String string) {
        return true;
    }

    public String getState() {
        switch (this.state) {
            case 0: {
                return "PreHeader";
            }
            case 1: {
                return "InHeader";
            }
            case 2: {
                return "Between";
            }
            case 3: {
                return "InBody";
            }
            case 4: {
                return "PostBody";
            }
        }
        return "unknown";
    }

    public String toString() {
        return "StreamState(" + this.getState() + ", " + this.depth + ")";
    }

    public boolean inState(int n) {
        return this.state == n;
    }

    public boolean inHeader() {
        return this.inState(1);
    }

    public boolean inBody() {
        return this.inState(3);
    }

    public boolean atLevel(int n) {
        return this.depth == n;
    }

    public boolean atTypeLevel() {
        return this.atLevel(3);
    }

    public boolean atPartLevel() {
        return this.atLevel(2);
    }

    public boolean after(int n) {
        return this.state > n;
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<soap:Envelope xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\">    <soap:Header>      <wsrp:path soap:actor=\"http://schemas.xmlsoap.org/soap/actor/next\" soap:mustUnderstand=\"1\" xmlns:wsrp=\"http://schemas.xmlsoap.org/rp\">        <wsrp:action xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" wsu:Id=\"Id-6eaab782-357a-43e4-984e-f54c3f593370\">http://microsoft.com/wsdk/samples/SumService/AddInt</wsrp:action>        <wsrp:to xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" wsu:Id=\"Id-f8fcb28f-067d-4b60-8a79-8ee92eb2dd9f\">http://localhost/wsdkquickstart/usernamesigning/service/usernamesigning.asmx</wsrp:to>        <wsrp:id xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" wsu:Id=\"Id-ce040a96-bd50-41fa-8166-124679c979e8\">uuid:4e76bcac-5307-4519-9e51-3cbe9c58ceb4</wsrp:id>      </wsrp:path>      <wsu:Timestamp xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\">        <wsu:Created wsu:Id=\"Id-e9f86751-e899-41e3-a797-17a1d6150888\">2002-09-26T16:13:15Z</wsu:Created>        <wsu:Expires wsu:Id=\"Id-745e1094-9bce-4bf6-8bf1-33b23ace87c6\">2002-09-26T16:14:15Z</wsu:Expires>      </wsu:Timestamp>      <wsse:Security soap:mustUnderstand=\"1\" xmlns:wsse=\"http://schemas.xmlsoap.org/ws/2002/07/secext\">        <wsse:UsernameToken xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" wsu:Id=\"SecurityToken-82aa7b1e-db82-40b5-9944-d66bb767d9e5\">          <wsse:Username>billjg</wsse:Username>          <wsse:Password Type=\"wsse:PasswordDigest\">w94sA/jK11Td4HisIEAFTqMd/+w=</wsse:Password>          <wsse:Nonce>fgx3k755iWAdW0GFzDd4dw==</wsse:Nonce>          <wsu:Created>2002-09-26T16:13:15Z</wsu:Created>        </wsse:UsernameToken>        <Signature xmlns=\"http://www.w3.org/2000/09/xmldsig#\">          <SignedInfo>            <CanonicalizationMethod Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\" />            <SignatureMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#hmac-sha1\" />            <Reference URI=\"#Id-ff2b91ec-6d8e-42ec-8a3b-01885b4ebbd2\">              <Transforms>                <Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\" />              </Transforms>              <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" />              <DigestValue>4fazWvZQTspNRY2Z1GHrTFS7eYQ=</DigestValue>            </Reference>            <Reference URI=\"#Id-6eaab782-357a-43e4-984e-f54c3f593370\">              <Transforms>                <Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\" />              </Transforms>              <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" />              <DigestValue>zFHn8/tx1goUjatsBto0imZEiYI=</DigestValue>            </Reference>            <Reference URI=\"#Id-f8fcb28f-067d-4b60-8a79-8ee92eb2dd9f\">              <Transforms>                <Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\" />              </Transforms>              <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" />              <DigestValue>YomslOQ7yRNnpDcpOkKCcoNVSWc=</DigestValue>            </Reference>            <Reference URI=\"#Id-ce040a96-bd50-41fa-8166-124679c979e8\">              <Transforms>                <Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\" />              </Transforms>              <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" />              <DigestValue>odkVpMjtM5xtJOIeIIXEiJHFZ+Q=</DigestValue>            </Reference>            <Reference URI=\"#Id-e9f86751-e899-41e3-a797-17a1d6150888\">              <Transforms>                <Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\" />              </Transforms>              <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" />              <DigestValue>w6BODXClETlLqdQ/I/U/LQKVTs4=</DigestValue>            </Reference>            <Reference URI=\"#Id-745e1094-9bce-4bf6-8bf1-33b23ace87c6\">              <Transforms>                <Transform Algorithm=\"http://www.w3.org/2001/10/xml-exc-c14n#\" />              </Transforms>              <DigestMethod Algorithm=\"http://www.w3.org/2000/09/xmldsig#sha1\" />              <DigestValue>5Z/IOnvyc7VxdC77uU7HSPRo8w4=</DigestValue>            </Reference>          </SignedInfo>          <SignatureValue>GnnGXrvG02TinOECHg4wO2A+ha0=</SignatureValue>          <KeyInfo>            <wsse:SecurityTokenReference>              <wsse:Reference URI=\"#SecurityToken-82aa7b1e-db82-40b5-9944-d66bb767d9e5\" />            </wsse:SecurityTokenReference>          </KeyInfo>        </Signature>      </wsse:Security>    </soap:Header>    <soap:Body xmlns:wsu=\"http://schemas.xmlsoap.org/ws/2002/07/utility\" wsu:Id=\"Id-ff2b91ec-6d8e-42ec-8a3b-01885b4ebbd2\">      <AddInt xmlns=\"http://microsoft.com/wsdk/samples/SumService\">        <a>9</a>        <b>10</b>      </AddInt>    </soap:Body>  </soap:Envelope>");
        SoapStreamState soapStreamState = new SoapStreamState();
        Object var3_3 = null;
        while (xMLInputStream.hasNext()) {
            XMLEvent xMLEvent = xMLInputStream.peek();
            if (xMLEvent.isStartElement()) {
                StartElement startElement = (StartElement)xMLEvent;
                soapStreamState.update(startElement);
                if (soapStreamState.inHeader() && soapStreamState.atTypeLevel()) {
                    XMLName xMLName = startElement.getName();
                    String string = xMLName.getNamespaceUri();
                    if ("Security".equals(xMLName.getLocalName())) {
                        String string2 = StreamUtils.getAttribute(startElement, "Role");
                        if (var3_3 == null ? string2 == null : string2.equals(var3_3)) {
                            System.out.println("HIT!");
                            break;
                        }
                    }
                    System.out.println("got type " + startElement);
                }
                xMLInputStream.next();
                continue;
            }
            if (xMLEvent.isEndElement()) {
                soapStreamState.update(xMLInputStream.next());
                if (!soapStreamState.after(1)) continue;
                System.out.println("done with header at " + xMLEvent);
                break;
            }
            xMLInputStream.next();
        }
    }
}

