/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.internal;

import java.util.HashSet;
import java.util.Set;
import weblogic.xml.security.specs.OperationSpec;
import weblogic.xml.security.utils.Preprocessor;
import weblogic.xml.security.utils.PreprocessorOutputStream;
import weblogic.xml.security.wsse.internal.SoapStreamState;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SpecPreprocessorOutputStream
extends PreprocessorOutputStream {
    private final Set headerTypes = new HashSet();
    private final Set bodyTypes = new HashSet();
    private final Set unrestrictedTypes = new HashSet();
    private Set typeRegistrations;
    private final boolean entireBody;
    private final SoapStreamState state = new SoapStreamState();

    public SpecPreprocessorOutputStream(XMLOutputStream xMLOutputStream, OperationSpec operationSpec, Preprocessor preprocessor) {
        super(xMLOutputStream, preprocessor);
        XMLName xMLName;
        int n;
        XMLName[] xMLNameArray = operationSpec.getHeaderElementNames();
        for (n = 0; n < xMLNameArray.length; ++n) {
            xMLName = xMLNameArray[n];
            this.headerTypes.add(xMLName);
        }
        xMLNameArray = operationSpec.getUnrestrictedElementNames();
        for (n = 0; n < xMLNameArray.length; ++n) {
            xMLName = xMLNameArray[n];
            this.unrestrictedTypes.add(xMLName);
        }
        this.entireBody = operationSpec.entireBody();
        if (!this.entireBody) {
            xMLNameArray = operationSpec.getBodyElementNames();
            for (n = 0; n < xMLNameArray.length; ++n) {
                xMLName = xMLNameArray[n];
                this.bodyTypes.add(xMLName);
            }
        }
    }

    protected void addXMLEvent(XMLEvent xMLEvent) throws XMLStreamException {
        if (xMLEvent.isStartElement()) {
            this.begin((StartElement)xMLEvent);
        } else if (xMLEvent.isEndElement()) {
            this.end((EndElement)xMLEvent);
        } else {
            this.dest.add(xMLEvent);
        }
    }

    protected void begin(StartElement startElement) throws XMLStreamException {
        if (this.state.update(startElement)) {
            if (this.state.inHeader()) {
                this.typeRegistrations = this.headerTypes;
            } else if (this.state.inBody()) {
                this.typeRegistrations = this.bodyTypes;
            }
        }
        if (this.entireBody && this.state.inBody()) {
            if (this.state.atPartLevel()) {
                this.preprocessor.begin(startElement, this.dest);
                return;
            }
        } else if (this.state.atTypeLevel() && this.typeRegistrations != null && !this.typeRegistrations.isEmpty() && this.typeRegistrations.contains(startElement.getName())) {
            this.preprocessor.begin(startElement, this.dest);
            return;
        }
        if (this.unrestrictedTypes.contains(startElement.getName())) {
            this.preprocessor.begin(startElement, this.dest);
        } else {
            this.dest.add((XMLEvent)startElement);
        }
    }

    protected void end(EndElement endElement) throws XMLStreamException {
        if (this.unrestrictedTypes.contains(endElement.getName())) {
            this.preprocessor.end(endElement, this.dest);
            this.state.update(endElement);
            return;
        }
        if (this.entireBody && this.state.inBody()) {
            if (this.state.atPartLevel()) {
                this.preprocessor.end(endElement, this.dest);
                this.state.update(endElement);
                return;
            }
        } else if (this.state.atTypeLevel() && this.typeRegistrations != null && !this.typeRegistrations.isEmpty() && this.typeRegistrations.contains(endElement.getName())) {
            this.preprocessor.end(endElement, this.dest);
            this.state.update(endElement);
            return;
        }
        this.dest.add((XMLEvent)endElement);
        this.state.update(endElement);
    }
}

