/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import javax.xml.rpc.soap.SOAPFaultException;
import weblogic.xml.security.signature.InvalidReferenceException;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.ReferenceValidationException;
import weblogic.xml.security.signature.SignatureValidationException;
import weblogic.xml.security.transforms.Transform;
import weblogic.xml.security.wsse.internal.TransformUtils;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.XMLName;

public class Utils {
    public static final boolean validReference(Reference reference) {
        if (reference == null) {
            return false;
        }
        Transform[] transformArray = reference.getTransforms();
        for (int i = 0; i < transformArray.length; ++i) {
            Transform transform = transformArray[i];
            if (TransformUtils.preservesSemantics(transform)) continue;
            return false;
        }
        return true;
    }

    public static final boolean addElement(Map map, XMLName xMLName, String string) {
        TreeSet<String> treeSet = (TreeSet<String>)map.get(xMLName);
        if (treeSet == null) {
            treeSet = new TreeSet<String>();
            map.put(xMLName, treeSet);
        }
        return treeSet.add(string);
    }

    public static final boolean equivalent(SortedSet sortedSet, SortedSet sortedSet2) {
        if (sortedSet == null || sortedSet2 == null) {
            return sortedSet == sortedSet2;
        }
        Iterator iterator = sortedSet.iterator();
        Iterator iterator2 = sortedSet2.iterator();
        while (iterator.hasNext()) {
            Object e;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object e2 = iterator.next();
            if (e2.equals(e = iterator2.next())) continue;
            return false;
        }
        return !iterator2.hasNext();
    }

    public static final boolean isSuperset(SortedSet sortedSet, SortedSet sortedSet2) {
        if (sortedSet == null) {
            return sortedSet2 == null || sortedSet2.isEmpty();
        }
        return sortedSet2 != null ? sortedSet.containsAll(sortedSet2) : true;
    }

    public static final Set diffTypes(Set set, Set set2) {
        HashSet<XMLName> hashSet = new HashSet<XMLName>();
        for (XMLName xMLName : set2) {
            if (set.contains(xMLName)) continue;
            hashSet.add(xMLName);
        }
        return hashSet;
    }

    public static final void handleException(XMLName xMLName, String string, String string2) {
        Utils.handleException(Utils.getQName(xMLName), string, string2);
    }

    public static final void handleException(QName qName, String string, String string2) {
        SOAPFaultException sOAPFaultException = new SOAPFaultException(qName, string, string2, null);
        sOAPFaultException.printStackTrace();
        throw sOAPFaultException;
    }

    public static final void handleException(Throwable throwable, String string) {
        String string2;
        QName qName = Utils.getQName(WSSEConstants.QNAME_FAULT_INVALIDSECURITY);
        if (throwable instanceof ReferenceValidationException) {
            qName = Utils.getQName(WSSEConstants.QNAME_FAULT_FAILEDCHECK);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(throwable.getMessage()).append(": ");
            ReferenceValidationException referenceValidationException = (ReferenceValidationException)((Object)throwable);
            InvalidReferenceException[] invalidReferenceExceptionArray = referenceValidationException.getInvalidReferenceExceptions();
            for (int i = 0; i < invalidReferenceExceptionArray.length; ++i) {
                InvalidReferenceException invalidReferenceException = invalidReferenceExceptionArray[i];
                stringBuffer.append("<Reference URI=\"" + invalidReferenceException.getReference().getURI() + "\" /> ");
            }
            string2 = stringBuffer.toString();
        } else if (throwable instanceof InvalidReferenceException || throwable instanceof SignatureValidationException) {
            qName = Utils.getQName(WSSEConstants.QNAME_FAULT_FAILEDCHECK);
            string2 = throwable.getMessage();
        } else {
            string2 = throwable.getMessage();
        }
        Utils.handleException(qName, string2, string);
    }

    private static QName getQName(XMLName xMLName) {
        return weblogic.xml.security.utils.Utils.getQName(xMLName);
    }
}

