/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import weblogic.xml.security.wsse.BinarySecurityToken;
import weblogic.xml.security.wsse.KeyIdentifier;
import weblogic.xml.security.wsse.internal.BaseToken;
import weblogic.xml.security.wsse.v200207.EncodedCertificate;
import weblogic.xml.security.wsse.v200207.EncodedToken;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class BinarySecurityTokenImpl
extends BaseToken
implements BinarySecurityToken,
WSSEConstants {
    private final EncodedToken encodedToken;
    private PrivateKey privateKey;

    public BinarySecurityTokenImpl(X509Certificate x509Certificate, PrivateKey privateKey) {
        this(VALUETYPE_X509V3, x509Certificate, privateKey);
    }

    public BinarySecurityTokenImpl(CertPath certPath, PrivateKey privateKey) {
        this(VALUETYPE_PKIPATH, certPath, privateKey);
    }

    public BinarySecurityTokenImpl(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        this(VALUETYPE_PKCS7, x509CertificateArray, privateKey);
    }

    private BinarySecurityTokenImpl(String string, Object object, PrivateKey privateKey) {
        if (object == null) {
            throw new IllegalArgumentException("Received null for certificate: must provide a valid certificate");
        }
        this.privateKey = privateKey;
        this.encodedToken = EncodedToken.createToken(string, object);
    }

    public BinarySecurityTokenImpl(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.encodedToken = new EncodedCertificate(xMLInputStream, string);
    }

    public String getId() {
        return this.encodedToken.getId();
    }

    public void setId(String string) {
        this.encodedToken.setId(string);
    }

    public String getEncodedValue() {
        return this.encodedToken.getEncodedValue();
    }

    public String getEncodingType() {
        return this.encodedToken.getEncodingType();
    }

    public String getValueType() {
        return this.encodedToken.getValueType();
    }

    public void toXML(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        this.toXML(xMLOutputStream, WSSE_URI, 0);
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        this.encodedToken.toXML(xMLOutputStream, string, 0);
    }

    public PublicKey getPublicKey() {
        return this.encodedToken.getPublicKey();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate getCertificate() {
        return this.encodedToken.getCertificate();
    }

    public X509Certificate[] getCertificateChain() {
        return this.encodedToken.getCertificateChain();
    }

    public CertPath getCertPath() {
        return this.encodedToken.getCertPath();
    }

    public Key getSecretKey() {
        return this.encodedToken.getSecretKey();
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.encodedToken.getKeyIdentifier();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("BinarySecurityTokenImpl:").append("\n  Id:").append(this.encodedToken.getId()).append("\n  ValueType: ").append(this.encodedToken.getValueType()).append("\n  Encoding: ").append(this.encodedToken.getEncodingType()).append("\n  Value:" + this.getCertificate());
        return stringBuffer.toString();
    }
}

