/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.io.InputStream;
import java.security.Key;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.wsse.v200207.EncodedToken;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class EncodedCertPath
extends EncodedToken {
    private CertPath certPath;
    private String encoding;

    public EncodedCertPath(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        super(xMLInputStream, string);
    }

    public EncodedCertPath(CertPath certPath) {
        this(certPath, VALUETYPE_PKIPATH);
    }

    public EncodedCertPath(CertPath certPath, String string) {
        super(ENCODING_BASE64);
        this.certPath = certPath;
        this.validateEncoding(string);
        this.encoding = string;
    }

    public void setEncoding(String string) {
        this.validateEncoding(string);
        this.encoding = string;
    }

    private void validateEncoding(String string) {
        if (!string.equals(VALUETYPE_PKIPATH) && !string.equals(VALUETYPE_PKCS7)) {
            throw new IllegalArgumentException(string + " is not a legal encoding " + "for WS Security");
        }
    }

    protected byte[] getValue() {
        try {
            return this.certPath.getEncoded(this.encoding);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new AssertionError((Object)("Unable to encode certpath: " + certificateEncodingException));
        }
    }

    Key getSecretKey() {
        return null;
    }

    X509Certificate getCertificate() {
        return (X509Certificate)this.getCertPath().getCertificates().get(0);
    }

    X509Certificate[] getCertificateChain() {
        List<? extends Certificate> list = this.getCertPath().getCertificates();
        X509Certificate[] x509CertificateArray = new X509Certificate[list.size()];
        return list.toArray(x509CertificateArray);
    }

    CertPath getCertPath() {
        if (this.certPath == null) {
            this.decodeCertPath();
        }
        return this.certPath;
    }

    private void decodeCertPath() {
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getDecodedValue());
        try {
            this.certPath = Utils.getCertFactory().generateCertPath((InputStream)unsyncByteArrayInputStream, this.encoding);
        }
        catch (CertificateException certificateException) {
            throw new AssertionError((Object)("Unable to decode certificate: " + certificateException));
        }
    }

    String getValueType() {
        if (this.encoding.equals(VALUETYPE_PKIPATH)) {
            return VALUETYPE_PKIPATH;
        }
        return VALUETYPE_PKCS7;
    }

    static void init() {
        EncodedToken.registerValueType(VALUETYPE_PKIPATH, new EncodedToken.Factory(){

            public EncodedToken newInstance(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
                return new EncodedCertPath(xMLInputStream, string);
            }

            public EncodedToken newInstance(Object object) {
                if (!(object instanceof CertPath)) {
                    throw new IllegalArgumentException("Cannot make PKIPath token from " + object);
                }
                return new EncodedCertPath((CertPath)object);
            }
        });
        EncodedToken.registerValueType(VALUETYPE_PKCS7, new EncodedToken.Factory(){

            public EncodedToken newInstance(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
                EncodedCertPath encodedCertPath = new EncodedCertPath(xMLInputStream, string);
                encodedCertPath.setEncoding(WSSEConstants.VALUETYPE_PKCS7);
                return encodedCertPath;
            }

            public EncodedToken newInstance(Object object) {
                EncodedCertPath encodedCertPath;
                if (object instanceof CertPath) {
                    encodedCertPath = new EncodedCertPath((CertPath)object, WSSEConstants.VALUETYPE_PKCS7);
                } else if (object instanceof X509Certificate[]) {
                    X509Certificate[] x509CertificateArray = (X509Certificate[])object;
                    CertPath certPath = Utils.generateCertPath(x509CertificateArray);
                    encodedCertPath = new EncodedCertPath(certPath, WSSEConstants.VALUETYPE_PKCS7);
                } else {
                    throw new IllegalArgumentException("Cannot make PKCS7 token from " + object);
                }
                return encodedCertPath;
            }
        });
    }
}

