/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.io.InputStream;
import java.security.Key;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import weblogic.utils.io.UnsyncByteArrayInputStream;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.wsse.v200207.EncodedToken;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class EncodedCertificate
extends EncodedToken {
    private static final String valueType = VALUETYPE_X509V3;
    private X509Certificate certificate;

    EncodedCertificate(X509Certificate x509Certificate) {
        super(ENCODING_BASE64);
        if (x509Certificate == null) {
            throw new IllegalArgumentException("Certificate cannot be null");
        }
        this.certificate = x509Certificate;
    }

    EncodedCertificate(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        super(xMLInputStream, string);
    }

    protected final byte[] getValue() {
        if (this.certificate != null) {
            try {
                return this.certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new AssertionError((Object)("Unable to encode certificate:" + this.certificate));
            }
        }
        return null;
    }

    X509Certificate getCertificate() {
        if (this.certificate == null) {
            UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(this.getDecodedValue());
            try {
                this.certificate = (X509Certificate)Utils.getCertFactory().generateCertificate((InputStream)unsyncByteArrayInputStream);
            }
            catch (CertificateException certificateException) {
                throw new AssertionError((Object)("Unable to decode certificate: " + certificateException));
            }
        }
        return this.certificate;
    }

    X509Certificate[] getCertificateChain() {
        X509Certificate[] x509CertificateArray = new X509Certificate[]{this.getCertificate()};
        return x509CertificateArray;
    }

    CertPath getCertPath() {
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        arrayList.add(this.certificate);
        return Utils.generateCertPath(arrayList);
    }

    final String getValueType() {
        return valueType;
    }

    Key getSecretKey() {
        return null;
    }

    static void init() {
        EncodedToken.registerValueType(VALUETYPE_X509V3, new EncodedToken.Factory(){

            public EncodedToken newInstance(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
                return new EncodedCertificate(xMLInputStream, string);
            }

            public EncodedToken newInstance(Object object) {
                if (!(object instanceof X509Certificate)) {
                    throw new IllegalArgumentException("Cannot encode " + object + " as X509 certificate");
                }
                return new EncodedCertificate((X509Certificate)object);
            }
        });
    }
}

