/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import weblogic.utils.AssertionError;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class EncodedString
implements WSSEConstants {
    private String encodingType = null;
    private String encodedValue = null;
    private String id = null;

    protected EncodedString(String string) {
        this.encodingType = string;
    }

    protected EncodedString(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    protected abstract String getElementName();

    protected abstract byte[] getValue();

    protected abstract void readAttributes(StartElement var1, Map var2) throws XMLStreamException;

    protected abstract void writeAttributes(List var1) throws XMLStreamException;

    public final void setId(String string) {
        if (string != null) {
            throw new AssertionError("Id for " + this + " already set");
        }
        this.id = string;
    }

    public final String getId() {
        if (this.id == null) {
            this.id = Utils.generateId(this.getElementName());
        }
        return this.id;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final byte[] getDecodedValue() {
        if (this.encodedValue == null) return null;
        if (this.encodingType == null) return Utils.base64(this.encodedValue);
        if (!ENCODING_BASE64.equals(this.encodingType)) throw new AssertionError("Unsupported encoding type: " + this.encodingType);
        return Utils.base64(this.encodedValue);
    }

    public final String getEncodedValue() {
        if (this.encodedValue == null) {
            if (this.encodingType != null && !ENCODING_BASE64.equals(this.encodingType)) {
                throw new AssertionError("Unsupported encoding type: " + this.encodingType);
            }
            String string = Utils.toBase64(this.getValue());
            this.encodedValue = string;
        }
        return this.encodedValue;
    }

    public String getEncodingType() {
        if (this.encodingType != null) {
            return this.encodingType;
        }
        return ENCODING_BASE64;
    }

    public final void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Object object;
        String string2 = this.getElementName();
        NSOutputStream nSOutputStream = null;
        if (xMLOutputStream instanceof NSOutputStream) {
            nSOutputStream = (NSOutputStream)xMLOutputStream;
            object = (String)nSOutputStream.getNamespaces().get(WSSE_URI);
            if (object == null) {
                nSOutputStream.addPrefix(WSSE_URI, "wsse");
            }
        } else {
            nSOutputStream = new NamespaceAwareXOS(xMLOutputStream);
            nSOutputStream.addPrefix(WSSE_URI, "wsse");
        }
        object = new ArrayList();
        this.writeAttributes((List)object);
        if (this.encodingType != null) {
            ((ArrayList)object).add(StreamUtils.createAttribute("EncodingType", this.encodingType));
        }
        ((ArrayList)object).add(ElementFactory.createAttribute(WSUConstants.WSU_URI, "Id", this.getId()));
        Attribute[] attributeArray = new Attribute[((ArrayList)object).size()];
        ((ArrayList)object).toArray(attributeArray);
        StreamUtils.addElement(nSOutputStream, string, string2, this.getEncodedValue(), attributeArray, 0, 0);
    }

    public final void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        String string2 = this.getElementName();
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, string2);
        if (startElement == null) {
            throw new XMLStreamException("Did not receive expected BinarySecurityToken");
        }
        Map map = startElement.getNamespaceMap();
        this.encodingType = StreamUtils.getAttribute(startElement, "EncodingType");
        this.readAttributes(startElement, map);
        this.id = StreamUtils.getAttribute(startElement, "Id");
        if (this.encodingType != null && !ENCODING_BASE64.equals(this.encodingType)) {
            throw new AssertionError("unsupported encodingType \"" + this.encodingType + "\"");
        }
        this.encodedValue = StreamUtils.getData(xMLInputStream, string2);
        StreamUtils.closeScope(xMLInputStream, string, string2);
    }
}

