/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.security.Key;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.wsse.KeyIdentifier;
import weblogic.xml.security.wsse.v200207.EncodedCertPath;
import weblogic.xml.security.wsse.v200207.EncodedCertificate;
import weblogic.xml.security.wsse.v200207.EncodedString;
import weblogic.xml.security.wsse.v200207.KeyIdentifierImpl;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class EncodedToken
extends EncodedString {
    private static Map ENCODED_VALUE_TYPES = new HashMap();

    private static void initFactories() {
        EncodedCertificate.init();
        EncodedCertPath.init();
    }

    static void registerValueType(String string, Factory factory) {
        ENCODED_VALUE_TYPES.put(string, factory);
    }

    static EncodedToken createToken(String string, Object object) {
        Factory factory = (Factory)ENCODED_VALUE_TYPES.get(string);
        if (factory == null) {
            throw new IllegalArgumentException("Unsupported token type: " + string);
        }
        return factory.newInstance(object);
    }

    static EncodedToken fromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement;
        try {
            startElement = (StartElement)xMLInputStream.peek();
        }
        catch (ClassCastException classCastException) {
            throw new AssertionError((Object)classCastException);
        }
        String string2 = StreamUtils.getAttribute(startElement, "ValueType");
        if (string2 == null) {
            throw new SecurityProcessingException("Unable to find valueType attr for encoded token");
        }
        Factory factory = (Factory)ENCODED_VALUE_TYPES.get(string2);
        return factory.newInstance(xMLInputStream, string);
    }

    protected EncodedToken(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        super(xMLInputStream, string);
    }

    protected EncodedToken(String string) {
        super(string);
    }

    protected final String getElementName() {
        return "BinarySecurityToken";
    }

    protected abstract byte[] getValue();

    abstract Key getSecretKey();

    abstract String getValueType();

    abstract X509Certificate getCertificate();

    abstract X509Certificate[] getCertificateChain();

    abstract CertPath getCertPath();

    KeyIdentifier getKeyIdentifier() {
        return EncodedToken.getX509KeyIdentifier(this.getCertificate());
    }

    PublicKey getPublicKey() {
        X509Certificate x509Certificate = this.getCertificate();
        PublicKey publicKey = x509Certificate == null ? null : x509Certificate.getPublicKey();
        return publicKey;
    }

    protected final void writeAttributes(List list) throws XMLStreamException {
        list.add(StreamUtils.createAttribute("ValueType", this.getValueType()));
    }

    protected void readAttributes(StartElement startElement, Map map) throws XMLStreamException {
    }

    protected static KeyIdentifier getX509KeyIdentifier(X509Certificate x509Certificate) {
        byte[] byArray = Utils.getSubjectKeyIdentifier(x509Certificate);
        KeyIdentifierImpl keyIdentifierImpl = byArray != null ? new KeyIdentifierImpl(byArray, VALUETYPE_X509SKID) : null;
        return keyIdentifierImpl;
    }

    static {
        EncodedToken.initFactories();
    }

    protected static interface Factory {
        public EncodedToken newInstance(XMLInputStream var1, String var2) throws XMLStreamException;

        public EncodedToken newInstance(Object var1);
    }
}

