/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.util.List;
import java.util.Map;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.wsse.KeyIdentifier;
import weblogic.xml.security.wsse.v200207.EncodedString;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class KeyIdentifierImpl
extends EncodedString
implements KeyIdentifier,
WSSEConstants {
    private byte[] identifier;
    private String valueType = null;

    private KeyIdentifierImpl(byte[] byArray, String string, String string2) {
        super(string);
        if (byArray == null) {
            throw new IllegalArgumentException("identifier cannot be null");
        }
        this.identifier = byArray;
        this.valueType = string2;
    }

    public KeyIdentifierImpl(byte[] byArray, String string) {
        this(byArray, ENCODING_BASE64, string);
    }

    public KeyIdentifierImpl(String string, String string2) {
        this(string.getBytes(), null, string2);
    }

    public KeyIdentifierImpl(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        super(xMLInputStream, string);
    }

    public String getIdentifierString() {
        return new String(this.getIdentifier());
    }

    public byte[] getIdentifier() {
        if (this.identifier == null) {
            this.identifier = this.getDecodedValue();
        }
        return this.identifier;
    }

    protected final String getElementName() {
        return "KeyIdentifier";
    }

    protected final byte[] getValue() {
        return this.identifier;
    }

    public final String getValueType() {
        return this.valueType;
    }

    protected final void writeAttributes(List list) {
        if (this.valueType != null) {
            list.add(StreamUtils.createAttribute("ValueType", this.valueType));
        }
    }

    protected final void readAttributes(StartElement startElement, Map map) {
        String string = StreamUtils.getAttribute(startElement, "ValueType");
        if (string != null) {
            this.valueType = string;
        }
    }
}

