/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.security.PrivateKey;
import java.util.HashSet;
import java.util.Set;
import weblogic.xml.security.encryption.DecryptXMLInputStream;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.EncryptedKeyProvider;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.ReferenceList;
import weblogic.xml.security.encryption.XMLEncReader;
import weblogic.xml.security.keyinfo.KeyProviderFactory;
import weblogic.xml.security.keyinfo.KeyResolver;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.signature.SignatureValidationException;
import weblogic.xml.security.signature.SoapVerifyXMLInputStream;
import weblogic.xml.security.utils.EventBufferInputStream;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.utils.XMLEventBuffer;
import weblogic.xml.security.utils.XMLInputStreamBase;
import weblogic.xml.security.wsse.SecureInputStream;
import weblogic.xml.security.wsse.Security;
import weblogic.xml.security.wsse.internal.SoapStreamState;
import weblogic.xml.security.wsse.v200207.BinarySecurityTokenImpl;
import weblogic.xml.security.wsse.v200207.SecurityImpl;
import weblogic.xml.security.wsse.v200207.UsernameTokenImpl;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.security.wsu.v200207.TimestampImpl;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.ElementFactory;
import weblogic.xml.stream.EndElement;
import weblogic.xml.stream.StartDocument;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputOutputStream;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class SecureInputStreamInternal
extends XMLInputStreamBase
implements WSSEConstants,
SecureInputStream {
    private static final XMLName REFERENCE_LIST = ElementFactory.createXMLName((String)"http://www.w3.org/2001/04/xmlenc#", (String)"ReferenceList");
    private static final XMLName SIGNATURE = ElementFactory.createXMLName((String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
    private static final XMLName USERNAME_TOKEN = ElementFactory.createXMLName((String)WSSE_URI, (String)"UsernameToken");
    private static final XMLName BINARY_SECURITY_TOKEN = ElementFactory.createXMLName((String)WSSE_URI, (String)"BinarySecurityToken");
    private static final XMLName TIMESTAMP = ElementFactory.createXMLName((String)WSUConstants.WSU_URI, (String)"Timestamp");
    private static final XMLName ENCRYPTED_KEY = ElementFactory.createXMLName((String)"http://www.w3.org/2001/04/xmlenc#", (String)"EncryptedKey");
    private static final boolean RETAIN_TIMESTAMPS = true;
    private final String role;
    private final XMLInputStream origin;
    private final Set processed = new HashSet();
    private String encoding;
    private KeyResolver keyResolver;
    private SecurityImpl security;

    public SecureInputStreamInternal(XMLInputStream xMLInputStream, String string, KeyResolver keyResolver) throws XMLStreamException {
        this.origin = xMLInputStream;
        this.role = string;
        this.keyResolver = keyResolver;
        this.security = null;
        this.source = null;
    }

    public KeyResolver getKeyResolver() {
        return this.keyResolver;
    }

    public void setKeyResolver(KeyResolver keyResolver) {
        if (this.source != null) {
            throw new IllegalStateException("Cannot change key resolver after stream has been read");
        }
        this.keyResolver = keyResolver;
    }

    public SecureInputStreamInternal(XMLInputStream xMLInputStream, String string, PrivateKey privateKey) throws XMLStreamException {
        this(xMLInputStream, string, new KeyResolver());
        if (privateKey != null) {
            this.keyResolver.addKeyProvider(KeyProviderFactory.create(privateKey));
        }
    }

    private static String getEncoding(XMLInputStream xMLInputStream) throws XMLStreamException {
        XMLEvent xMLEvent;
        if (xMLInputStream != null && (xMLEvent = xMLInputStream.peek()).isStartDocument()) {
            return ((StartDocument)xMLEvent).getCharacterEncodingScheme();
        }
        return null;
    }

    private static boolean findHeader(XMLInputStream xMLInputStream, XMLEventBuffer xMLEventBuffer, String string) throws XMLStreamException {
        SoapStreamState soapStreamState = new SoapStreamState();
        while (xMLInputStream.hasNext()) {
            boolean bl;
            XMLEvent xMLEvent = xMLInputStream.peek();
            switch (xMLEvent.getType()) {
                case 2: {
                    StartElement startElement = (StartElement)xMLEvent;
                    bl = soapStreamState.update(startElement);
                    if (soapStreamState.inHeader() && soapStreamState.atTypeLevel()) {
                        XMLName xMLName = startElement.getName();
                        String string2 = xMLName.getNamespaceUri();
                        if ("Security".equals(xMLName.getLocalName()) && SecureInputStreamInternal.validWSSEuri(string2)) {
                            String string3 = StreamUtils.getAttribute(startElement, "role");
                            if (string == null ? string3 == null : string.equals(string3)) {
                                return true;
                            }
                        }
                    } else if (soapStreamState.after(1)) {
                        return false;
                    }
                    SecureInputStreamInternal.bufferNext(xMLInputStream, xMLEventBuffer);
                    break;
                }
                case 4: {
                    bl = soapStreamState.update(SecureInputStreamInternal.bufferNext(xMLInputStream, xMLEventBuffer));
                    if (!bl || !soapStreamState.after(1)) break;
                    return false;
                }
                default: {
                    bl = soapStreamState.update(SecureInputStreamInternal.bufferNext(xMLInputStream, xMLEventBuffer));
                }
            }
            if (!bl) continue;
        }
        return false;
    }

    private XMLInputStream buildStream() throws XMLStreamException {
        this.encoding = SecureInputStreamInternal.getEncoding(this.origin);
        this.security = new SecurityImpl(this.role);
        this.source = this.buildStream(this.origin, this.security);
        return this.source;
    }

    private XMLInputStream buildStream(XMLInputStream xMLInputStream, SecurityImpl securityImpl) throws XMLStreamException {
        XMLEventBuffer xMLEventBuffer = new XMLEventBuffer();
        boolean bl = SecureInputStreamInternal.findHeader(xMLInputStream, xMLEventBuffer, this.role);
        if (!bl) {
            return EventBufferInputStream.reconstitute(xMLEventBuffer, xMLInputStream);
        }
        StartElement startElement = (StartElement)xMLInputStream.next();
        if (!StreamUtils.matches((XMLEvent)startElement, "Security") && !SecureInputStreamInternal.validWSSEuri(startElement.getName().getNamespaceUri())) {
            throw new AssertionError((Object)"findHeader failed");
        }
        XMLEvent xMLEvent = xMLInputStream.peek();
        while (!xMLEvent.isEndElement()) {
            if (!xMLEvent.isStartElement()) {
                xMLInputStream.next();
                xMLEvent = xMLInputStream.peek();
                continue;
            }
            if (StreamUtils.matches(xMLEvent, BINARY_SECURITY_TOKEN)) {
                this.handleBST(xMLInputStream, securityImpl, xMLEventBuffer);
            } else if (StreamUtils.matches(xMLEvent, USERNAME_TOKEN)) {
                this.handleUsernameToken(xMLInputStream, securityImpl);
            } else if (StreamUtils.matches(xMLEvent, TIMESTAMP)) {
                this.handleTimestamp(xMLInputStream, securityImpl, xMLEventBuffer);
            } else {
                if (StreamUtils.matches(xMLEvent, SIGNATURE)) {
                    return this.handleSignature(xMLInputStream, securityImpl, startElement, xMLEventBuffer);
                }
                if (StreamUtils.matches(xMLEvent, REFERENCE_LIST)) {
                    return this.handleReferenceList(xMLInputStream, securityImpl, startElement, xMLEventBuffer);
                }
                if (StreamUtils.matches(xMLEvent, ENCRYPTED_KEY)) {
                    return this.handleEncryptedKey(xMLInputStream, securityImpl, startElement, xMLEventBuffer);
                }
                if (StreamUtils.matches((XMLEvent)startElement, "Security")) {
                    throw new XMLStreamException("Unbalanced ELEMENT: Security");
                }
                weblogic.xml.security.wsse.internal.Utils.handleException(WSSEConstants.QNAME_FAULT_UNSUPPORTEDSECURITYTOKEN, startElement.getName() + " not currently supported", this.role);
            }
            xMLEvent = xMLInputStream.peek();
        }
        xMLEvent = xMLInputStream.next();
        if (!SecureInputStreamInternal.matchingEndElement(startElement, (EndElement)xMLEvent)) {
            throw new AssertionError((Object)("expected </Security>, got " + xMLEvent));
        }
        return EventBufferInputStream.reconstitute(xMLEventBuffer, xMLInputStream);
    }

    private XMLInputStream handleEncryptedKey(XMLInputStream xMLInputStream, SecurityImpl securityImpl, StartElement startElement, XMLEventBuffer xMLEventBuffer) throws XMLStreamException {
        EncryptedKey encryptedKey = (EncryptedKey)XMLEncReader.read(xMLInputStream, 2);
        securityImpl.append(encryptedKey);
        return this.buildStream(SecureInputStreamInternal.decryptStream(encryptedKey, this.keyResolver, this.encoding, SecureInputStreamInternal.reconstitute(startElement, xMLEventBuffer, xMLInputStream)), securityImpl);
    }

    private XMLInputStream handleReferenceList(XMLInputStream xMLInputStream, SecurityImpl securityImpl, StartElement startElement, XMLEventBuffer xMLEventBuffer) throws XMLStreamException {
        ReferenceList referenceList = (ReferenceList)XMLEncReader.read(xMLInputStream, 4);
        securityImpl.append(referenceList);
        return this.buildStream(SecureInputStreamInternal.decryptStream(referenceList, this.keyResolver, this.encoding, SecureInputStreamInternal.reconstitute(startElement, xMLEventBuffer, xMLInputStream)), securityImpl);
    }

    private XMLInputStream handleSignature(XMLInputStream xMLInputStream, SecurityImpl securityImpl, StartElement startElement, XMLEventBuffer xMLEventBuffer) throws XMLStreamException {
        Signature signature = (Signature)DSIGReader.read(xMLInputStream, 8);
        securityImpl.append(signature);
        return this.buildStream(SecureInputStreamInternal.verifyStream(signature, this.keyResolver, this.role, SecureInputStreamInternal.reconstitute(startElement, xMLEventBuffer, xMLInputStream)), securityImpl);
    }

    private void handleTimestamp(XMLInputStream xMLInputStream, SecurityImpl securityImpl, XMLEventBuffer xMLEventBuffer) throws XMLStreamException {
        StartElement startElement = (StartElement)xMLInputStream.peek();
        String string = StreamUtils.getAttributeByName("Id", WSUConstants.WSU_URI, startElement);
        if (string == null) {
            securityImpl.append(new TimestampImpl(xMLInputStream));
        } else if (this.processed.contains(string)) {
            this.skipElement(xMLInputStream, xMLEventBuffer);
        } else {
            XMLInputOutputStream xMLInputOutputStream = XMLOutputStreamFactory.newInstance().newInputOutputStream();
            this.copyElement(xMLInputStream, xMLEventBuffer, (XMLOutputStream)xMLInputOutputStream);
            TimestampImpl timestampImpl = new TimestampImpl((XMLInputStream)xMLInputOutputStream);
            securityImpl.append(timestampImpl);
            this.processed.add(string);
        }
    }

    private void skipElement(XMLInputStream xMLInputStream, XMLEventBuffer xMLEventBuffer) throws XMLStreamException {
        int n = 0;
        do {
            XMLEvent xMLEvent = xMLInputStream.next();
            xMLEventBuffer.add(xMLEvent);
            switch (xMLEvent.getType()) {
                case 2: {
                    ++n;
                    break;
                }
                case 4: {
                    --n;
                }
            }
        } while (n > 0);
    }

    private void copyElement(XMLInputStream xMLInputStream, XMLEventBuffer xMLEventBuffer, XMLOutputStream xMLOutputStream) throws XMLStreamException {
        int n = 0;
        do {
            XMLEvent xMLEvent = xMLInputStream.next();
            xMLEventBuffer.add(xMLEvent);
            xMLOutputStream.add(xMLEvent);
            switch (xMLEvent.getType()) {
                case 2: {
                    ++n;
                    break;
                }
                case 4: {
                    --n;
                }
            }
        } while (n > 0);
    }

    private void handleUsernameToken(XMLInputStream xMLInputStream, SecurityImpl securityImpl) throws XMLStreamException {
        securityImpl.append(new UsernameTokenImpl(xMLInputStream, WSSE_URI));
    }

    private void handleBST(XMLInputStream xMLInputStream, SecurityImpl securityImpl, XMLEventBuffer xMLEventBuffer) throws XMLStreamException {
        if (!WSSEConstants.SIGN_BST) {
            BinarySecurityTokenImpl binarySecurityTokenImpl = new BinarySecurityTokenImpl(xMLInputStream, WSSE_URI);
            this.keyResolver.addKeyProvider(KeyProviderFactory.create(binarySecurityTokenImpl));
            securityImpl.append(binarySecurityTokenImpl);
        } else {
            StartElement startElement = (StartElement)xMLInputStream.peek();
            String string = StreamUtils.getAttributeByName("Id", WSUConstants.WSU_URI, startElement);
            if (this.processed.contains(string)) {
                this.skipElement(xMLInputStream, xMLEventBuffer);
            } else {
                XMLInputOutputStream xMLInputOutputStream = XMLOutputStreamFactory.newInstance().newInputOutputStream();
                this.copyElement(xMLInputStream, xMLEventBuffer, (XMLOutputStream)xMLInputOutputStream);
                BinarySecurityTokenImpl binarySecurityTokenImpl = new BinarySecurityTokenImpl((XMLInputStream)xMLInputOutputStream, WSSE_URI);
                this.keyResolver.addKeyProvider(KeyProviderFactory.create(binarySecurityTokenImpl));
                securityImpl.append(binarySecurityTokenImpl);
                this.processed.add(string);
            }
        }
    }

    private static final XMLInputStream verifyStream(Signature signature, KeyResolver keyResolver, String string, XMLInputStream xMLInputStream) throws XMLStreamException {
        SoapVerifyXMLInputStream soapVerifyXMLInputStream;
        try {
            soapVerifyXMLInputStream = new SoapVerifyXMLInputStream(signature, xMLInputStream, keyResolver.copy());
        }
        catch (SignatureValidationException signatureValidationException) {
            weblogic.xml.security.wsse.internal.Utils.handleException(Utils.getQName(WSSEConstants.QNAME_FAULT_INVALIDSECURITYTOKEN), signatureValidationException.getMessage(), string);
            throw new AssertionError((Object)"failed to validate signature");
        }
        return soapVerifyXMLInputStream;
    }

    private static final XMLInputStream decryptStream(EncryptedKey encryptedKey, KeyResolver keyResolver, String string, XMLInputStream xMLInputStream) throws XMLStreamException {
        EncryptedKeyProvider encryptedKeyProvider;
        ReferenceList referenceList = encryptedKey.getReferenceList();
        encryptedKey.setKeyResolver(keyResolver);
        try {
            encryptedKeyProvider = new EncryptedKeyProvider(encryptedKey);
        }
        catch (EncryptionException encryptionException) {
            if (encryptionException.getMessage().indexOf("Invalid input length") > -1) {
                throw new XMLStreamException("Unable to decrypt EncryptedKey: key size of encryption/decryption mismatched", (Throwable)((Object)encryptionException));
            }
            throw new XMLStreamException("Unable to decrypt EncryptedKey", (Throwable)((Object)encryptionException));
        }
        keyResolver.addKeyProvider(encryptedKeyProvider);
        KeyResolver keyResolver2 = new KeyResolver();
        keyResolver2.addKeyProvider(encryptedKeyProvider);
        return SecureInputStreamInternal.decryptStream(referenceList, keyResolver2, string, xMLInputStream);
    }

    private static XMLInputStream decryptStream(ReferenceList referenceList, KeyResolver keyResolver, String string, XMLInputStream xMLInputStream) {
        DecryptXMLInputStream decryptXMLInputStream = new DecryptXMLInputStream(xMLInputStream, referenceList, string);
        decryptXMLInputStream.setKeyResolver(keyResolver);
        return decryptXMLInputStream;
    }

    private static final XMLInputStream reconstitute(StartElement startElement, XMLEventBuffer xMLEventBuffer, XMLInputStream xMLInputStream) throws XMLStreamException {
        while (xMLInputStream.hasNext()) {
            XMLEvent xMLEvent = xMLInputStream.peek();
            switch (xMLEvent.getType()) {
                case 2: {
                    xMLEventBuffer.add((XMLEvent)startElement);
                    return EventBufferInputStream.reconstitute(xMLEventBuffer, xMLInputStream);
                }
                case 4: {
                    if (!SecureInputStreamInternal.matchingEndElement(startElement, (EndElement)xMLEvent)) {
                        throw new AssertionError((Object)("expected </Security>, got " + xMLEvent));
                    }
                    xMLInputStream.next();
                    return EventBufferInputStream.reconstitute(xMLEventBuffer, xMLInputStream);
                }
            }
            xMLInputStream.next();
        }
        throw new XMLStreamException("stream ended unexpectedly with security header open");
    }

    private static final boolean matchingEndElement(StartElement startElement, EndElement endElement) {
        return StreamUtils.matches((XMLEvent)endElement, "Security", startElement.getName().getNamespaceUri());
    }

    private static final boolean validWSSEuri(String string) {
        return WSSEConstants.WSSE_URI.equals(string);
    }

    private static final XMLEvent bufferNext(XMLInputStream xMLInputStream, XMLEventBuffer xMLEventBuffer) throws XMLStreamException {
        XMLEvent xMLEvent = xMLInputStream.next();
        xMLEventBuffer.add(xMLEvent);
        return xMLEvent;
    }

    public Security getSecurityElement() {
        try {
            if (this.source == null) {
                this.buildStream();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new AssertionError((Object)xMLStreamException);
        }
        return this.security;
    }

    public boolean hasNext() throws XMLStreamException {
        if (this.source == null) {
            this.buildStream();
        }
        return super.hasNext();
    }

    public XMLEvent next() throws XMLStreamException {
        if (this.source == null) {
            this.buildStream();
        }
        return this.source.next();
    }

    public XMLEvent peek() throws XMLStreamException {
        if (this.source == null) {
            this.buildStream();
        }
        return super.peek();
    }
}

