/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.util.ArrayList;
import java.util.List;
import weblogic.xml.security.NamedKey;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.encryption.EncryptXMLOutputStream;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.signature.SoapSignXMLOutputStream;
import weblogic.xml.security.specs.EncryptionSpec;
import weblogic.xml.security.specs.OperationSpec;
import weblogic.xml.security.specs.SignatureSpec;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.wsse.Token;
import weblogic.xml.security.wsse.internal.EncryptingPreprocessor;
import weblogic.xml.security.wsse.internal.InsertionOutputStream;
import weblogic.xml.security.wsse.internal.Operation;
import weblogic.xml.security.wsse.internal.SigningPreprocessor;
import weblogic.xml.security.wsse.internal.SpecPreprocessorOutputStream;
import weblogic.xml.security.wsse.v200207.SecurityImpl;
import weblogic.xml.security.wsu.Timestamp;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SecureOutputPipelineFactory {
    public static XMLOutputStream createStream(SecurityImpl securityImpl, XMLOutputStream xMLOutputStream, String string, String string2) throws SecurityProcessingException {
        List list = securityImpl.getToDoList();
        String string3 = securityImpl.getRole();
        XMLOutputStream xMLOutputStream2 = xMLOutputStream;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = list.size() - 1; i >= 0; --i) {
            Object e = list.get(i);
            if (e instanceof Operation) {
                OperationSpec operationSpec;
                Object object;
                Operation operation = (Operation)e;
                Object object2 = operation.getOperation();
                arrayList.add(object2);
                if (object2 instanceof Signature) {
                    object = (Signature)object2;
                    operationSpec = (SignatureSpec)operation.getSpec();
                    xMLOutputStream2 = SecureOutputPipelineFactory.addInsertionStream(xMLOutputStream2, string3, string2, arrayList);
                    xMLOutputStream2 = operationSpec == null ? SecureOutputPipelineFactory.addSignatureStream(xMLOutputStream2, (Signature)object, SignatureSpec.getDefaultSpec()) : SecureOutputPipelineFactory.addSignatureStream(xMLOutputStream2, (Signature)object, operationSpec);
                } else if (object2 instanceof EncryptedKey) {
                    object = (EncryptedKey)object2;
                    operationSpec = (EncryptionSpec)operation.getSpec();
                    xMLOutputStream2 = SecureOutputPipelineFactory.addInsertionStream(xMLOutputStream2, string3, string2, arrayList);
                    xMLOutputStream2 = operationSpec == null ? SecureOutputPipelineFactory.addEncryptionStream(xMLOutputStream2, string, (EncryptedKey)object, EncryptionSpec.getDefaultSpec()) : SecureOutputPipelineFactory.addEncryptionStream(xMLOutputStream2, string, (EncryptedKey)object, (EncryptionSpec)operationSpec);
                } else if (object2 instanceof NamedKey) {
                    object = (NamedKey)object2;
                    operationSpec = (EncryptionSpec)operation.getSpec();
                    xMLOutputStream2 = SecureOutputPipelineFactory.addInsertionStream(xMLOutputStream2, string3, string2, arrayList);
                    xMLOutputStream2 = operationSpec == null ? SecureOutputPipelineFactory.addEncryptionStream(xMLOutputStream2, string, (NamedKey)object, EncryptionSpec.getDefaultSpec()) : SecureOutputPipelineFactory.addEncryptionStream(xMLOutputStream2, string, (NamedKey)object, (EncryptionSpec)operationSpec);
                }
            } else if (e instanceof Token) {
                arrayList.add(e);
            } else if (e instanceof Timestamp) {
                arrayList.add(e);
            } else {
                throw new SecurityProcessingException("Unknown type in Security element: " + e);
            }
            list.remove(e);
        }
        if (!arrayList.isEmpty()) {
            xMLOutputStream2 = SecureOutputPipelineFactory.addInsertionStream(xMLOutputStream2, string3, string2, arrayList);
        }
        return xMLOutputStream2;
    }

    private static XMLOutputStream addInsertionStream(XMLOutputStream xMLOutputStream, String string, String string2, List list) {
        Object[] objectArray = list.toArray();
        list.clear();
        NamespaceAwareXOS namespaceAwareXOS = xMLOutputStream instanceof NamespaceAwareXOS ? (NamespaceAwareXOS)xMLOutputStream : new NamespaceAwareXOS(xMLOutputStream);
        InsertionOutputStream insertionOutputStream = new InsertionOutputStream(string, string2, objectArray, namespaceAwareXOS);
        return insertionOutputStream;
    }

    private static XMLOutputStream addEncryptionStream(XMLOutputStream xMLOutputStream, String string, EncryptedKey encryptedKey, EncryptionSpec encryptionSpec) throws SecurityProcessingException {
        EncryptingPreprocessor encryptingPreprocessor;
        EncryptXMLOutputStream encryptXMLOutputStream = new EncryptXMLOutputStream(xMLOutputStream, string);
        try {
            encryptingPreprocessor = new EncryptingPreprocessor(encryptedKey, encryptionSpec.getEncryptionMethod(), encryptXMLOutputStream);
        }
        catch (EncryptionException encryptionException) {
            throw new SecurityProcessingException("Unable to encrypt data using EncryptionMethod " + encryptionSpec.getEncryptionMethod(), (Throwable)((Object)encryptionException));
        }
        SpecPreprocessorOutputStream specPreprocessorOutputStream = new SpecPreprocessorOutputStream(encryptXMLOutputStream, encryptionSpec, encryptingPreprocessor);
        return specPreprocessorOutputStream;
    }

    private static XMLOutputStream addEncryptionStream(XMLOutputStream xMLOutputStream, String string, NamedKey namedKey, EncryptionSpec encryptionSpec) throws SecurityProcessingException {
        EncryptingPreprocessor encryptingPreprocessor;
        EncryptXMLOutputStream encryptXMLOutputStream = new EncryptXMLOutputStream(xMLOutputStream, string);
        try {
            encryptingPreprocessor = new EncryptingPreprocessor(namedKey, encryptionSpec.getEncryptionMethod(), encryptXMLOutputStream);
        }
        catch (EncryptionException encryptionException) {
            throw new SecurityProcessingException("Unable to encrypt data using EncryptionMethod " + encryptionSpec.getEncryptionMethod(), (Throwable)((Object)encryptionException));
        }
        SpecPreprocessorOutputStream specPreprocessorOutputStream = new SpecPreprocessorOutputStream(encryptXMLOutputStream, encryptionSpec, encryptingPreprocessor);
        return specPreprocessorOutputStream;
    }

    private static XMLOutputStream addSignatureStream(XMLOutputStream xMLOutputStream, Signature signature, SignatureSpec signatureSpec) throws SecurityProcessingException {
        SoapSignXMLOutputStream soapSignXMLOutputStream = new SoapSignXMLOutputStream(xMLOutputStream);
        try {
            soapSignXMLOutputStream.addSignature(signature);
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SecurityProcessingException(xMLStreamException);
        }
        SigningPreprocessor signingPreprocessor = new SigningPreprocessor(signature, signatureSpec.getCanonicalizationMethod(), soapSignXMLOutputStream);
        SpecPreprocessorOutputStream specPreprocessorOutputStream = new SpecPreprocessorOutputStream(soapSignXMLOutputStream, signatureSpec, signingPreprocessor);
        return specPreprocessorOutputStream;
    }
}

