/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import javax.crypto.SecretKey;
import weblogic.xml.security.NamedKey;
import weblogic.xml.security.UserInfo;
import weblogic.xml.security.encryption.EncryptionAlgorithm;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.EncryptionMethod;
import weblogic.xml.security.wsse.Security;
import weblogic.xml.security.wsse.SecurityElementFactory;
import weblogic.xml.security.wsse.Token;
import weblogic.xml.security.wsse.v200207.BinarySecurityTokenImpl;
import weblogic.xml.security.wsse.v200207.SecurityImpl;
import weblogic.xml.security.wsse.v200207.UsernameTokenImpl;

public class SecurityElementFactoryImpl
extends SecurityElementFactory {
    public final Security createSecurity(String string) {
        return new SecurityImpl(string);
    }

    public Token createToken(X509Certificate[] x509CertificateArray, PrivateKey privateKey) {
        return new BinarySecurityTokenImpl(x509CertificateArray, privateKey);
    }

    public Token createToken(CertPath certPath, PrivateKey privateKey) {
        return new BinarySecurityTokenImpl(certPath, privateKey);
    }

    public final Token createToken(UserInfo userInfo) {
        return this.createToken(userInfo.getUsername(), userInfo.getPassword());
    }

    public final Token createToken(String string, String string2) {
        return new UsernameTokenImpl(string, string2);
    }

    public NamedKey createKey(String string, String string2) throws EncryptionException {
        EncryptionMethod encryptionMethod = EncryptionMethod.get(string);
        SecretKey secretKey = (SecretKey)((EncryptionAlgorithm)encryptionMethod).generateKey();
        return this.createKey(secretKey, string2);
    }

    public NamedKey createKey(SecretKey secretKey, String string) {
        return new NamedKey(secretKey, string);
    }

    public final Token createToken(String string, String string2, String string3) {
        return new UsernameTokenImpl(string, string2, string3);
    }

    public final Token createToken(X509Certificate x509Certificate, PrivateKey privateKey) {
        return new BinarySecurityTokenImpl(x509Certificate, privateKey);
    }
}

