/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import weblogic.xml.security.NamedKey;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.UserInfo;
import weblogic.xml.security.encryption.EncryptedKey;
import weblogic.xml.security.encryption.EncryptedType;
import weblogic.xml.security.encryption.EncryptionException;
import weblogic.xml.security.encryption.ReferenceList;
import weblogic.xml.security.encryption.XMLEncReader;
import weblogic.xml.security.keyinfo.KeyInfo;
import weblogic.xml.security.keyinfo.KeyInfoValidationException;
import weblogic.xml.security.signature.DSIGReader;
import weblogic.xml.security.signature.InternalReference;
import weblogic.xml.security.signature.Reference;
import weblogic.xml.security.signature.Signature;
import weblogic.xml.security.signature.XMLSignatureException;
import weblogic.xml.security.specs.EncryptionSpec;
import weblogic.xml.security.specs.OperationSpec;
import weblogic.xml.security.specs.SignatureSpec;
import weblogic.xml.security.transforms.ExcC14NTransform;
import weblogic.xml.security.transforms.IncompatibleTransformException;
import weblogic.xml.security.transforms.Transform;
import weblogic.xml.security.transforms.TransformException;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.MutableStart;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.wsse.BinarySecurityToken;
import weblogic.xml.security.wsse.Security;
import weblogic.xml.security.wsse.SecurityTokenReference;
import weblogic.xml.security.wsse.Token;
import weblogic.xml.security.wsse.UsernameToken;
import weblogic.xml.security.wsse.internal.Operation;
import weblogic.xml.security.wsse.v200207.BinarySecurityTokenImpl;
import weblogic.xml.security.wsse.v200207.UsernameTokenImpl;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.security.wsu.Expires;
import weblogic.xml.security.wsu.Timestamp;
import weblogic.xml.security.wsu.WSUFactory;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class SecurityImpl
implements WSSEConstants,
Security {
    private static final WSUFactory timestampFac = WSUFactory.getInstance(WSUConstants.WSU_URI);
    private String role = null;
    private List elements = new ArrayList(3);
    private List toDoList = new ArrayList();
    private Map tokenMap = null;

    public SecurityImpl(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public SecurityImpl(String string) {
        this.role = string;
    }

    public Signature addSignature(Token token) throws SecurityProcessingException {
        return this.addSignature(token, SignatureSpec.getDefaultSpec());
    }

    public Signature addSignature(Token token, SignatureSpec signatureSpec) throws SecurityProcessingException {
        Signature signature = new Signature();
        KeyInfo keyInfo = new KeyInfo(token);
        signature.setKeyInfo(keyInfo);
        if (WSSEConstants.SIGN_BST) {
            Iterator iterator = keyInfo.getSecurityTokenReferences();
            while (iterator.hasNext()) {
                SecurityTokenReference securityTokenReference = (SecurityTokenReference)iterator.next();
                signature.addReference(this.createReference("#" + token.getId(), token, signatureSpec));
            }
        }
        try {
            signature.setSignatureMethod(signatureSpec.getSignatureMethod());
            signature.setCanonicalizationMethod(signatureSpec.getCanonicalizationMethod());
        }
        catch (XMLSignatureException xMLSignatureException) {
            throw new SecurityProcessingException("Unable to set Method", (Throwable)((Object)xMLSignatureException));
        }
        this.prepend(signature);
        this.addToDo(signature, signatureSpec);
        return signature;
    }

    private Reference createReference(String string, Token token, SignatureSpec signatureSpec) {
        InternalReference internalReference = new InternalReference(string);
        try {
            ExcC14NTransform excC14NTransform = (ExcC14NTransform)Transform.getTransform(signatureSpec.getCanonicalizationMethod());
            internalReference.addTransform(excC14NTransform);
            this.addBSTToReference(internalReference, (BinarySecurityTokenImpl)token);
        }
        catch (IncompatibleTransformException incompatibleTransformException) {
            incompatibleTransformException.printStackTrace();
        }
        catch (TransformException transformException) {
            transformException.printStackTrace();
        }
        catch (XMLStreamException xMLStreamException) {
            xMLStreamException.printStackTrace();
        }
        return internalReference;
    }

    private void addBSTToReference(InternalReference internalReference, BinarySecurityTokenImpl binarySecurityTokenImpl) throws XMLStreamException {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        arrayList.add(ElementFactory.createAttribute("ValueType", binarySecurityTokenImpl.getValueType()));
        arrayList.add(ElementFactory.createAttribute("EncodingType", binarySecurityTokenImpl.getEncodingType()));
        arrayList.add(ElementFactory.createAttribute(WSUConstants.WSU_URI, "Id", "wsu", binarySecurityTokenImpl.getId()));
        Attribute[] attributeArray = new Attribute[arrayList.size()];
        arrayList.toArray(attributeArray);
        MutableStart mutableStart = (MutableStart)ElementFactory.createStartElement(WSSEConstants.WSSE_URI, "BinarySecurityToken", "wsse");
        for (int i = 0; i < attributeArray.length; ++i) {
            if (attributeArray[i] == null) continue;
            mutableStart.addAttribute(attributeArray[i]);
        }
        internalReference.observe((XMLEvent)mutableStart);
        internalReference.observe(ElementFactory.createCharacterData(binarySecurityTokenImpl.getEncodedValue()));
        internalReference.observe((XMLEvent)ElementFactory.createEndElement(WSSEConstants.WSSE_URI, "BinarySecurityToken", "wsse"));
    }

    public EncryptedKey addEncryption(Token token, EncryptionSpec encryptionSpec) throws SecurityProcessingException {
        X509Certificate x509Certificate;
        if (token == null && encryptionSpec != null) {
            token = encryptionSpec.getToken();
        }
        if ((x509Certificate = token != null ? token.getCertificate() : null) == null) {
            throw new SecurityProcessingException("provided token " + token + " does not support key " + "encryption");
        }
        KeyInfo keyInfo = new KeyInfo(token);
        return this.addEncryption(x509Certificate, keyInfo, encryptionSpec);
    }

    public EncryptedKey addEncryption(Token token, NamedKey namedKey, EncryptionSpec encryptionSpec) throws SecurityProcessingException {
        EncryptedKey encryptedKey = this.addEncryption(token, encryptionSpec);
        encryptedKey.setWrappedKey(namedKey.getKey());
        encryptedKey.setCarriedKeyName(namedKey.getName());
        return encryptedKey;
    }

    public ReferenceList addEncryption(NamedKey namedKey, EncryptionSpec encryptionSpec) throws SecurityProcessingException {
        ReferenceList referenceList = new ReferenceList();
        this.addToDo(namedKey.copy(referenceList), encryptionSpec);
        this.prepend(referenceList);
        return referenceList;
    }

    public EncryptedKey addEncryption(X509Certificate x509Certificate, EncryptionSpec encryptionSpec) throws SecurityProcessingException {
        if (x509Certificate == null) {
            throw new AssertionError((Object)"No certificate available for key wrapping");
        }
        return this.addEncryption(x509Certificate, new KeyInfo(((Object)x509Certificate.getSubjectDN()).toString()), encryptionSpec);
    }

    private EncryptedKey addEncryption(X509Certificate x509Certificate, KeyInfo keyInfo, EncryptionSpec encryptionSpec) throws SecurityProcessingException {
        EncryptedKey encryptedKey = null;
        try {
            PublicKey publicKey = x509Certificate.getPublicKey();
            String string = this.getWrappingAlgorithm(publicKey, encryptionSpec.getKeyWrappingMethod());
            encryptedKey = new EncryptedKey((Key)publicKey, encryptionSpec.getEncryptionMethod(), string);
        }
        catch (EncryptionException encryptionException) {
            throw new SecurityProcessingException("Problem adding encrypted key", (Throwable)((Object)encryptionException));
        }
        encryptedKey.setKeyInfo(keyInfo);
        return this.addEncryption(encryptedKey, encryptionSpec);
    }

    private EncryptedKey addEncryption(EncryptedKey encryptedKey, EncryptionSpec encryptionSpec) {
        this.prepend(encryptedKey);
        this.addToDo(encryptedKey, encryptionSpec);
        return encryptedKey;
    }

    private String getWrappingAlgorithm(Key key, String string) throws SecurityProcessingException {
        String string2 = key.getAlgorithm();
        if (!"RSA".equals(string2)) {
            throw new SecurityProcessingException("No keywrapping algorithm available for " + string2 + " keys");
        }
        String string3 = string;
        return string3;
    }

    public EncryptedKey addEncryption(Token token) throws SecurityProcessingException {
        return this.addEncryption(token, EncryptionSpec.getDefaultSpec());
    }

    public void addBinarySecurityToken(BinarySecurityToken binarySecurityToken) {
        this.addToken(binarySecurityToken);
    }

    public void addUsernameToken(UsernameToken usernameToken) {
        this.addToken(usernameToken);
    }

    public Token addToken(Token token) {
        this.tokenMap = null;
        try {
            this.updateReferenes(token);
        }
        catch (SecurityProcessingException securityProcessingException) {
            throw new IllegalStateException(securityProcessingException.getMessage());
        }
        this.prepend(token);
        this.addToDo(token);
        return token;
    }

    public Token addToken(X509Certificate x509Certificate, PrivateKey privateKey) {
        BinarySecurityTokenImpl binarySecurityTokenImpl = new BinarySecurityTokenImpl(x509Certificate, privateKey);
        return this.addToken(binarySecurityTokenImpl);
    }

    public Token addToken(UserInfo userInfo) {
        UsernameTokenImpl usernameTokenImpl = new UsernameTokenImpl(userInfo.getUsername(), userInfo.getPassword());
        return this.addToken(usernameTokenImpl);
    }

    void append(Object object) {
        if (object instanceof Token) {
            this.tokenMap = null;
        }
        this.elements.add(object);
    }

    void prepend(Object object) {
        this.elements.add(0, object);
    }

    public Iterator getChildren() {
        return this.elements.iterator();
    }

    public Iterator getTimestamps() {
        return new TypeIterator(Timestamp.class, this.elements.iterator());
    }

    public Timestamp addTimestamp() {
        return this.addTimestamp(timestampFac.createTimestamp());
    }

    public Timestamp addTimestamp(long l) {
        return this.addTimestamp(timestampFac.createTimestamp(l));
    }

    public Timestamp addTimestamp(Calendar calendar) {
        return this.addTimestamp(timestampFac.createTimestamp(calendar));
    }

    public Timestamp addTimestamp(Calendar calendar, Calendar calendar2) {
        return this.addTimestamp(timestampFac.createTimestamp(calendar, calendar2));
    }

    private Timestamp addTimestamp(Timestamp timestamp) {
        this.addToDo(timestamp);
        this.prepend(timestamp);
        return timestamp;
    }

    private void updateReferenes(Token token) throws SecurityProcessingException {
        for (Object e : this.elements) {
            KeyInfo keyInfo;
            Object object;
            if (e instanceof Signature) {
                object = (Signature)e;
                try {
                    keyInfo = ((Signature)object).getKeyInfo();
                }
                catch (KeyInfoValidationException keyInfoValidationException) {
                    throw new SecurityProcessingException("Unable to update references: " + keyInfoValidationException.getMessage(), keyInfoValidationException);
                }
                this.updateReferences(keyInfo, token);
                continue;
            }
            if (!(e instanceof EncryptedKey)) continue;
            object = (EncryptedKey)e;
            keyInfo = ((EncryptedType)object).getKeyInfo();
            this.updateReferences(keyInfo, token);
        }
    }

    private void updateReferences(KeyInfo keyInfo, Token token) {
        Iterator iterator = keyInfo.getSecurityTokenReferences();
        while (iterator.hasNext()) {
            SecurityTokenReference securityTokenReference = (SecurityTokenReference)iterator.next();
            if (!securityTokenReference.references(token)) continue;
            securityTokenReference.setReference("#" + token.getId());
        }
    }

    private Map getTokenMap() {
        if (this.tokenMap != null) {
            return this.tokenMap;
        }
        this.tokenMap = new HashMap();
        Iterator iterator = this.getTokens();
        while (iterator.hasNext()) {
            Token token = (Token)iterator.next();
            String string = token.getId();
            if (string == null) continue;
            this.tokenMap.put(string, token);
        }
        return this.tokenMap;
    }

    private Iterator getTokens() {
        return new TypeIterator(Token.class, this.elements.iterator());
    }

    public Iterator getUsernameTokens() {
        return new TypeIterator(UsernameToken.class, this.elements.iterator());
    }

    public Iterator getBinarySecurityTokens() {
        return new TypeIterator(BinarySecurityToken.class, this.elements.iterator());
    }

    public Token getTokenById(String string) {
        return (Token)this.getTokenMap().get(string);
    }

    public Iterator getSignatures() {
        return new TypeIterator(Signature.class, this.elements.iterator());
    }

    public Iterator getEncryptedKeys() {
        return new TypeIterator(EncryptedKey.class, this.elements.iterator());
    }

    public String getRole() {
        return this.role;
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "Security");
        this.role = StreamUtils.getAttribute(startElement, "role");
        XMLEvent xMLEvent = xMLInputStream.peek();
        while (!xMLEvent.isEndElement()) {
            if (!xMLEvent.isStartElement()) {
                xMLInputStream.next();
                xMLEvent = xMLInputStream.peek();
                continue;
            }
            if (StreamUtils.matches(xMLEvent, "BinarySecurityToken", string)) {
                this.append(new BinarySecurityTokenImpl(xMLInputStream, string));
            } else if (StreamUtils.matches(xMLEvent, "UsernameToken", string)) {
                this.append(new UsernameTokenImpl(xMLInputStream, string));
            } else if (StreamUtils.matches(xMLEvent, "Signature", "http://www.w3.org/2000/09/xmldsig#")) {
                this.append(DSIGReader.read(xMLInputStream, 8));
            } else if (StreamUtils.matches(xMLEvent, "ReferenceList", "http://www.w3.org/2001/04/xmlenc#")) {
                this.append(XMLEncReader.read(xMLInputStream, 4));
            } else if (StreamUtils.matches(xMLEvent, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#")) {
                this.append(XMLEncReader.read(xMLInputStream, 1));
            } else if (StreamUtils.matches(xMLEvent, "EncryptedKey", "http://www.w3.org/2001/04/xmlenc#")) {
                this.append(XMLEncReader.read(xMLInputStream, 2));
            } else {
                StreamUtils.discard(xMLInputStream);
            }
            xMLEvent = xMLInputStream.peek();
        }
        StreamUtils.closeScope(xMLInputStream, string, "Security");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[" + WSSE_URI + "]Security {\n");
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next());
        }
        stringBuffer.append("\n}");
        return stringBuffer.toString();
    }

    List getToDoList() {
        return this.toDoList;
    }

    private void addToDo(Signature signature, SignatureSpec signatureSpec) {
        this.toDoList.add(new Operation(signature, (OperationSpec)signatureSpec));
    }

    private void addToDo(EncryptedKey encryptedKey, EncryptionSpec encryptionSpec) {
        this.toDoList.add(new Operation(encryptedKey, (OperationSpec)encryptionSpec));
    }

    private void addToDo(NamedKey namedKey, EncryptionSpec encryptionSpec) {
        this.toDoList.add(new Operation(namedKey, (OperationSpec)encryptionSpec));
    }

    private void addToDo(Token token) {
        this.toDoList.add(token);
    }

    private void addToDo(Timestamp timestamp) {
        this.toDoList.add(timestamp);
    }

    public boolean expired() {
        return this.expired(-1L);
    }

    public boolean expired(long l) {
        Iterator iterator = this.getTimestamps();
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        boolean bl = true;
        while (iterator.hasNext()) {
            long l4;
            long l5;
            Timestamp timestamp = (Timestamp)iterator.next();
            if (l >= 0L && (l5 = timestamp.getCreated().getTime().getTimeInMillis()) < l3) {
                bl = false;
                break;
            }
            Expires expires = timestamp.getExpires();
            if (expires == null || (l4 = expires.getTime().getTimeInMillis()) < l2) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private static class TypeIterator
    implements Iterator {
        private final Class clazz;
        private final Iterator source;
        private Object next = null;
        private boolean used = false;

        public TypeIterator(Class clazz, Iterator iterator) {
            this.clazz = clazz;
            this.source = iterator;
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.findNext();
            return this.next != null;
        }

        private Object findNext() {
            this.used = true;
            while (this.source.hasNext()) {
                Object e = this.source.next();
                if (!this.clazz.isInstance(e)) continue;
                return e;
            }
            return null;
        }

        public Object next() {
            if (this.next != null) {
                Object object = this.next;
                this.next = null;
                return object;
            }
            Object object = this.findNext();
            if (object == null) {
                throw new NoSuchElementException();
            }
            return object;
        }

        public void remove() {
            if (!this.used) {
                throw new IllegalStateException("Iterator has not been used");
            }
            if (this.next != null) {
                throw new IllegalStateException("This iterator does not support remove() after hasNext()");
            }
            this.source.remove();
        }
    }
}

