/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.math.BigInteger;
import java.security.Key;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.keyinfo.X509IssuerSerial;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.NSOutputStream;
import weblogic.xml.security.utils.NamespaceAwareXOS;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.wsse.KeyIdentifier;
import weblogic.xml.security.wsse.SecurityTokenReference;
import weblogic.xml.security.wsse.Token;
import weblogic.xml.security.wsse.internal.BaseToken;
import weblogic.xml.security.wsse.v200207.KeyIdentifierImpl;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class SecurityTokenReferenceImpl
extends BaseToken
implements WSSEConstants,
SecurityTokenReference {
    private String reference = null;
    private KeyIdentifier identifier = null;
    private X509IssuerSerial issuerSerial = null;
    private Token token = null;
    private String id = null;

    public SecurityTokenReferenceImpl(Token token) {
        this.token = token;
    }

    public SecurityTokenReferenceImpl(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public final boolean references(Token token) {
        if (token != null) {
            return token.equals(this.token);
        }
        return false;
    }

    public final String getReference() {
        return this.reference;
    }

    public final void setReference(String string) {
        this.reference = string;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.identifier;
    }

    public X509IssuerSerial getX509IssuerSerial() {
        return this.issuerSerial;
    }

    public void setId(String string) {
        if (string != null) {
            throw new AssertionError((Object)"Id for BinarySecurityTokenImpl already set");
        }
        this.id = string;
    }

    public String getId() {
        if (this.id == null) {
            this.id = Utils.generateId("SecurityTokenReference");
        }
        return this.id;
    }

    public void setToken(Token token) {
        if (this.token != null) {
            throw new AssertionError((Object)"Token has already been set for this reference");
        }
        this.token = token;
    }

    public Token getToken() {
        return this.token;
    }

    public PrivateKey getPrivateKey() {
        if (this.token == null) {
            return null;
        }
        return this.token.getPrivateKey();
    }

    public Key getSecretKey() {
        if (this.token == null) {
            return null;
        }
        return this.token.getSecretKey();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SecurityTokenReferenceImpl:").append("\n        Id: ").append(this.id).append("\n Reference: ").append(this.reference).append("\n KeyIdentifier: ").append(this.identifier);
        return stringBuffer.toString();
    }

    public void toXML(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        this.toXML(xMLOutputStream, WSSE_URI, 0);
    }

    public void toXML(XMLOutputStream attributeArray, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray2;
        if (!(attributeArray instanceof NSOutputStream)) {
            attributeArray2 = new NamespaceAwareXOS((XMLOutputStream)attributeArray);
            attributeArray2.addPrefix(WSSE_URI, "wsse");
            attributeArray = attributeArray2;
        }
        attributeArray2 = null;
        if (this.id != null) {
            attributeArray2 = new Attribute[]{ElementFactory.createAttribute(WSUConstants.WSU_URI, "Id", this.getId())};
            StreamUtils.addStart((XMLOutputStream)attributeArray, string, "SecurityTokenReference", attributeArray2, n);
        } else {
            StreamUtils.addStart((XMLOutputStream)attributeArray, string, "SecurityTokenReference", n);
        }
        if (this.reference != null) {
            this.referenceToXML((XMLOutputStream)attributeArray, string, n);
        } else {
            this.identifier = this.token.getKeyIdentifier();
            if (this.identifier != null) {
                this.identifierToXML((XMLOutputStream)attributeArray, string, n);
            } else {
                X509Certificate x509Certificate = this.token.getCertificate();
                Principal principal = x509Certificate.getIssuerDN();
                BigInteger bigInteger = x509Certificate.getSerialNumber();
                if (principal != null && bigInteger != null) {
                    this.issuerSerial = new X509IssuerSerial(principal.getName(), bigInteger);
                    this.issuerSerialToXML((XMLOutputStream)attributeArray, n);
                } else {
                    throw new SecurityProcessingException("unable to create token reference for " + this.token);
                }
            }
        }
        StreamUtils.addEnd((XMLOutputStream)attributeArray, string, "SecurityTokenReference", n);
    }

    private void issuerSerialToXML(XMLOutputStream xMLOutputStream, int n) throws XMLStreamException {
        this.issuerSerial.toXML(xMLOutputStream, "http://www.w3.org/2000/09/xmldsig#", n);
    }

    private void identifierToXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        this.identifier.toXML(xMLOutputStream, string, n);
    }

    private void referenceToXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute(null, "URI", this.reference)};
        StreamUtils.addStart(xMLOutputStream, string, "Reference", attributeArray, n);
        StreamUtils.addEnd(xMLOutputStream, string, "Reference", n);
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "SecurityTokenReference");
        this.id = StreamUtils.getAttribute(startElement, "Id");
        XMLEvent xMLEvent = xMLInputStream.peek();
        while (!xMLEvent.isEndElement()) {
            if (!xMLEvent.isStartElement()) {
                xMLInputStream.next();
                xMLEvent = xMLInputStream.peek();
                continue;
            }
            if (StreamUtils.matches(xMLEvent, "Reference", string) && this.reference == null) {
                this.parseReference(xMLInputStream, string);
            } else if (StreamUtils.matches(xMLEvent, "KeyIdentifier", string)) {
                this.identifier = new KeyIdentifierImpl(xMLInputStream, string);
            } else if (StreamUtils.matches(xMLEvent, "X509IssuerSerial", "http://www.w3.org/2000/09/xmldsig#")) {
                this.issuerSerial = X509IssuerSerial.fromXML(xMLInputStream, "http://www.w3.org/2000/09/xmldsig#");
            } else {
                StreamUtils.discard(xMLInputStream);
            }
            xMLEvent = xMLInputStream.peek();
        }
        StreamUtils.closeScope(xMLInputStream, string, "SecurityTokenReference");
    }

    private void parseReference(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "Reference");
        this.reference = StreamUtils.getAttribute(startElement, "URI");
        StreamUtils.closeScope(xMLInputStream, string, "Reference");
    }
}

