/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsse.v200207;

import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import weblogic.xml.security.SecurityProcessingException;
import weblogic.xml.security.UserInfo;
import weblogic.xml.security.utils.ElementFactory;
import weblogic.xml.security.utils.StreamUtils;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.wsse.UsernameToken;
import weblogic.xml.security.wsse.internal.BaseToken;
import weblogic.xml.security.wsse.v200207.WSSEConstants;
import weblogic.xml.security.wsu.v200207.CreatedImpl;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class UsernameTokenImpl
extends BaseToken
implements WSSEConstants,
UsernameToken {
    private byte[] password = null;
    private String passwordType = null;
    private String passwordDigest = null;
    private byte[] username = null;
    private String id = null;
    private String b64nonce = null;
    private byte[] nonce = null;
    private CreatedImpl created = null;
    private boolean generateNonce = false;

    public UsernameTokenImpl(String string) {
        this.username = string.getBytes();
    }

    public UsernameTokenImpl(String string, String string2, String string3) {
        this(string);
        this.password = string2.getBytes();
        if (PASSWORDTYPE_PASSWORDDIGEST.equals(string3)) {
            string3 = PASSWORDTYPE_PASSWORDDIGEST;
        } else if (PASSWORDTYPE_PASSWORDTEXT.equals(string3)) {
            this.passwordType = PASSWORDTYPE_PASSWORDTEXT;
        } else {
            throw new AssertionError((Object)("Bad password type: " + string3));
        }
    }

    public UsernameTokenImpl(String string, String string2) {
        this(string, string2, PASSWORDTYPE_PASSWORDTEXT);
    }

    public UsernameTokenImpl(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream, string);
    }

    public final String getUsername() {
        return new String(this.username);
    }

    public final String getPassword() {
        return new String(this.password);
    }

    public final String getPasswordDigest() {
        return this.passwordDigest;
    }

    public final String getPasswordType() {
        return this.passwordType;
    }

    public void setId(String string) throws SecurityProcessingException {
        if (string != null) {
            throw new SecurityProcessingException("Id for UsernameToken already set");
        }
        this.id = string;
    }

    public boolean verifyDigest(String string) throws NoSuchAlgorithmException {
        if (this.nonce == null || string == null || this.created == null) {
            return false;
        }
        byte[] byArray = Utils.passwordDigest(this.nonce, this.created.getTimeString(), string);
        return Arrays.equals(byArray, Utils.base64(this.passwordDigest));
    }

    public String getId() {
        if (this.id == null) {
            this.id = Utils.generateId("UsernameToken");
        }
        return this.id;
    }

    public Key getSecretKey() {
        throw new UnsupportedOperationException("Secret keys are unsupported on this token type");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("UsernameToken:").append("\n Username:       ").append(this.username).append("\n Id:             ").append(this.id).append("\n PasswordType:   ").append(this.passwordType);
        if (this.password != null) {
            stringBuffer.append("\n Password:       ").append("****");
        }
        if (this.passwordDigest != null) {
            stringBuffer.append("\n PasswordDigest: ").append(this.passwordDigest);
        }
        if (this.b64nonce != null) {
            stringBuffer.append("\n Nonce:          ").append(this.b64nonce);
        }
        if (this.created != null) {
            stringBuffer.append("\n ").append(this.created);
        }
        return stringBuffer.toString();
    }

    public final void toXML(XMLOutputStream xMLOutputStream) throws XMLStreamException {
        this.toXML(xMLOutputStream, WSSE_URI, 0);
    }

    public void toXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException, SecurityProcessingException {
        Attribute[] attributeArray = new Attribute[]{ElementFactory.createAttribute(WSUConstants.WSU_URI, "Id", this.getId())};
        StreamUtils.addStart(xMLOutputStream, string, "UsernameToken", attributeArray, n);
        int n2 = n + 2;
        StreamUtils.addElement(xMLOutputStream, string, "Username", this.getUsername(), n2);
        if (this.password != null) {
            if (this.generateNonce || PASSWORDTYPE_PASSWORDDIGEST.equals(this.passwordType)) {
                if (this.nonce == null) {
                    this.generateNonce();
                }
                if (this.created == null) {
                    this.generateCreated();
                }
            }
            if (PASSWORDTYPE_PASSWORDTEXT.equals(this.passwordType)) {
                this.textToXML(xMLOutputStream, string, n2);
            } else if (PASSWORDTYPE_PASSWORDDIGEST.equals(this.passwordType)) {
                this.digestToXML(xMLOutputStream, string, n2);
            }
            if (this.b64nonce != null) {
                StreamUtils.addElement(xMLOutputStream, string, "Nonce", this.b64nonce, n);
            }
            if (this.created != null) {
                this.created.toXML(xMLOutputStream);
            }
        }
        StreamUtils.addEnd(xMLOutputStream, string, "UsernameToken", n);
    }

    private void textToXML(XMLOutputStream xMLOutputStream, String string, int n) throws XMLStreamException {
        Attribute[] attributeArray = new Attribute[]{StreamUtils.createAttribute("Type", PASSWORDTYPE_PASSWORDTEXT)};
        StreamUtils.addElement(xMLOutputStream, string, "Password", this.getPassword(), attributeArray, n, 0);
    }

    private void digestToXML(XMLOutputStream xMLOutputStream, String string, int n) throws SecurityProcessingException, XMLStreamException {
        if (this.passwordDigest == null) {
            this.generateDigest();
        }
        Attribute[] attributeArray = new Attribute[]{StreamUtils.createAttribute("Type", PASSWORDTYPE_PASSWORDDIGEST)};
        StreamUtils.addElement(xMLOutputStream, string, "Password", this.passwordDigest, attributeArray, n, 0);
    }

    private void generateDigest() throws SecurityProcessingException {
        byte[] byArray = null;
        try {
            byArray = Utils.passwordDigest(this.nonce, this.created.getTimeString(), this.getPassword());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityProcessingException("Digest algorithm for UsernameToken PasswordDigest unavailable", noSuchAlgorithmException);
        }
        this.passwordDigest = Utils.base64(byArray);
    }

    private void generateCreated() {
        this.created = new CreatedImpl();
    }

    private void generateNonce() {
        this.nonce = Utils.generateNonce(16);
        this.b64nonce = Utils.base64(this.nonce);
    }

    public void resetDigest() {
        this.passwordDigest = null;
    }

    private void fromXMLInternal(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "UsernameToken");
        this.id = StreamUtils.getAttribute(startElement, "Id");
        XMLEvent xMLEvent = xMLInputStream.peek();
        while (!xMLEvent.isEndElement()) {
            if (xMLEvent.isStartElement()) {
                if (StreamUtils.matches(xMLEvent, "Username", string)) {
                    this.usernameFromXML(xMLInputStream, string);
                } else if (StreamUtils.matches(xMLEvent, "Password", string)) {
                    this.passwordFromXML(xMLInputStream, string);
                } else if (StreamUtils.matches(xMLEvent, "Nonce", string)) {
                    this.nonceFromXML(xMLInputStream, string);
                } else if (StreamUtils.matches(xMLEvent, "Created", WSUConstants.WSU_URI)) {
                    this.created = new CreatedImpl(xMLInputStream);
                }
            } else {
                xMLInputStream.next();
            }
            xMLEvent = xMLInputStream.peek();
        }
        StreamUtils.closeScope(xMLInputStream, string, "UsernameToken");
    }

    private void usernameFromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.username = StreamUtils.getValue(xMLInputStream, string, "Username").getBytes();
        if (this.username == null) {
            throw new XMLStreamException("UsernameToken did not contain username");
        }
    }

    private void passwordFromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        StartElement startElement = (StartElement)StreamUtils.getElement(xMLInputStream, string, "Password");
        if (startElement == null) {
            return;
        }
        String string2 = StreamUtils.getAttribute(startElement, "Type");
        this.passwordType = string2 != null ? string2 : PASSWORDTYPE_PASSWORDTEXT;
        if (PASSWORDTYPE_PASSWORDTEXT.equals(this.passwordType)) {
            this.password = StreamUtils.getData(xMLInputStream, "Password").getBytes();
            this.passwordDigest = null;
        } else if (PASSWORDTYPE_PASSWORDDIGEST.equals(this.passwordType)) {
            this.passwordDigest = StreamUtils.getData(xMLInputStream, "Password");
        }
        StreamUtils.closeScope(xMLInputStream, string, "Password");
    }

    private void nonceFromXML(XMLInputStream xMLInputStream, String string) throws XMLStreamException {
        this.b64nonce = StreamUtils.getValue(xMLInputStream, string, "Nonce");
        this.nonce = Utils.base64(this.b64nonce);
    }

    public UserInfo getUserInfo() {
        if (this.passwordType == null || this.passwordType.equals(PASSWORDTYPE_PASSWORDDIGEST)) {
            return new UserInfo(this.getUsername(), this.passwordDigest != null ? this.passwordDigest.getBytes() : null, this.b64nonce, this.created != null ? this.created.getTimeString() : null);
        }
        return new UserInfo(this.getUsername(), this.getPassword());
    }

    public void setGenerateNonce(boolean bl) {
        this.generateNonce = bl;
    }

    public boolean isGenerateNonce() {
        return this.generateNonce;
    }

    public String getNonce() {
        if (this.b64nonce != null) {
            return this.b64nonce;
        }
        if (this.nonce != null) {
            return Utils.base64(this.nonce);
        }
        return null;
    }

    public long getCreatedTimeInMillis() {
        if (this.created == null) {
            return 0L;
        }
        return this.created.getTime().getTimeInMillis();
    }
}

