/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsu.v200207;

import java.util.Calendar;
import javax.xml.namespace.QName;
import weblogic.xml.schema.types.XSDDateTime;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.utils.ValidationException;
import weblogic.xml.security.utils.XMLReader;
import weblogic.xml.security.utils.XMLSerializable;
import weblogic.xml.security.utils.XMLWriter;
import weblogic.xml.security.wsu.AttributedDateTime;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public abstract class AttributedDateTimeBase
extends XMLSerializable
implements WSUConstants,
AttributedDateTime {
    private String id = null;
    private QName valueType = null;
    private XSDDateTime time = null;

    public AttributedDateTimeBase() {
        this(Calendar.getInstance(TZ_ZULU));
    }

    public AttributedDateTimeBase(Calendar calendar) {
        this.time = XSDDateTime.createFromCalendar((Calendar)calendar);
    }

    public AttributedDateTimeBase(String string) {
        this.time = XSDDateTime.createFromXml((String)string);
    }

    public AttributedDateTimeBase(XMLInputStream xMLInputStream) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream);
    }

    public AttributedDateTimeBase(XMLReader xMLReader) throws ValidationException {
        this.fromXMLInternal(xMLReader);
    }

    protected abstract String getLocalName();

    public void setId(String string) {
        if (string != null) {
            throw new AssertionError((Object)"Id for AttributedDateTimeBase already set");
        }
        this.id = string;
    }

    public String getId() {
        if (this.id == null) {
            this.id = Utils.generateId(this.getLocalName());
        }
        return this.id;
    }

    public String getTimeString() {
        return this.time.getXml();
    }

    public Calendar getTime() {
        return this.time.getCalendar();
    }

    public QName getValueType() {
        return this.valueType;
    }

    public void toXML(XMLWriter xMLWriter) {
        xMLWriter.writeStartElement(WSU_URI, this.getLocalName());
        this.writeAttributes(xMLWriter);
        xMLWriter.writeCharacters(this.getTimeString());
        xMLWriter.writeEndElement();
    }

    protected void writeAttributes(XMLWriter xMLWriter) {
        if (this.id != null) {
            xMLWriter.writeAttribute(WSU_URI, "Id", this.getId());
        }
        if (this.valueType != null) {
            xMLWriter.writeAttribute(WSU_URI, "ValueType", this.valueType);
        }
    }

    protected void fromXMLInternal(XMLReader xMLReader) throws ValidationException {
        String string = this.getLocalName();
        xMLReader.require(2, WSU_URI, string);
        this.readAttributes(xMLReader);
        xMLReader.next();
        xMLReader.require(16, null, null);
        String string2 = xMLReader.getText();
        try {
            this.time = XSDDateTime.createFromXml((String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ValidationException("Failed to deserialize time -" + string2, illegalArgumentException);
        }
        xMLReader.next();
        xMLReader.require(4, WSU_URI, string);
        xMLReader.next();
    }

    protected void readAttributes(XMLReader xMLReader) {
        this.id = xMLReader.getAttribute(WSU_URI, "Id");
        if (this.id == null) {
            this.id = xMLReader.getAttribute(null, "Id");
        }
        this.valueType = xMLReader.getQNameAttribute(WSU_URI, "ValueType");
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getLocalName()).append("\n   Time:      ").append(this.getTimeString()).append("\n   Id:        ").append(this.getId()).append("\n   ValueType: ").append(this.getValueType());
        return stringBuffer.toString();
    }
}

