/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsu.v200207;

import java.util.Calendar;
import weblogic.xml.security.utils.TestUtils;
import weblogic.xml.security.utils.ValidationException;
import weblogic.xml.security.utils.XMLReader;
import weblogic.xml.security.utils.XMLWriter;
import weblogic.xml.security.wsu.Received;
import weblogic.xml.security.wsu.v200207.AttributedDateTimeBase;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLStreamException;

public class ReceivedImpl
extends AttributedDateTimeBase
implements Received {
    private String delay = null;

    public ReceivedImpl() {
    }

    public ReceivedImpl(Calendar calendar) {
        super(calendar);
    }

    public ReceivedImpl(String string) {
        super(string);
    }

    public ReceivedImpl(String string, int n) {
        this(string);
        this.delay = Integer.toString(n);
    }

    public ReceivedImpl(XMLInputStream xMLInputStream) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream);
    }

    public ReceivedImpl(XMLReader xMLReader) throws ValidationException {
        this.fromXMLInternal(xMLReader);
    }

    protected final String getLocalName() {
        return "Received";
    }

    public int getDelay() {
        if (this.delay != null) {
            return Integer.decode(this.delay);
        }
        return 0;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append("\n   Delay:     ").append(this.delay);
        return stringBuffer.toString();
    }

    protected final void readAttributes(XMLReader xMLReader) {
        super.readAttributes(xMLReader);
        this.delay = xMLReader.getAttribute(WSU_URI, "Delay");
    }

    protected void writeAttributes(XMLWriter xMLWriter) {
        super.writeAttributes(xMLWriter);
        if (this.delay != null) {
            xMLWriter.writeAttribute(WSU_URI, "Delay", this.delay);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStream xMLInputStream = stringArray.length > 0 ? TestUtils.createXMLInputStreamFromFile(stringArray[0]) : TestUtils.createXMLInputStreamFromString("<wsu:Received xmlns:wsu=\"" + WSU_URI + "\"\n" + "      wsu:Id=\"myId\"" + "      wsu:ValueType=\"myBadQName\"" + "      wsu:Delay=\"1231\" >" + "2002-09-26T16:13:15Z" + "</wsu:Received>");
        ReceivedImpl receivedImpl = new ReceivedImpl(xMLInputStream);
        System.out.println(receivedImpl);
        XMLOutputStream xMLOutputStream = TestUtils.createXMLOutputStream(System.out);
        receivedImpl.toXML(xMLOutputStream);
        xMLOutputStream.flush();
    }
}

