/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.security.wsu.v200207;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.soap.SOAPElement;
import weblogic.xml.schema.binding.util.StdNamespace;
import weblogic.xml.security.utils.Utils;
import weblogic.xml.security.utils.ValidationException;
import weblogic.xml.security.utils.XMLReader;
import weblogic.xml.security.utils.XMLSerializable;
import weblogic.xml.security.utils.XMLWriter;
import weblogic.xml.security.wsu.Created;
import weblogic.xml.security.wsu.Expires;
import weblogic.xml.security.wsu.Received;
import weblogic.xml.security.wsu.Timestamp;
import weblogic.xml.security.wsu.v200207.CreatedImpl;
import weblogic.xml.security.wsu.v200207.ExpiresImpl;
import weblogic.xml.security.wsu.v200207.ReceivedImpl;
import weblogic.xml.security.wsu.v200207.WSUConstants;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;

public class TimestampImpl
extends XMLSerializable
implements Timestamp,
WSUConstants {
    private String id = null;
    private Created created = null;
    private Expires expires = null;
    private List received = null;
    private static final String XSD_TRUE = "1";
    private boolean mustUnderstand;

    public TimestampImpl() {
        this.created = new CreatedImpl();
    }

    public TimestampImpl(String string) {
        this.created = new CreatedImpl(string);
    }

    public TimestampImpl(Calendar calendar) {
        this.created = new CreatedImpl(calendar);
    }

    public TimestampImpl(String string, String string2) {
        this(string);
        this.expires = new ExpiresImpl(string2);
    }

    public TimestampImpl(XMLInputStream xMLInputStream) throws XMLStreamException {
        this.fromXMLInternal(xMLInputStream);
    }

    public TimestampImpl(SOAPElement sOAPElement) {
        this.fromXMLInternal(sOAPElement);
    }

    public void setId(String string) {
        if (string != null) {
            throw new AssertionError((Object)"Id for Timestamp already set");
        }
        this.id = string;
    }

    public void setExpires(long l) {
        if (this.created == null) {
            this.created = new CreatedImpl();
        }
        Calendar calendar = (Calendar)this.created.getTime().clone();
        calendar.add(13, (int)(l / 1000L));
        this.setExpires(calendar);
    }

    public void setExpires(Calendar calendar) {
        this.expires = new ExpiresImpl(calendar);
    }

    public void setExpires(String string) {
        this.expires = new ExpiresImpl(string);
    }

    public void setMustUnderstand(boolean bl) {
        this.mustUnderstand = bl;
    }

    public boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getId() {
        if (this.id == null) {
            this.id = Utils.generateId("Timestamp");
        }
        return this.id;
    }

    public Created getCreated() {
        return this.created;
    }

    public Expires getExpires() {
        return this.expires;
    }

    public Received[] getReceived() {
        if (this.received == null) {
            return new Received[0];
        }
        Received[] receivedArray = new Received[this.received.size()];
        receivedArray = this.received.toArray(receivedArray);
        return receivedArray;
    }

    public void toXML(XMLWriter xMLWriter) {
        xMLWriter.writeStartElement(WSU_URI, "Timestamp");
        if (this.id != null) {
            xMLWriter.writeAttribute(WSU_URI, "Id", this.getId());
        }
        String string = StdNamespace.instance().soapEnvelope();
        if (this.mustUnderstand) {
            xMLWriter.writeAttribute(string, "mustUnderstand", XSD_TRUE);
        }
        if (this.created != null) {
            this.created.toXML(xMLWriter);
        }
        if (this.expires != null) {
            this.expires.toXML(xMLWriter);
        }
        if (this.received != null) {
            for (ReceivedImpl receivedImpl : this.received) {
                receivedImpl.toXML(xMLWriter);
            }
        }
        xMLWriter.writeEndElement();
    }

    protected void fromXMLInternal(XMLReader xMLReader) throws ValidationException {
        String string;
        String string2;
        xMLReader.require(2, WSU_URI, "Timestamp");
        this.id = xMLReader.getAttribute(WSU_URI, "Id");
        int n = xMLReader.next();
        if (n == 2) {
            string2 = xMLReader.getNamespaceURI();
            string = xMLReader.getLocalName();
            if (string2.equals(WSU_URI) && string.equals("Created")) {
                this.created = new CreatedImpl(xMLReader);
                n = xMLReader.getEventType();
            }
        }
        if (n == 2) {
            string2 = xMLReader.getNamespaceURI();
            string = xMLReader.getLocalName();
            if (string2.equals(WSU_URI) && string.equals("Expires")) {
                this.expires = new ExpiresImpl(xMLReader);
                n = xMLReader.getEventType();
            }
        }
        while (n != 4) {
            int n2;
            if (n == 2) {
                string = xMLReader.getNamespaceURI();
                String string3 = xMLReader.getLocalName();
                if (WSU_URI.equals(string) && "Received".equals(string3)) {
                    this.getReceivedList().add(new ReceivedImpl(xMLReader));
                    n2 = xMLReader.getEventType();
                } else {
                    n2 = TimestampImpl.skip(xMLReader);
                }
            } else {
                switch (n) {
                    case 0: {
                        throw new ValidationException("unexpected end of document");
                    }
                    case 16: {
                        throw new ValidationException("unexpected character data");
                    }
                }
                throw new ValidationException("problem parsing Timestamp");
            }
            n = n2;
        }
        xMLReader.require(4, WSU_URI, "Timestamp");
        xMLReader.next();
    }

    public String toString() {
        return "weblogic.xml.security.wsu.v200207.TimestampImpl{id='" + this.id + "'" + ", created=" + this.created + ", expires=" + this.expires + ", received=" + (this.received == null ? null : "size:" + this.received.size() + this.received) + "}";
    }

    private List getReceivedList() {
        if (this.received == null) {
            this.received = new ArrayList();
        }
        return this.received;
    }
}

