/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import weblogic.utils.io.ChunkedInputStream;
import weblogic.utils.io.ChunkedOutputStream;

public class CachedInputStream
extends FilterInputStream {
    boolean isUserStream = true;
    boolean streamclose = false;
    ChunkedOutputStream output = new ChunkedOutputStream();

    public CachedInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.isUserStream) {
            int n3 = super.read(byArray, n, n2);
            if (n3 != -1) {
                this.output.write(byArray, n, n3);
            }
            return n3;
        }
        return super.read(byArray, n, n2);
    }

    public int read() throws IOException {
        if (this.isUserStream) {
            int n = super.read();
            if (n != -1) {
                this.output.write(n);
            }
            return n;
        }
        return super.read();
    }

    public void reset() throws IOException {
        if (this.isUserStream) {
            this.readFullstream();
            this.output.flush();
            this.output.close();
            this.in = new ChunkedInputStream(this.output.getChunks(), 0);
            this.in.mark(0);
            this.output = null;
            this.isUserStream = false;
        } else {
            this.in.reset();
            this.in.mark(0);
        }
        this.streamclose = false;
    }

    private void readFullstream() throws IOException {
        try {
            if (this.streamclose) {
                return;
            }
            byte[] byArray = new byte[512];
            while (this.read(byArray) != -1) {
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public void close() throws IOException {
        if (this.isUserStream) {
            this.readFullstream();
            this.in.close();
        }
        this.streamclose = true;
    }

    public void closeAll() throws IOException {
        if (this.isUserStream) {
            this.close();
        }
        this.reset();
        this.in.close();
    }
}

