/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import weblogic.xml.babel.stream.CanonicalInputStream;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLOutputStream;
import weblogic.xml.stream.XMLOutputStreamFactory;
import weblogic.xml.stream.XMLStreamException;

public class CanonicalDiff {
    private static final boolean debug = false;

    public static byte[] getXMLAsArray(String string) throws XMLStreamException, IOException {
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newDTDAwareInputStream((InputStream)new FileInputStream(string));
        XMLOutputStreamFactory xMLOutputStreamFactory = XMLOutputStreamFactory.newInstance();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        XMLOutputStream xMLOutputStream = xMLOutputStreamFactory.newCanonicalOutputStream((OutputStream)byteArrayOutputStream);
        xMLOutputStream.add(xMLInputStream);
        xMLOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static XMLInputStream getXMLAsStream(String string) throws XMLStreamException, IOException {
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newDTDAwareInputStream((InputStream)new FileInputStream(string));
        return new CanonicalInputStream(xMLInputStream);
    }

    public static boolean equals(XMLInputStream xMLInputStream, XMLInputStream xMLInputStream2) throws XMLStreamException, IOException {
        while (xMLInputStream.hasNext()) {
            if (!xMLInputStream2.hasNext()) {
                return false;
            }
            if (xMLInputStream.next().equals(xMLInputStream2.next())) continue;
            return false;
        }
        return !xMLInputStream2.hasNext();
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean compare(String string, String string2) throws XMLStreamException, IOException {
        byte[] byArray;
        byte[] byArray2 = CanonicalDiff.getXMLAsArray(string);
        return CanonicalDiff.equals(byArray2, byArray = CanonicalDiff.getXMLAsArray(string2));
    }

    public static boolean compare2(String string, String string2) throws XMLStreamException, IOException {
        XMLInputStream xMLInputStream;
        XMLInputStream xMLInputStream2 = CanonicalDiff.getXMLAsStream(string);
        if (CanonicalDiff.equals(xMLInputStream2, xMLInputStream = CanonicalDiff.getXMLAsStream(string2))) {
            return true;
        }
        CanonicalDiff.debug2(string, string2);
        return false;
    }

    public static void debug2(String string, String string2) throws XMLStreamException, IOException {
        XMLInputStream xMLInputStream = CanonicalDiff.getXMLAsStream(string);
        XMLInputStream xMLInputStream2 = CanonicalDiff.getXMLAsStream(string2);
        while (xMLInputStream.hasNext()) {
            if (!xMLInputStream2.hasNext()) {
                System.out.println("Stream 2 has no more elements");
                return;
            }
            XMLEvent xMLEvent = xMLInputStream.next();
            XMLEvent xMLEvent2 = xMLInputStream2.next();
            System.out.print("e1[" + xMLEvent + "]");
            if (!xMLEvent.equals(xMLEvent2)) {
                System.out.print(" != ");
            } else {
                System.out.print("  = ");
            }
            System.out.println("e2[" + xMLEvent2 + "]");
        }
        if (xMLInputStream2.hasNext()) {
            System.out.println("Stream 2 has more elements");
        }
    }

    public static void debug(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) {
                System.out.print("[equal]");
            } else {
                System.out.print("[diff ]");
            }
            System.out.println("byte[" + i + "]:\t\t" + byArray[i] + ":" + byArray2[i] + "\t--\t" + (char)byArray[i] + ":" + (char)byArray2[i]);
            if (byArray[i] != byArray2[i]) break;
        }
    }

    public static void print(String string) throws XMLStreamException, IOException {
        byte[] byArray = CanonicalDiff.getXMLAsArray(string);
        System.out.println("---------------- [ As String ] -------------");
        System.out.print(new String(byArray));
        System.out.println("---------------- [ As Bytes  ] -------------");
        for (int i = 0; i < byArray.length; ++i) {
            System.out.print(byArray[i]);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        if (CanonicalDiff.compare(stringArray[0], stringArray[1])) {
            System.out.println(stringArray[0] + " = " + stringArray[1]);
        } else {
            System.out.println(stringArray[0] + " != " + stringArray[1]);
        }
        if (CanonicalDiff.compare2(stringArray[0], stringArray[1])) {
            System.out.println(stringArray[0] + " s= " + stringArray[1]);
        } else {
            System.out.println(stringArray[0] + " s!= " + stringArray[1]);
        }
        if (stringArray.length == 3) {
            System.out.println("---------------- [ Debug ] -------------");
            CanonicalDiff.debug(CanonicalDiff.getXMLAsArray(stringArray[0]), CanonicalDiff.getXMLAsArray(stringArray[1]));
        }
    }
}

