/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import weblogic.utils.collections.CombinedIterator;

public class CompositeNamespaceContext
implements NamespaceContext {
    private final ArrayList contexts;

    public CompositeNamespaceContext(Collection collection) {
        this.contexts = new ArrayList(collection.size());
        for (NamespaceContext namespaceContext : collection) {
            if (namespaceContext == null) {
                throw new IllegalArgumentException("null contexts not allowed");
            }
            collection.add(namespaceContext);
        }
    }

    public CompositeNamespaceContext(NamespaceContext namespaceContext, NamespaceContext namespaceContext2) {
        if (namespaceContext == null || namespaceContext2 == null) {
            throw new IllegalArgumentException("null contexts not allowed");
        }
        this.contexts = new ArrayList(2);
        this.contexts.add(namespaceContext);
        this.contexts.add(namespaceContext2);
    }

    public String getNamespaceURI(String string) {
        ArrayList arrayList = this.contexts;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            NamespaceContext namespaceContext = (NamespaceContext)arrayList.get(i);
            String string2 = namespaceContext.getNamespaceURI(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public String getPrefix(String string) {
        ArrayList arrayList = this.contexts;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            NamespaceContext namespaceContext = (NamespaceContext)arrayList.get(i);
            String string2 = namespaceContext.getPrefix(string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        ArrayList arrayList = this.contexts;
        int n = arrayList.size();
        Iterator[] iteratorArray = new Iterator[n];
        for (int i = 0; i < n; ++i) {
            NamespaceContext namespaceContext = (NamespaceContext)arrayList.get(i);
            iteratorArray[i] = namespaceContext.getPrefixes(string);
        }
        return new CombinedIterator(iteratorArray);
    }
}

