/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import weblogic.management.configuration.ServerDebugMBean;
import weblogic.utils.AssertionError;

public class Debug {
    private static Debug anInstance = new Debug();
    static int minDebugLevel = 0;
    static Vector DebugFacilityExtent = new Vector();

    public static Location location(int n) {
        return anInstance.new StackTrace().location(n);
    }

    public static void setDebugLevelAll(int n) {
        Enumeration enumeration = DebugFacilityExtent.elements();
        while (enumeration.hasMoreElements()) {
            DebugFacility debugFacility = (DebugFacility)enumeration.nextElement();
            if (debugFacility.getLevel() >= n) continue;
            debugFacility.setLevel(n);
        }
        minDebugLevel = n;
    }

    public static DebugFacility makeDebugFacility(DebugSpec debugSpec) {
        Debug debug = anInstance;
        debug.getClass();
        return debug.new DebugFacility(debugSpec);
    }

    public static DebugSpec getDebugSpec() {
        return anInstance.new DebugSpec();
    }

    public static String getPackage() {
        String string = Debug.location(1).getPackage();
        return string;
    }

    public static String getClassName() {
        return Debug.getClassName(2);
    }

    private static String getClassName(int n) {
        String string = Debug.location(n).getClassName();
        return string;
    }

    public static String getFullClassName() {
        return Debug.getFullClassName(2);
    }

    private static String getFullClassName(int n) {
        String string = Debug.location(n).getFullClassName();
        return string;
    }

    public static Formatter getFormatter(OutputStream outputStream) {
        Debug debug = new Debug();
        debug.getClass();
        return debug.new StreamFormatterImpl(outputStream);
    }

    public class StreamFormatterImpl
    implements Formatter {
        PrintWriter pw = null;

        public StreamFormatterImpl(OutputStream outputStream) {
            this.pw = new PrintWriter(outputStream);
        }

        public void println(String string) {
            this.pw.println(string);
        }

        public void print(String string) {
            this.pw.print(string);
        }

        public void flush() {
            this.pw.flush();
        }
    }

    public static interface DebugFormatter
    extends Formatter {
        public void println(int var1, String var2);

        public void print(int var1, String var2);
    }

    public static interface Formatter {
        public void println(String var1);

        public void print(String var1);

        public void flush();
    }

    final class StackTrace {
        Vector stack = new Vector();

        StackTrace() {
            try {
                String string;
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                PrintStream printStream = new PrintStream(byteArrayOutputStream);
                new Exception().printStackTrace(printStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                printStream.close();
                dataInputStream.readLine();
                dataInputStream.readLine();
                dataInputStream.readLine();
                while ((string = dataInputStream.readLine()) != null) {
                    this.stack.addElement(new Location(string));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public Location location(int n) throws ArrayIndexOutOfBoundsException {
            return (Location)this.stack.elementAt(n);
        }
    }

    public class Location {
        private String pkg = "<unknown>";
        private String clazz = "<unknown>";
        private String method = "<unknown>";
        private String linenum = "<unknown>";
        private String fullClass = "<unknown>";
        private String sourcefile = "<unknown>";

        public String getPackage() {
            return this.pkg;
        }

        public String getClassName() {
            return this.clazz;
        }

        public String getMethod() {
            return this.method;
        }

        public String getLineNumber() {
            return this.linenum;
        }

        public String getFullClassName() {
            return this.fullClass;
        }

        public String getSourceFile() {
            return this.sourcefile;
        }

        public String here() {
            return this.fullClass + "." + this.method + "(" + this.sourcefile + ":" + this.linenum + ")";
        }

        public String caller() {
            return this.fullname() + "(), line " + this.linenum;
        }

        private String fullname() {
            return this.fullClass.length() > 0 ? this.fullClass + "." + this.method : this.method;
        }

        private Location(String string) {
            int n = string.indexOf("at ") + 3;
            int n2 = string.indexOf("(");
            if (n == -1 || n2 == -1) {
                return;
            }
            String string2 = string.substring(n, n2);
            if ((n2 = string2.lastIndexOf(".")) == -1) {
                return;
            }
            this.fullClass = string2.substring(0, n2);
            this.method = string2.substring(n2 + 1);
            n2 = this.fullClass.lastIndexOf(".");
            if (n2 == -1) {
                this.pkg = "<default>";
                this.clazz = this.fullClass;
            } else {
                this.pkg = this.fullClass.substring(0, n2);
                this.clazz = this.fullClass.substring(n2 + 1);
            }
            n = string.indexOf("(") + 1;
            n2 = string.indexOf(":");
            if (n == -1 || n2 == -1) {
                return;
            }
            this.sourcefile = string.substring(n, n2);
            n = n2 + 1;
            n2 = string.lastIndexOf(")");
            this.linenum = n2 != -1 ? string.substring(n, n2) : string.substring(n);
        }
    }

    public class DebugFacility
    implements DebugFormatter {
        PrintWriter wtr = null;
        DebugSpec spec = null;
        boolean initialized = false;

        private DebugFacility(DebugSpec debugSpec) {
            this.spec = debugSpec;
            this.wtr = new PrintWriter(this.spec.outStream);
            if (this.spec.name != null && this.spec.shortName) {
                int n = this.spec.name.lastIndexOf(".");
                this.spec.name = this.spec.name.substring(n + 1);
            }
            DebugFacilityExtent.add(this);
        }

        public boolean areDebugging() {
            return this.spec.level > 0;
        }

        public boolean areDebuggingAt(int n) {
            return n <= this.spec.level;
        }

        public void pl(String string) {
            this.println(string);
        }

        public void pl(int n, String string) {
            this.println(string);
        }

        public void println(String string) {
            this.print(2, string + "\n", true);
        }

        public void println(int n, String string) {
            this.print(n, string + "\n", true);
        }

        public void pw(String string) {
            this.printWarning(string);
        }

        public void pe(String string) {
            this.printError(string);
        }

        public void printWarning(String string) {
            this.println(1, "WARNING: " + string);
        }

        public void printError(String string) {
            this.println(1, "ERROR: " + string);
        }

        public void print(String string) {
            this.print(2, string, true);
        }

        public void print(int n, String string) {
            this.print(n, string, true);
        }

        public int getLevel() {
            return this.spec.level;
        }

        public void setLevel(int n) {
            this.spec.level = n;
        }

        public void setName(String string) {
            this.spec.name = string;
        }

        public void setPrefix(String string) {
            this.spec.prefix = string;
        }

        public void setOutStream(OutputStream outputStream) {
            this.spec.outStream = outputStream;
        }

        public void setIncludeTime(boolean bl) {
            this.spec.includeTime = bl;
        }

        public void setIncludeName(boolean bl) {
            this.spec.includeName = bl;
        }

        public void setIncludeClass(boolean bl) {
            this.spec.includeClass = bl;
        }

        public void setIncludeLocation(boolean bl) {
            this.spec.includeLocation = bl;
        }

        public void setShortName(boolean bl) {
            this.spec.shortName = bl;
        }

        public void setShortClass(boolean bl) {
            this.spec.shortClass = bl;
        }

        public void setMBean(ServerDebugMBean serverDebugMBean) {
            if (this.spec.prefix == null) {
                return;
            }
            int n = 0;
            String string = null;
            OutputStream outputStream = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (this.spec.prefix.equals("JAXP")) {
                try {
                    n = serverDebugMBean.getDebugJAXPDebugLevel();
                    string = serverDebugMBean.getDebugJAXPDebugName();
                    outputStream = serverDebugMBean.getDebugJAXPOutputStream();
                    bl = serverDebugMBean.getDebugJAXPIncludeTime();
                    bl2 = serverDebugMBean.getDebugJAXPIncludeName();
                    bl3 = serverDebugMBean.getDebugJAXPIncludeClass();
                    bl4 = serverDebugMBean.getDebugJAXPIncludeLocation();
                    bl5 = serverDebugMBean.getDebugJAXPUseShortClass();
                }
                catch (Exception exception) {}
            } else if (this.spec.prefix.equals("XMLRegistry")) {
                try {
                    n = serverDebugMBean.getDebugXMLRegistryDebugLevel();
                    string = serverDebugMBean.getDebugXMLRegistryDebugName();
                    outputStream = serverDebugMBean.getDebugXMLRegistryOutputStream();
                    bl = serverDebugMBean.getDebugXMLRegistryIncludeTime();
                    bl2 = serverDebugMBean.getDebugXMLRegistryIncludeName();
                    bl3 = serverDebugMBean.getDebugXMLRegistryIncludeClass();
                    bl4 = serverDebugMBean.getDebugXMLRegistryIncludeLocation();
                    bl5 = serverDebugMBean.getDebugXMLRegistryUseShortClass();
                }
                catch (Exception exception) {}
            } else if (this.spec.prefix.equals("XMLEntityCache")) {
                try {
                    n = serverDebugMBean.getDebugXMLEntityCacheDebugLevel();
                    string = serverDebugMBean.getDebugXMLEntityCacheDebugName();
                    outputStream = serverDebugMBean.getDebugXMLEntityCacheOutputStream();
                    bl = serverDebugMBean.getDebugXMLEntityCacheIncludeTime();
                    bl2 = serverDebugMBean.getDebugXMLEntityCacheIncludeName();
                    bl3 = serverDebugMBean.getDebugXMLEntityCacheIncludeClass();
                    bl4 = serverDebugMBean.getDebugXMLEntityCacheIncludeLocation();
                    bl5 = serverDebugMBean.getDebugXMLEntityCacheUseShortClass();
                }
                catch (Exception exception) {}
            } else {
                throw new IllegalArgumentException(this.spec.prefix + " prefix not supported");
            }
            if (n > this.getLevel()) {
                this.setLevel(n);
            }
            if (string != null) {
                this.setName(string);
            }
            if (outputStream != null) {
                this.setOutStream(outputStream);
            }
            this.setIncludeTime(bl);
            this.setIncludeName(bl2);
            this.setIncludeClass(bl3);
            this.setIncludeLocation(bl4);
            this.setShortClass(bl5);
        }

        private synchronized void print(int n, String string, boolean bl) {
            if (!this.initialized) {
                this.initialize();
            }
            if (!this.areDebuggingAt(n)) {
                return;
            }
            this.wtr.print("DBG:");
            if (this.spec.includeTime) {
                this.wtr.print(" " + new Date());
            }
            if (this.spec.includeName || this.spec.includeLocation) {
                this.wtr.print(" (");
                if (this.spec.includeName) {
                    this.wtr.print(this.spec.name);
                }
                if (this.spec.includeClass) {
                    String string2;
                    if (this.spec.includeName) {
                        this.wtr.print(", ");
                    }
                    if ((string2 = Debug.getFullClassName(4)) != null && this.spec.shortClass) {
                        int n2 = string2.lastIndexOf(".");
                        string2 = string2.substring(n2 + 1);
                    }
                    this.wtr.print(string2);
                }
                if (this.spec.includeLocation) {
                    if (this.spec.includeName || this.spec.includeClass) {
                        this.wtr.print(", ");
                    }
                    this.wtr.print(Debug.location(2).here());
                }
                this.wtr.print(")");
            }
            this.wtr.print(" " + string);
            if (bl) {
                this.wtr.flush();
            }
        }

        public PrintWriter getWriter() {
            return this.wtr;
        }

        public void flush() {
            this.wtr.flush();
        }

        public void setDebugLevel(int n) {
            this.spec.level = n;
        }

        private void initialize() {
            String string = this.spec.name;
            try {
                Integer n;
                String string2 = System.getProperty("DebugSpec");
                if (string2 != null) {
                    this.initializeFromPropertries(string2);
                }
                if ((string2 = System.getProperty("DebugSpec." + string)) != null) {
                    this.initializeFromPropertries(string2);
                }
                if ((n = Integer.getInteger("DebugLevel." + string)) != null) {
                    this.setLevel(n);
                } else {
                    n = Integer.getInteger("DebugLevel");
                    this.setLevel(n);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.initialized = true;
        }

        private void setLevel(Integer n) {
            if (n != null && n > minDebugLevel) {
                this.spec.level = n;
            }
        }

        private void initializeFromPropertries(String string) {
            try {
                FileInputStream fileInputStream = new FileInputStream(string);
                Properties properties = new Properties();
                properties.load(fileInputStream);
                String string2 = properties.getProperty("level");
                String string3 = properties.getProperty("includeTime");
                String string4 = properties.getProperty("includeLocation");
                String string5 = properties.getProperty("outputFile");
                String string6 = properties.getProperty("name");
                String string7 = properties.getProperty("includeName");
                String string8 = properties.getProperty("shortName");
                String string9 = properties.getProperty("includeClass");
                String string10 = properties.getProperty("shortClass");
                if (string2 != null) {
                    try {
                        this.setLevel((int)Integer.valueOf(string2));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string3 != null) {
                    try {
                        this.spec.includeTime = Boolean.valueOf(string3);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string4 != null) {
                    try {
                        this.spec.includeLocation = Boolean.valueOf(string4);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string5 != null) {
                    try {
                        this.spec.outStream = new FileOutputStream(string5);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string6 != null) {
                    this.spec.name = string6;
                }
                if (string7 != null) {
                    try {
                        this.spec.includeName = Boolean.valueOf(string7);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string8 != null) {
                    try {
                        this.spec.shortName = Boolean.valueOf(string8);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string9 != null) {
                    try {
                        this.spec.includeClass = Boolean.valueOf(string9);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string10 != null) {
                    try {
                        this.spec.shortClass = Boolean.valueOf(string10);
                    }
                    catch (Exception exception) {}
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void assertion(boolean bl) {
            this.assertion(1, bl, "");
        }

        public void assertion(boolean bl, String string) {
            this.assertion(1, bl, string);
        }

        public void assertion(int n, boolean bl) {
            this.assertion(n, bl, "");
        }

        public void assertion(int n, boolean bl, String string) {
            if (this.areDebuggingAt(n) && !bl) {
                throw new AssertionError("Assertion violated");
            }
        }

        public void px(Throwable throwable) {
            this.pxI(throwable, "", 2, 2);
        }

        public void px(Throwable throwable, String string) {
            this.pxI(throwable, string, 2, 2);
        }

        public void px(Throwable throwable, int n) {
            this.pxI(throwable, "", n, n);
        }

        public void px(Throwable throwable, String string, int n) {
            this.pxI(throwable, string, n, n);
        }

        public void px(Throwable throwable, int n, int n2) {
            this.pxI(throwable, "", n, n2);
        }

        public void px(Throwable throwable, String string, int n, int n2) {
            this.pxI(throwable, string, n, n2);
        }

        private synchronized void pxI(Throwable throwable, String string, int n, int n2) {
            if (throwable == null) {
                return;
            }
            int n3 = n;
            if (n2 < n) {
                n3 = n2;
            }
            if (n3 > this.spec.level) {
                return;
            }
            this.println(n3, "---------------------------------------------------------------------");
            if (this.areDebuggingAt(n)) {
                this.println(n3, "*** Exception: " + throwable);
                this.println(n3, "*** Caught from: " + Debug.location(2).here());
                this.println(n3, "*** Associated message: " + string);
            }
            if (this.areDebuggingAt(n2)) {
                this.println(n3, "*** Stack trace:");
                throwable.printStackTrace(this.wtr);
            }
            this.println(n3, "---------------------------------------------------------------------");
            this.wtr.flush();
        }

        public class DebugListener
        implements PropertyChangeListener {
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (("Debug" + DebugFacility.this.spec.prefix + "DebugLevel").equals(string)) {
                    DebugFacility.this.setLevel((int)((Integer)propertyChangeEvent.getNewValue()));
                } else if (("Debug" + DebugFacility.this.spec.prefix + "DebugName").equals(string)) {
                    DebugFacility.this.setName((String)propertyChangeEvent.getNewValue());
                } else if (("Debug" + DebugFacility.this.spec.prefix + "OutputStream").equals(string)) {
                    DebugFacility.this.setOutStream((OutputStream)propertyChangeEvent.getNewValue());
                } else if (("Debug" + DebugFacility.this.spec.prefix + "IncludeTime").equals(string)) {
                    DebugFacility.this.setIncludeTime((Boolean)propertyChangeEvent.getNewValue());
                } else if (("Debug" + DebugFacility.this.spec.prefix + "IncludeName").equals(string)) {
                    DebugFacility.this.setIncludeName((Boolean)propertyChangeEvent.getNewValue());
                } else if (("Debug" + DebugFacility.this.spec.prefix + "IncludeClass").equals(string)) {
                    DebugFacility.this.setIncludeClass((Boolean)propertyChangeEvent.getNewValue());
                } else if (("Debug" + DebugFacility.this.spec.prefix + "IncludeLocation").equals(string)) {
                    DebugFacility.this.setIncludeLocation((Boolean)propertyChangeEvent.getNewValue());
                } else if (("Debug" + DebugFacility.this.spec.prefix + "UseShortName").equals(string)) {
                    DebugFacility.this.setShortName((Boolean)propertyChangeEvent.getNewValue());
                } else if (("Debug" + DebugFacility.this.spec.prefix + "UseShortClass").equals(string)) {
                    DebugFacility.this.setShortClass((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        }
    }

    public class DebugSpec {
        public int level = minDebugLevel;
        public boolean includeTime = false;
        public boolean includeLocation = false;
        public OutputStream outStream = System.out;
        public String name = null;
        public String prefix = null;
        public boolean includeName = true;
        public boolean shortName = false;
        public boolean includeClass = false;
        public boolean shortClass = true;

        public void dump(PrintStream printStream) {
            printStream.println("DUMP of debug spec:");
            printStream.println("  level: " + this.level);
            printStream.println("  includeTime: " + this.includeTime);
            printStream.println("  includeLocation: " + this.includeLocation);
            printStream.println("  outStream: " + this.outStream);
            printStream.println("  name: " + this.name);
            printStream.println("  prefix: " + this.prefix);
            printStream.println("  includeName: " + this.includeName);
            printStream.println("  shortName: " + this.shortName);
            printStream.println("  includeClass: " + this.includeClass);
            printStream.println("  shortClass: " + this.shortClass);
        }
    }
}

