/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import weblogic.xml.process.XMLParsingException;
import weblogic.xml.util.ParsingUtils;
import weblogic.xml.util.XMLConstants;

public final class DocumentType
implements XMLConstants {
    private static final boolean debug = System.getProperty("weblogic.xml.debug") != null;
    private static final String DOCTYPE_DECL_START = "<!DOCTYPE";
    private static final String[] ROOT_NAME_STOP = new String[]{"[", "\t", "\r", " ", "\n", ">"};
    private static final String[] ELEMENT_NAME_STOP = new String[]{"/", "\t", "\r", " ", "\n", ">"};
    private static final String[] EXTERNAL_ID_START = new String[]{"PUBLIC", "SYSTEM", ">"};
    private static final String[] QUOTES = new String[]{"\"", "'"};
    private static final String[] WHITE_SPACE = new String[]{"\t", "\r", " ", "\n"};
    private String rootTag;
    private String publicId;
    private String systemId;

    public DocumentType(String string, String string2, String string3) {
        this.publicId = string;
        this.systemId = string2;
        this.rootTag = string3;
    }

    public DocumentType(InputSource inputSource, boolean bl) throws IOException, SAXException, XMLParsingException {
        this(DocumentType.getReader(inputSource), bl);
    }

    public DocumentType(Reader reader, boolean bl) throws IOException, SAXException, XMLParsingException {
        block14: {
            if (reader == null) {
                throw new SAXException("Document input stream was null");
            }
            if (bl && !reader.markSupported()) {
                throw new XMLParsingException("Cannot read stream with reset=true because it does not support mark");
            }
            if (debug) {
                System.out.println("DocumentType: reset = " + bl);
            }
            if (bl) {
                reader.mark(1000);
            }
            PushbackReader pushbackReader = new PushbackReader(reader, 1000);
            try {
                Object object;
                do {
                    if (debug) {
                        System.out.println("advancing to '<'");
                    }
                    String string = ParsingUtils.read(pushbackReader, "<", false);
                    if (debug) {
                        System.out.println("\"" + string + "\"");
                    }
                    if (DocumentType.startDocTypeDecl(pushbackReader)) {
                        object = DocumentType.docTypeDecl(pushbackReader);
                        this.rootTag = ((DocTypeDecl)object).rootTag;
                        this.publicId = ((DocTypeDecl)object).publicId;
                        this.systemId = ((DocTypeDecl)object).systemId;
                        break block14;
                    }
                    if (DocumentType.startElementTag(pushbackReader)) {
                        this.rootTag = DocumentType.elementTag(pushbackReader);
                        this.systemId = DocumentType.retrieveSchemaSystemId(pushbackReader);
                        break block14;
                    }
                    pushbackReader.read();
                    object = ParsingUtils.peek(pushbackReader, 1);
                } while ("?!/".indexOf((String)object) >= 0);
                throw new XMLParsingException("Cannot locate DOCTYPE header or root element");
            }
            catch (EOFException eOFException) {
                throw new XMLParsingException("Cannot locate DOCTYPE header or root element");
            }
        }
        if (bl) {
            try {
                reader.reset();
            }
            catch (IOException iOException) {
                throw new IOException("Could not reset mark because read too far");
            }
        }
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getRootElementTag() {
        return this.rootTag;
    }

    public boolean equals(Object object) {
        DocumentType documentType = null;
        try {
            documentType = (DocumentType)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return DocumentType.nullableStringEquals(this.publicId, documentType.publicId) && DocumentType.nullableStringEquals(this.systemId, documentType.systemId) && DocumentType.nullableStringEquals(this.rootTag, documentType.rootTag);
    }

    public int hashCode() {
        int n = 0;
        if (this.publicId != null) {
            n ^= this.publicId.hashCode();
        }
        if (this.systemId != null) {
            n ^= this.systemId.hashCode();
        }
        if (this.rootTag != null) {
            n ^= this.rootTag.hashCode();
        }
        return n;
    }

    private static boolean nullableStringEquals(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private static String readQuotedLiteral(PushbackReader pushbackReader) throws IOException {
        if (debug) {
            System.out.println("reading quoted literal:");
        }
        if (debug) {
            System.out.println("reading through first quote");
        }
        String string = ParsingUtils.read(pushbackReader, QUOTES, true);
        char c = string.charAt(string.length() - 1);
        if (debug) {
            System.out.println("quote type is " + c);
        }
        String string2 = new String(new char[]{c});
        if (debug) {
            System.out.println("reading until close quote");
        }
        String string3 = ParsingUtils.read(pushbackReader, string2, false);
        ParsingUtils.read(pushbackReader, string2, true);
        return string3;
    }

    private static Reader getReader(InputSource inputSource) throws XMLParsingException, SAXException {
        Reader reader = inputSource.getCharacterStream();
        if (reader == null) {
            InputStream inputStream = inputSource.getByteStream();
            if (inputStream != null) {
                reader = new InputStreamReader(inputStream);
            } else {
                String string = inputSource.getSystemId();
                try {
                    if (debug) {
                        System.out.println("Trying to open file " + string);
                    }
                    if (string != null) {
                        reader = new FileReader(string);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    try {
                        if (debug) {
                            System.out.println("Not found. Trying to open URL " + string);
                        }
                        reader = new InputStreamReader(new URL(string).openStream());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        if (reader == null) {
            if (debug) {
                System.out.println("SystemID = " + inputSource.getSystemId());
            }
            throw new SAXException("Could not open or read input source");
        }
        return reader;
    }

    public static void dumpReader(Reader reader) throws IOException {
        char[] cArray = new char[1000];
        while (reader.read(cArray) > 0) {
            System.out.print(cArray);
        }
        System.out.println("");
    }

    private static boolean startElementTag(PushbackReader pushbackReader) throws IOException {
        String string = ParsingUtils.peek(pushbackReader, 2);
        return string.charAt(0) == '<' && Character.isLetter(string.charAt(1));
    }

    private static boolean startDocTypeDecl(PushbackReader pushbackReader) throws IOException {
        return DOCTYPE_DECL_START.equals(ParsingUtils.peek(pushbackReader, DOCTYPE_DECL_START.length()));
    }

    private static boolean startExternalId(PushbackReader pushbackReader) throws IOException {
        return !"[".equals(ParsingUtils.peek(pushbackReader, 1));
    }

    private static ExternalId externalId(PushbackReader pushbackReader) throws IOException {
        ExternalId externalId = new ExternalId();
        if (debug) {
            System.out.println("reading external id start");
        }
        String string = ParsingUtils.read(pushbackReader, EXTERNAL_ID_START, true);
        if (debug) {
            System.out.println("external id start = " + string);
        }
        if (debug) {
            System.out.println("reading through WS");
        }
        ParsingUtils.readWS(pushbackReader);
        if ("SYSTEM".equals(string)) {
            externalId.systemId = DocumentType.readQuotedLiteral(pushbackReader);
            if (debug) {
                System.out.println("reading system ID = \"" + externalId.systemId + "\"");
            }
        } else if ("PUBLIC".equals(string)) {
            externalId.publicId = DocumentType.readQuotedLiteral(pushbackReader);
            if (debug) {
                System.out.println("reading public ID = \"" + externalId.publicId + "\"");
            }
            if (debug) {
                System.out.println("reading through WS");
            }
            ParsingUtils.readWS(pushbackReader);
            externalId.systemId = DocumentType.readQuotedLiteral(pushbackReader);
            if (debug) {
                System.out.println("reading system ID = \"" + externalId.systemId + "\"");
            }
        }
        return externalId;
    }

    private static DocTypeDecl docTypeDecl(PushbackReader pushbackReader) throws IOException {
        DocTypeDecl docTypeDecl = new DocTypeDecl();
        if (debug) {
            System.out.println("reading through <!DOCTYPE");
        }
        ParsingUtils.read(pushbackReader, DOCTYPE_DECL_START, true);
        if (debug) {
            System.out.println("reading through WS");
        }
        ParsingUtils.readWS(pushbackReader);
        if (debug) {
            System.out.println("reading through root tag name");
        }
        docTypeDecl.rootTag = ParsingUtils.read(pushbackReader, ROOT_NAME_STOP, false);
        ParsingUtils.readWS(pushbackReader);
        if (debug) {
            System.out.println("read root tag name = " + docTypeDecl.rootTag);
        }
        if (DocumentType.startExternalId(pushbackReader)) {
            ExternalId externalId = DocumentType.externalId(pushbackReader);
            docTypeDecl.publicId = externalId.publicId;
            docTypeDecl.systemId = externalId.systemId;
        }
        return docTypeDecl;
    }

    private static String elementTag(PushbackReader pushbackReader) throws IOException {
        if (debug) {
            System.out.println("reading element tag start");
        }
        ParsingUtils.read(pushbackReader, "<", true);
        String string = ParsingUtils.read(pushbackReader, ELEMENT_NAME_STOP, false);
        return string;
    }

    private static String retrieveSchemaSystemId(PushbackReader pushbackReader) throws IOException {
        String string = ParsingUtils.read(pushbackReader, new String[]{"schemaLocation", ">"}, true);
        if (string != null && !"".equals(string) && string.charAt(string.length() - 1) == '>') {
            return null;
        }
        if (debug) {
            System.out.println("reading schemaLocation:");
        }
        if (debug) {
            System.out.println("reading through first quote");
        }
        String string2 = ParsingUtils.read(pushbackReader, QUOTES, true);
        char c = string2.charAt(string2.length() - 1);
        if (debug) {
            System.out.println("quote type is " + c);
        }
        String string3 = new String(new char[]{c});
        if (debug) {
            System.out.println("reading until close quote or white space");
        }
        String[] stringArray = new String[WHITE_SPACE.length + 1];
        System.arraycopy(WHITE_SPACE, 0, stringArray, 0, WHITE_SPACE.length);
        stringArray[stringArray.length - 1] = string3;
        String string4 = ParsingUtils.read(pushbackReader, stringArray, false);
        String string5 = ParsingUtils.peek(pushbackReader, 1);
        if (string5.equals(string3)) {
            return string4;
        }
        ParsingUtils.readWS(pushbackReader);
        string4 = ParsingUtils.read(pushbackReader, stringArray, false);
        return string4;
    }

    private static class DocTypeDecl {
        public String publicId;
        public String systemId;
        public String rootTag;

        private DocTypeDecl() {
        }
    }

    private static class ExternalId {
        public String publicId;
        public String systemId;

        private ExternalId() {
        }
    }
}

