/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.io.IOException;
import java.io.PrintWriter;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DocumentWriter {
    public static void write(Document document, PrintWriter printWriter) throws IOException {
        DocumentWriter.printNode(document, printWriter, 0);
    }

    public static void write(Node node, PrintWriter printWriter) throws IOException {
        DocumentWriter.printNode(node, printWriter, 0);
    }

    private static void printNode(Node node, PrintWriter printWriter, int n) {
        Object object;
        DocumentWriter.indent(n, printWriter);
        if (node.getNodeType() == 1) {
            printWriter.print("<" + node.getNodeName());
        } else if (node.getNodeType() == 3) {
            printWriter.print(((Text)node).getData());
        } else if (node.getNodeType() == 8) {
            printWriter.print("<!--" + ((Comment)node).getData() + "-->");
            printWriter.print("\n");
        }
        if (node.getNodeType() != 9) {
            object = node.getAttributes();
            if (object != null) {
                int n2 = object.getLength();
                for (int i = 0; i < n2; ++i) {
                    Node node2 = object.item(i);
                    DocumentWriter.indent(n + 2, printWriter);
                    printWriter.print(node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
                }
            }
            if (node.hasChildNodes() && object.getLength() != 0) {
                DocumentWriter.indent(n, printWriter);
                printWriter.print(">");
            } else if (node.hasChildNodes() && object.getLength() == 0) {
                printWriter.print(">");
            }
        }
        if ((object = node.getChildNodes()).getLength() > 0) {
            DocumentWriter.printNodeList((NodeList)object, printWriter, n + 2);
            DocumentWriter.indent(n, printWriter);
            if (node.getNodeType() != 8 && node.getNodeType() != 9) {
                printWriter.print("</" + node.getNodeName() + ">");
            }
        } else {
            DocumentWriter.indent(n, printWriter);
            if (node.getNodeType() == 1) {
                printWriter.print("/>");
            }
        }
    }

    private static void printNodeList(NodeList nodeList, PrintWriter printWriter, int n) {
        int n2;
        int n3 = nodeList.getLength();
        for (n2 = 0; n2 < n3; ++n2) {
            if (nodeList.item(n2).getNodeType() != 8) continue;
            DocumentWriter.printNode(nodeList.item(n2), printWriter, n);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (nodeList.item(n2).getNodeType() == 8) continue;
            DocumentWriter.printNode(nodeList.item(n2), printWriter, n);
        }
    }

    private static void indent(int n, PrintWriter printWriter) {
        printWriter.print("\n");
        for (int i = 0; i < n; ++i) {
            printWriter.print(" ");
        }
    }
}

