/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.transform.Source;
import org.xml.sax.InputSource;
import weblogic.xml.babel.reader.XmlReader;

public final class InputFormats {
    public static Reader resolveSystemID(String string) throws IOException {
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            return XmlReader.createReader((InputStream)fileInputStream);
        }
        catch (IOException iOException) {
            URL uRL = new URL(string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
            return XmlReader.createReader((InputStream)bufferedInputStream);
        }
    }

    public static Reader resolveInputSource(InputSource inputSource) throws IOException {
        if (inputSource.getCharacterStream() != null) {
            return inputSource.getCharacterStream();
        }
        if (inputSource.getByteStream() != null) {
            return XmlReader.createReader((InputStream)inputSource.getByteStream());
        }
        if (inputSource.getSystemId() != null) {
            return InputFormats.resolveSystemID(inputSource.getSystemId());
        }
        throw new IOException("Unable to resolve input source.");
    }

    public static Reader resolveSource(Source source) throws IOException {
        return InputFormats.resolveSystemID(source.getSystemId());
    }
}

