/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import org.xml.sax.InputSource;

public class InputSourceUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getInputByteData(InputSource inputSource) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] byArray;
        block7: {
            InputStream inputStream = null;
            byArray = null;
            inputStream = inputSource.getByteStream();
            if (inputStream == null) {
                return null;
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            int n = 0;
            try {
                while ((n = inputStream.read(byArray2)) != -1) {
                    byteArrayOutputStream.write(byArray2, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                Object var7_6 = null;
                if (inputStream == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (inputStream != null) {
                    inputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                throw throwable;
            }
            inputStream.close();
        }
        if (byteArrayOutputStream != null) {
            byteArrayOutputStream.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] getInputCharData(InputSource inputSource) throws IOException {
        CharArrayWriter charArrayWriter;
        char[] cArray;
        block7: {
            Reader reader = null;
            cArray = null;
            reader = inputSource.getCharacterStream();
            if (reader == null) {
                return null;
            }
            charArrayWriter = new CharArrayWriter();
            char[] cArray2 = new char[1024];
            int n = 0;
            try {
                while ((n = reader.read(cArray2)) != -1) {
                    charArrayWriter.write(cArray2, 0, n);
                }
                cArray = charArrayWriter.toCharArray();
                Object var7_6 = null;
                if (reader == null) break block7;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (reader != null) {
                    reader.close();
                }
                if (charArrayWriter != null) {
                    charArrayWriter.close();
                }
                throw throwable;
            }
            reader.close();
        }
        if (charArrayWriter != null) {
            charArrayWriter.close();
        }
        return cArray;
    }

    public static byte[] forceGetInputByteData(InputSource inputSource) throws IOException, UnsupportedEncodingException {
        char[] cArray;
        byte[] byArray = InputSourceUtil.getInputByteData(inputSource);
        if (byArray == null && (cArray = InputSourceUtil.getInputCharData(inputSource)) != null) {
            byArray = new String(cArray).getBytes(inputSource.getEncoding());
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEqual(InputSource inputSource, InputSource inputSource2) throws IOException, IllegalArgumentException {
        boolean bl;
        try {
            byte[] byArray = inputSource != null ? InputSourceUtil.forceGetInputByteData(inputSource) : null;
            byte[] byArray2 = inputSource2 != null ? InputSourceUtil.forceGetInputByteData(inputSource2) : null;
            bl = Arrays.equals(byArray, byArray2);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            InputSourceUtil.resetInputSource(inputSource);
            InputSourceUtil.resetInputSource(inputSource2);
            throw throwable;
        }
        InputSourceUtil.resetInputSource(inputSource);
        InputSourceUtil.resetInputSource(inputSource2);
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void resetInputSource(InputSource inputSource) throws IOException, IllegalArgumentException {
        if (inputSource == null) {
            return;
        }
        InputStream inputStream = inputSource.getByteStream();
        Reader reader = inputSource.getCharacterStream();
        if (inputStream != null) {
            if (!(inputStream instanceof ByteArrayInputStream)) throw new IllegalArgumentException("no byte array input stream in input source: " + inputStream.getClass().getName());
            inputStream.reset();
            return;
        } else {
            if (reader == null) return;
            if (!(reader instanceof CharArrayReader)) throw new IllegalArgumentException("no char array reader stream in input source: " + reader.getClass().getName());
            reader.reset();
        }
    }

    public static void transformInputSource(InputSource inputSource) throws IOException {
        if (inputSource == null) {
            return;
        }
        InputStream inputStream = inputSource.getByteStream();
        Reader reader = inputSource.getCharacterStream();
        if (inputStream != null) {
            if (!(inputStream instanceof ByteArrayInputStream)) {
                byte[] byArray = InputSourceUtil.getInputByteData(inputSource);
                inputStream = new ByteArrayInputStream(byArray);
                inputSource.setByteStream(inputStream);
            }
        } else if (reader != null && !(reader instanceof CharArrayReader2)) {
            char[] cArray = InputSourceUtil.getInputCharData(inputSource);
            reader = new CharArrayReader2(cArray);
            inputSource.setCharacterStream(reader);
        }
    }

    private static class CharArrayReader2
    extends CharArrayReader {
        public CharArrayReader2(char[] cArray) {
            super(cArray);
        }

        public CharArrayReader2(char[] cArray, int n, int n2) {
            super(cArray, n, n2);
        }

        public void close() {
        }

        public void forceClose() {
            super.close();
        }
    }
}

