/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.PushbackReader;
import java.io.StringReader;
import java.util.ArrayList;
import weblogic.utils.Debug;
import weblogic.xml.util.XMLConstants;

public final class ParsingUtils
implements XMLConstants {
    private static final boolean debug = System.getProperty("weblogic.xml.debug") != null;

    public static boolean readWS(PushbackReader pushbackReader) throws IOException {
        int n;
        do {
            if ((n = pushbackReader.read()) >= 0) continue;
            throw new EOFException();
        } while (Character.isWhitespace((char)n));
        pushbackReader.unread(n);
        return true;
    }

    public static String read(PushbackReader pushbackReader, String string, boolean bl) throws IOException {
        int n;
        char[] cArray = string.toCharArray();
        int n2 = 0;
        boolean bl2 = false;
        StringBuffer stringBuffer = new StringBuffer();
        while (!bl2) {
            do {
                if ((n = pushbackReader.read()) < 0) {
                    throw new EOFException();
                }
                char c = (char)n;
                stringBuffer.append(c);
                if (c == cArray[n2]) {
                    ++n2;
                    continue;
                }
                n2 = 0;
            } while (n2 != string.length());
            bl2 = true;
        }
        if (!bl) {
            pushbackReader.unread(cArray);
            n = stringBuffer.length();
            stringBuffer.delete(n - cArray.length, n);
        }
        return stringBuffer.toString();
    }

    public static String read(PushbackReader pushbackReader, String[] stringArray, boolean bl) throws IOException {
        int n;
        int n2;
        Debug.assertion((stringArray != null ? 1 : 0) != 0);
        Debug.assertion((stringArray.length > 0 ? 1 : 0) != 0);
        int[] nArray = new int[stringArray.length];
        ArrayList<char[]> arrayList = new ArrayList<char[]>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(stringArray[i].toCharArray());
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = -1;
        block1: while (true) {
            if ((n2 = pushbackReader.read()) < 0) {
                throw new EOFException();
            }
            n = n2;
            stringBuffer.append((char)n);
            int n4 = 0;
            while (true) {
                if (n4 >= stringArray.length) continue block1;
                char[] cArray = (char[])arrayList.get(n4);
                if (n == cArray[nArray[n4]]) {
                    int n5 = n4;
                    nArray[n5] = nArray[n5] + 1;
                } else {
                    nArray[n4] = 0;
                }
                if (nArray[n4] >= cArray.length) {
                    n3 = n4;
                    break block1;
                }
                ++n4;
            }
            break;
        }
        if (!bl) {
            n2 = ((char[])arrayList.get(n3)).length;
            pushbackReader.unread((char[])arrayList.get(n3));
            n = stringBuffer.length();
            stringBuffer.delete(n - n2, n);
        }
        return stringBuffer.toString();
    }

    public static String readUntilWS(PushbackReader pushbackReader) throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if ((n = pushbackReader.read()) < 0) {
                throw new EOFException();
            }
            if (Character.isWhitespace((char)n)) break;
            stringBuffer.append((char)n);
        }
        pushbackReader.unread(n);
        return stringBuffer.toString();
    }

    public static String peek(PushbackReader pushbackReader, int n) throws IOException {
        if (debug) {
            System.out.println("ParsingUtils.peek(" + n + ") = ");
        }
        char[] cArray = new char[n];
        pushbackReader.read(cArray, 0, n);
        pushbackReader.unread(cArray, 0, n);
        String string = new String(cArray);
        if (debug) {
            System.out.println("\"" + string + "\"");
        }
        return new String(cArray);
    }

    public static void main(String[] stringArray) throws Exception {
        if (debug) {
            if (stringArray.length == 0) {
                System.err.println("Usage: ParsingUtils <string to parse> <stop1> <stop2> ...");
                System.exit(1);
            }
            PushbackReader pushbackReader = new PushbackReader(new StringReader(stringArray[0]));
            String[] stringArray2 = new String[stringArray.length - 1];
            for (int i = 1; i < stringArray.length; ++i) {
                stringArray2[i - 1] = stringArray[i];
            }
            System.out.println(ParsingUtils.read(pushbackReader, stringArray2, true));
        }
    }
}

