/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import weblogic.xml.util.Debug;

public class Tools {
    static Debug.DebugFacility dbg = null;

    public static Debug.DebugFacility getDebug() {
        return dbg;
    }

    public static boolean isSubclass(Class clazz, Class clazz2) {
        if (clazz.equals(clazz2)) {
            return true;
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 == null) {
            return false;
        }
        return Tools.isSubclass(clazz3, clazz2);
    }

    public static boolean isSubtype(Class clazz, Class clazz2) {
        if (clazz.equals(clazz2)) {
            return true;
        }
        Class clazz3 = clazz.getSuperclass();
        if (clazz3 != null && Tools.isSubtype(clazz3, clazz2)) {
            return true;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            if (!Tools.isSubtype(classArray[i], clazz2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstance(Object object, Class clazz) {
        if (object == null) {
            return true;
        }
        Class<?> clazz2 = object.getClass();
        return Tools.isSubtype(clazz2, clazz);
    }

    public static boolean isInstanceProper(Object object, Class clazz) {
        if (object == null) {
            return true;
        }
        Class<?> clazz2 = object.getClass();
        return Tools.isSubclass(clazz2, clazz);
    }

    private static void dumpClass(Class clazz) {
        AccessibleObject accessibleObject;
        int n;
        System.out.println("  Members from " + clazz.toString() + ":");
        Object object = clazz.getDeclaredConstructors();
        int n2 = ((Constructor<?>[])object).length;
        if (n2 != 0) {
            System.out.println("    Constructors:");
            for (n = 0; n < n2; ++n) {
                accessibleObject = object[n];
                System.out.println("      " + ((Constructor)accessibleObject).toString());
            }
        }
        if ((n2 = ((AccessibleObject[])(object = clazz.getDeclaredFields())).length) != 0) {
            System.out.println("    Fields:");
            for (n = 0; n < n2; ++n) {
                accessibleObject = object[n];
                System.out.println("      " + ((Field)accessibleObject).toString());
            }
        }
        if ((n2 = ((AccessibleObject[])(object = clazz.getDeclaredMethods())).length) != 0) {
            System.out.println("    Methods:");
            for (n = 0; n < n2; ++n) {
                accessibleObject = object[n];
                System.out.println("      " + ((Method)accessibleObject).toString());
            }
        }
        if ((object = clazz.getSuperclass()) != null) {
            Tools.dumpClassI((Class)object);
        }
    }

    public static void dumpClassI(Class clazz) {
        System.out.println("Members for " + clazz.toString());
        Tools.dumpClassI(clazz);
        System.out.println();
    }

    public static String getEntityDescriptor(String string, String string2) {
        return Tools.getEntityDescriptor(string, string2, null);
    }

    public static String getEntityDescriptor(String string, String string2, String string3) {
        String string4 = "Public ID = \"" + string + "\", System ID = \"" + string2 + "\"";
        if (string3 != null && string3.length() > 0) {
            string4 = string4 + ", Root tag = \"" + string3 + "\"";
        }
        return string4;
    }

    static {
        Debug.DebugSpec debugSpec = Debug.getDebugSpec();
        debugSpec.name = "xml.utils";
        dbg = Debug.makeDebugFacility(debugSpec);
    }

    public static interface ILinkableException {
        public Exception getPrevious();
    }
}

