/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util;

import java.util.ArrayList;
import java.util.List;
import weblogic.utils.StringUtils;

public final class WhitespaceUtils {
    private static final boolean DEBUG = false;
    private static final char TAB = '\t';
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final char SPACE = ' ';
    private static final String EMPTY_STRING = "";

    public static String collapse(String string) {
        int n;
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        int n2 = string.length();
        if (n2 == 0) {
            return EMPTY_STRING;
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            char c = string.charAt(n);
            if (WhitespaceUtils.isWhitespace(c)) {
                if (bl) {
                    cArray[n3++] = c;
                }
                bl = false;
                continue;
            }
            cArray[n3++] = c;
            bl = true;
        }
        if (--n3 >= 0 && WhitespaceUtils.isWhitespace((char)(n = cArray[n3]))) {
            --n3;
        }
        if (++n3 <= 0) {
            return EMPTY_STRING;
        }
        return new String(cArray, 0, n3);
    }

    public static boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r';
    }

    public static String replace(String string) {
        int n = string.length();
        if (n == 0) {
            return EMPTY_STRING;
        }
        char[] cArray = new char[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i);
            if (n3 == 9 || n3 == 10 || n3 == 13) {
                n3 = 32;
            }
            cArray[n2++] = n3;
        }
        return new String(cArray, 0, n2);
    }

    public static String removeAllWhitespaces(String string) {
        if (string == null) {
            throw new NullPointerException("string must not be null");
        }
        String string2 = EMPTY_STRING;
        if (string.length() == 0) {
            return string2;
        }
        String[] stringArray = StringUtils.splitCompletely((String)string);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static List splitOnXMLWhiteSpace(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string == null) {
            return arrayList;
        }
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            char c = string.charAt(i);
            if (WhitespaceUtils.isWhitespace(c)) {
                if (bl) {
                    String string2 = string.substring(n, 1 + n2);
                    arrayList.add(string2);
                }
                bl = false;
                continue;
            }
            if (!bl) {
                n = i;
            }
            bl = true;
            n2 = i;
        }
        if (bl) {
            String string3 = string.substring(n, 1 + n2);
            arrayList.add(string3);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) throws Exception {
        String[] stringArray2 = new String[]{"   ", "  1234\tabcd\tXYZ    ABC", "  fd   fds    d   ", "  fd   fds    d   Z", " ", EMPTY_STRING, "1234 abcd hijk", "1234", "Z", "fda asdf s d f"};
        for (int i = 0; i < stringArray2.length; ++i) {
            List list = WhitespaceUtils.splitOnXMLWhiteSpace(stringArray2[i]);
            System.out.println(stringArray2[i] + " => " + list);
        }
    }
}

