/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.cache.entitycache;

import weblogic.xml.util.cache.entitycache.CacheEntry;
import weblogic.xml.util.cache.entitycache.Tools;

public class CX {

    public static class EntityCacheInternalException
    extends EntityCacheException {
        private static final long serialVersionUID = -2418110382655656920L;

        public EntityCacheInternalException() {
        }

        public EntityCacheInternalException(String string) {
            super("Property Exception: " + string);
        }

        public EntityCacheInternalException(Throwable throwable) {
            this.previous = throwable;
        }

        public EntityCacheInternalException(String string, Throwable throwable) {
            super(string);
            this.previous = throwable;
        }

        public Throwable getPrevious() {
            return this.previous;
        }
    }

    public static class FileLoadOutOfMemory
    extends FileLoad {
        private static final long serialVersionUID = 4798316024393810013L;

        public FileLoadOutOfMemory(String string, Throwable throwable) {
            super("Error loading file: " + string, throwable);
        }
    }

    public static class FileLoad
    extends EntityCacheException {
        private static final long serialVersionUID = -6088499391731515245L;

        public FileLoad(String string, Throwable throwable) {
            super("Error loading file: " + string, throwable);
        }
    }

    public static class UnnamedCache
    extends EntityCacheException {
        private static final long serialVersionUID = -7722783160384285313L;

        public UnnamedCache() {
            this((Throwable)null);
        }

        public UnnamedCache(Throwable throwable) {
            super("New cache must be provided with a name.", throwable);
        }
    }

    public static class EntryTooLargeDisk
    extends EntryTooLarge {
        private static final long serialVersionUID = 8758558572896661571L;

        public EntryTooLargeDisk(CacheEntry cacheEntry, long l) {
            this(cacheEntry, l, null);
        }

        public EntryTooLargeDisk(CacheEntry cacheEntry, long l, Throwable throwable) {
            super(cacheEntry, cacheEntry.getDiskSize(), l, "disk", throwable);
        }
    }

    public static class EntryTooLargeMemory
    extends EntryTooLarge {
        private static final long serialVersionUID = 1895054273049911015L;

        public EntryTooLargeMemory(CacheEntry cacheEntry, long l) {
            this(cacheEntry, l, null);
        }

        public EntryTooLargeMemory(CacheEntry cacheEntry, long l, Throwable throwable) {
            super(cacheEntry, cacheEntry.getSize(), l, "memory", throwable);
        }
    }

    public static abstract class EntryTooLarge
    extends EntityCacheException {
        private static final long serialVersionUID = -1455918258626459255L;
        CacheEntry cacheEntry;

        EntryTooLarge(CacheEntry cacheEntry, long l, long l2, String string, Throwable throwable) {
            super("The " + string + " size (" + l + ") of CacheEntry " + cacheEntry.getKey() + " is larger than the maximum cache size: " + l2, throwable);
        }
    }

    public static class EntryExpired
    extends EntityCacheException {
        private static final long serialVersionUID = 6195032839751825607L;
        public CacheEntry cacheEntry;

        public void renewLease() throws EntityCacheException {
            this.cacheEntry.renewLease();
        }

        public void renewLease(long l) throws EntityCacheException {
            this.cacheEntry.renewLease(l);
        }

        public EntryExpired(CacheEntry cacheEntry) {
            this(cacheEntry, null);
        }

        public EntryExpired(CacheEntry cacheEntry, Throwable throwable) {
            super("CacheEntry " + cacheEntry.getKey() + " has expired.", throwable);
            this.cacheEntry = cacheEntry;
        }
    }

    public static class EntityCacheException
    extends Exception
    implements Tools.ILinkableException {
        private static final long serialVersionUID = -2146832826767767621L;
        Throwable previous = null;

        public EntityCacheException() {
        }

        public EntityCacheException(String string) {
            super("Property Exception: " + string);
        }

        public EntityCacheException(Throwable throwable) {
            this.previous = throwable;
        }

        public EntityCacheException(String string, Throwable throwable) {
            super(string);
            this.previous = throwable;
        }

        public Throwable getPrevious() {
            return this.previous;
        }
    }
}

