/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.cache.entitycache;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.Date;
import java.util.concurrent.atomic.AtomicReference;
import weblogic.xml.util.cache.entitycache.CX;
import weblogic.xml.util.cache.entitycache.EntityCache;
import weblogic.xml.util.cache.entitycache.Event;
import weblogic.xml.util.cache.entitycache.Tools;

public class CacheEntry
implements Serializable {
    static final long serialVersionUID = 1L;
    Object description = null;
    Object sourceIdentificationData = null;
    private long whenCreated;
    private volatile long whenLastAccessed;
    private long size;
    private long leaseInterval = 0L;
    private Serializable key;
    private boolean hasReader;
    volatile transient long expirationTime;
    transient String fileName;
    transient EntityCache cache;
    private transient AtomicReference<Serializable> theData = new AtomicReference();
    private transient long diskSize = 0L;
    transient CacheEntry prevAccess = null;
    transient CacheEntry nextAccess = null;
    private volatile transient boolean isPersistent = false;
    private volatile transient boolean isPersisted = false;

    public CacheEntry(EntityCache entityCache, Serializable serializable, Serializable serializable2, long l, Object object, long l2) throws CX.EntityCacheException {
        long l3;
        this.hasReader = false;
        this.cache = entityCache;
        this.key = serializable;
        this.sourceIdentificationData = object;
        this.whenLastAccessed = this.whenCreated = (l3 = System.currentTimeMillis());
        this.expirationTime = l3 + l2;
        this.size = l;
        this.leaseInterval = l2;
        this.theData.set(serializable2);
    }

    public CacheEntry(EntityCache entityCache, Serializable serializable, Reader reader, Object object, long l) throws CX.EntityCacheException {
        long l2;
        this.hasReader = true;
        this.cache = entityCache;
        this.key = serializable;
        this.sourceIdentificationData = object;
        this.whenLastAccessed = this.whenCreated = (l2 = System.currentTimeMillis());
        this.expirationTime = l2 + l;
        this.leaseInterval = l;
        char[] cArray = this.readData(reader);
        this.theData.set((Serializable)cArray);
        this.size = cArray.length;
    }

    protected char[] readData(Reader reader) throws CX.EntityCacheException {
        char[] cArray = null;
        CharArrayWriter charArrayWriter = null;
        try {
            try {
                charArrayWriter = new CharArrayWriter();
                char[] cArray2 = new char[1024];
                int n = 0;
                while ((n = reader.read(cArray2)) != -1) {
                    charArrayWriter.write(cArray2, 0, n);
                }
                cArray = charArrayWriter.toCharArray();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (Exception exception) {
                throw new CX.EntityCacheException(exception);
            }
            Object var7_8 = null;
            if (charArrayWriter != null) {
                charArrayWriter.flush();
                charArrayWriter.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (charArrayWriter != null) {
                charArrayWriter.flush();
                charArrayWriter.close();
            }
            throw throwable;
        }
        return cArray;
    }

    void renewLease() throws CX.EntityCacheException {
        this.renewLease(this.leaseInterval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renewLease(long l) throws CX.EntityCacheException {
        EntityCache entityCache = this.cache;
        synchronized (entityCache) {
            long l2 = System.currentTimeMillis();
            this.leaseInterval = l;
            this.expirationTime = l2 + l;
            this.whenCreated = l2;
            this.cache.makeMostRecent(this);
            if (this.isPersistent) {
                this.saveIndex();
            }
        }
        if (this.cache.stats != null) {
            this.cache.stats.renewal(this);
        }
        if (this.cache.sessionStats != null) {
            this.cache.sessionStats.renewal(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopLease() throws CX.EntityCacheException {
        EntityCache entityCache = this.cache;
        synchronized (entityCache) {
            long l = System.currentTimeMillis();
            this.leaseInterval = 0L;
            this.whenCreated = this.expirationTime = l;
            if (this.isPersistent) {
                this.saveIndex();
            }
        }
        if (this.cache.stats != null) {
            this.cache.stats.renewal(this);
        }
        if (this.cache.sessionStats != null) {
            this.cache.sessionStats.renewal(this);
        }
    }

    void updateAccessed() {
        this.whenLastAccessed = System.currentTimeMillis();
    }

    public Date getWhenLastAccessed() {
        return new Date(this.whenLastAccessed);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static char[] loadFilePerReader(String string) throws CX.EntityCacheException {
        FileReader fileReader = null;
        CharArrayWriter charArrayWriter = null;
        char[] cArray = null;
        try {
            try {
                fileReader = new FileReader(string);
                charArrayWriter = new CharArrayWriter();
                char[] cArray2 = new char[1024];
                int n = 0;
                while ((n = fileReader.read(cArray2)) != -1) {
                    charArrayWriter.write(cArray2, 0, n);
                }
                cArray = charArrayWriter.toCharArray();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new CX.FileLoadOutOfMemory(string, outOfMemoryError);
            }
            catch (Exception exception) {
                Tools.px(exception);
                throw new CX.FileLoad(string, exception);
            }
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
                if (charArrayWriter == null) throw throwable;
                charArrayWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        if (fileReader != null) {
            fileReader.close();
        }
        if (charArrayWriter == null) return cArray;
        charArrayWriter.close();
        return cArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Serializable loadData() throws CX.EntityCacheException {
        EntityCache entityCache = this.cache;
        synchronized (entityCache) {
            Serializable serializable = this.theData.get();
            if (serializable != null) {
                return serializable;
            }
            this.cache.loadCacheEntry(this);
            return this.theData.get();
        }
    }

    synchronized void loadBytesCallback(String string) throws CX.EntityCacheException {
        if (this.theData.get() != null) {
            return;
        }
        Object object = !this.hasReader ? EntityCache.loadFile(string) : (Object)CacheEntry.loadFilePerReader(string);
        this.theData.set((Serializable)object);
    }

    protected void saveEntry() throws CX.EntityCacheException {
        if (!this.isPersistent) {
            return;
        }
        this.saveData();
        if (!this.isPersistent) {
            return;
        }
        this.saveIndex();
    }

    protected void saveIndex() throws CX.EntityCacheException {
        try {
            if (!this.isPersistent) {
                return;
            }
            String string = EntityCache.getIndexFilePath(this.cache.getRootPath(), this.fileName);
            try {
                EntityCache.saveFile(this, string);
            }
            catch (Exception exception) {
                this.isPersistent = false;
                this.cache.notifyListener(new Event.FileAccessErrorForEntryEvent(this.cache, this, string, true));
            }
        }
        catch (Exception exception) {
            throw new CX.EntityCacheException(exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void saveFilePerReader(char[] cArray, String string) throws CX.EntityCacheException {
        FileWriter fileWriter = null;
        try {
            try {
                fileWriter = new FileWriter(string);
                fileWriter.write(cArray);
            }
            catch (Exception exception) {
                throw new CX.EntityCacheException(exception);
            }
            Object var6_4 = null;
            if (fileWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (fileWriter == null) throw throwable;
            try {
                fileWriter.flush();
                fileWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        fileWriter.flush();
        fileWriter.close();
        return;
    }

    protected synchronized void saveData() throws CX.EntityCacheException {
        try {
            if (!this.isPersistent) {
                return;
            }
            if (this.isPersisted) {
                return;
            }
            this.isPersisted = true;
            long l = 0L;
            if (this.theData.get() != null) {
                l = this.diskSize;
            }
            String string = EntityCache.getDataFilePath(this.cache.getRootPath(), this.fileName);
            try {
                if (!this.hasReader) {
                    EntityCache.saveFile(this.theData.get(), string);
                } else {
                    this.saveFilePerReader((char[])this.theData.get(), string);
                }
            }
            catch (Exception exception) {
                this.isPersistent = false;
                this.cache.notifyListener(new Event.FileAccessErrorForEntryEvent(this.cache, this, string, true));
                return;
            }
            long l2 = new File(string).length();
            long l3 = this.cache.diskUsed - l + l2;
            if (l3 > this.cache.maxDisk) {
                if (l2 > this.cache.maxDisk) {
                    throw new CX.EntryTooLargeDisk(this, this.cache.maxDisk);
                }
                this.cache.purgeDisk(l3 - this.cache.maxDisk, this);
            }
            this.cache.diskUsed = l3;
            this.diskSize = l2;
            if (this.cache.stats != null) {
                this.cache.stats.writeEntry(this);
            }
            if (this.cache.stats != null) {
                this.cache.sessionStats.writeEntry(this);
            }
        }
        catch (CX.EntityCacheException entityCacheException) {
            throw entityCacheException;
        }
        catch (Exception exception) {
            throw new CX.EntityCacheException(exception);
        }
    }

    protected void purge() throws CX.EntityCacheException {
        if (this.theData.get() != null) {
            if (this.isPersistent) {
                try {
                    this.saveEntry();
                }
                catch (Exception exception) {
                    this.cache.removeEntry(this.key);
                    return;
                }
                this.theData.set(null);
                this.cache.memoryUsed -= this.size;
            } else {
                this.cache.removeEntry(this.key);
            }
        }
    }

    protected boolean isLoaded() {
        return this.theData.get() != null;
    }

    protected boolean isPersisted() {
        return this.isPersisted;
    }

    Object getData() throws CX.EntityCacheException {
        Serializable serializable = this.theData.get();
        if (serializable == null) {
            serializable = this.loadData();
        }
        this.cache.makeMostRecent(this);
        if (!this.hasReader) {
            return serializable;
        }
        return new CharArrayReader((char[])serializable);
    }

    protected void delete() {
        if (!this.isPersistent) {
            return;
        }
        this.deleteEntryData(this.fileName, false);
    }

    void makeTransient(boolean bl) {
        if (!this.isPersistent) {
            return;
        }
        try {
            this.deleteEntryData(this.fileName, bl);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    synchronized void deleteEntryData(String string, boolean bl) {
        this.cache.deleteEntryData(string, bl);
        this.isPersistent = false;
        this.isPersisted = false;
    }

    public boolean isPersistent() {
        return this.isPersistent;
    }

    public void setPersistent(boolean bl) {
        this.isPersistent = bl;
    }

    public boolean isPersistentNoStupidException() {
        return this.isPersistent;
    }

    public boolean isExpired() throws CX.EntityCacheException {
        return System.currentTimeMillis() > this.expirationTime;
    }

    public boolean olderThan(CacheEntry cacheEntry) {
        return this.whenLastAccessed > cacheEntry.whenLastAccessed;
    }

    public long getSecondsUntilExpiration() throws CX.EntityCacheException {
        return (System.currentTimeMillis() - this.expirationTime) / 1000L;
    }

    public long getMemorySize() {
        if (this.theData.get() != null) {
            return this.size;
        }
        return 0L;
    }

    synchronized void reactivateFromDisk(EntityCache entityCache, String string, long l) {
        this.cache = entityCache;
        this.fileName = string;
        this.diskSize = l;
        this.isPersistent = true;
        this.isPersisted = true;
    }

    public long getDiskSize() {
        return this.diskSize;
    }

    public long getDiskSizeNoStupidException() {
        return this.diskSize;
    }

    public Serializable getCacheKey() throws CX.EntityCacheException {
        return this.key;
    }

    public Object getDescription() throws CX.EntityCacheException {
        return this.description;
    }

    public void setDescription(Object object) throws CX.EntityCacheException {
        this.description = object;
    }

    public Object getSourceIdentificationData() throws CX.EntityCacheException {
        return this.sourceIdentificationData;
    }

    public void setSourceIdentificationData(Object object) throws CX.EntityCacheException {
        this.sourceIdentificationData = object;
    }

    public String toString() {
        return this.key.toString();
    }

    public long getSize() {
        return this.size;
    }

    public long getLeaseInterval() {
        return this.leaseInterval;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(this.description);
        objectOutputStream.writeObject(this.sourceIdentificationData);
        objectOutputStream.writeObject(new Date(this.whenCreated));
        objectOutputStream.writeObject(new Date(this.whenLastAccessed));
        objectOutputStream.writeLong(this.size);
        objectOutputStream.writeLong(this.leaseInterval);
        objectOutputStream.writeObject(this.key);
        objectOutputStream.writeBoolean(this.hasReader);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Date date;
        this.description = objectInputStream.readObject();
        this.sourceIdentificationData = objectInputStream.readObject();
        Date date2 = (Date)objectInputStream.readObject();
        if (date2 != null) {
            this.whenCreated = date2.getTime();
        }
        if ((date = (Date)objectInputStream.readObject()) != null) {
            this.whenLastAccessed = date.getTime();
        }
        this.size = objectInputStream.readLong();
        this.leaseInterval = objectInputStream.readLong();
        this.key = (Serializable)objectInputStream.readObject();
        this.hasReader = objectInputStream.readBoolean();
    }

    public Serializable getKey() {
        return this.key;
    }
}

