/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.cache.entitycache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import weblogic.management.ManagementException;
import weblogic.management.configuration.ServerMBean;
import weblogic.management.configuration.XMLEntityCacheMBean;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.ServerRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.xml.util.cache.entitycache.CX;
import weblogic.xml.util.cache.entitycache.CacheEntry;
import weblogic.xml.util.cache.entitycache.CacheListener;
import weblogic.xml.util.cache.entitycache.EntityCacheCumulativeStats;
import weblogic.xml.util.cache.entitycache.EntityCacheCurrentStats;
import weblogic.xml.util.cache.entitycache.Event;
import weblogic.xml.util.cache.entitycache.Persister;
import weblogic.xml.util.cache.entitycache.Statistics;
import weblogic.xml.util.cache.entitycache.StatisticsMonitor;
import weblogic.xml.util.cache.entitycache.Tools;

public class EntityCache
implements Serializable {
    static final long serialVersionUID = 1L;
    static ServerMBean serverConfigMBean = null;
    static final long DefaultCacheSize = 2000000L;
    static final long DefaultCacheDiskSize = 5000000L;
    static final int DefaultSizeBias = 5;
    static final String DefaultCachePath = "EntityCache";
    long maxMemory = 0L;
    long maxDisk = 0L;
    long memoryUsed = 0L;
    long fileNameCounter = -1L;
    double sizeBias = 0.0;
    String name = null;
    transient StatisticsMonitor statisticsMonitor = null;
    transient Statistics stats = null;
    transient Statistics sessionStats = null;
    transient Statistics currentStats = null;
    private String rootPath;
    static transient Hashtable<String, EntityCache> caches = new Hashtable();
    transient ConcurrentHashMap<Serializable, CacheEntry> entries = null;
    transient long diskUsed = 0L;
    transient AccessList accessList = null;
    static transient Persister persister = null;
    transient CacheListener listener = null;
    volatile transient boolean statsCumulativeModification = false;
    volatile transient boolean statsCurrentModification = false;
    transient long memLossTotal = 0L;
    transient long diskLossTotal = 0L;

    static ServerMBean getServerConfigMBean() throws CX.EntityCacheException {
        AuthenticatedSubject authenticatedSubject;
        if (serverConfigMBean == null && (serverConfigMBean = ManagementService.getRuntimeAccess(authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())).getServer()) == null) {
            throw new CX.EntityCacheException("ServerConfigMBean can't be null!");
        }
        return serverConfigMBean;
    }

    public static EntityCache getCache(CacheSpec cacheSpec, XMLEntityCacheMBean xMLEntityCacheMBean) throws CX.EntityCacheException {
        EntityCache entityCache;
        String string;
        boolean bl;
        block12: {
            bl = false;
            string = cacheSpec.path;
            if (!string.endsWith(String.valueOf(File.separatorChar))) {
                string = string + File.separatorChar;
            }
            if ((entityCache = caches.get(string)) == null) {
                bl = true;
                entityCache = new File(EntityCache.getCacheFilePath(string)).exists() ? EntityCache.open(string, cacheSpec) : EntityCache.create(string, cacheSpec);
            }
            if (entityCache == null) {
                return null;
            }
            entityCache.name = cacheSpec.name;
            entityCache.listener = cacheSpec.cacheListener;
            entityCache.setMemoryFootprint(cacheSpec.memSize);
            entityCache.setDiskFootprint(cacheSpec.diskSize);
            File file = new File(string);
            if (!file.exists()) {
                file.mkdirs();
            }
            if (!(file = new File(EntityCache.getIndexDirectory(string))).exists()) {
                file.mkdirs();
            }
            if (!(file = new File(EntityCache.getDataDirectory(string))).exists()) {
                file.mkdirs();
            }
            try {
                EntityCache.saveFile(entityCache, EntityCache.getCacheFilePath(string));
            }
            catch (Exception exception) {
                if (cacheSpec.cacheListener == null) break block12;
                cacheSpec.cacheListener.notify(new Event.FileAccessErrorForCacheEvent(entityCache, string, true));
            }
        }
        if (bl) {
            caches.put(string, entityCache);
            try {
                AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
                ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServerRuntime();
                entityCache.statisticsMonitor = new StatisticsMonitor(entityCache, 300000L);
                entityCache.stats = Statistics.initialize(entityCache, EntityCache.getStatsFilePath(entityCache.rootPath));
                EntityCacheCumulativeStats entityCacheCumulativeStats = entityCache.registerCumulativeStatsMBean("EntityCacheHistorical_", entityCache.stats);
                entityCache.statisticsMonitor.addSubject(entityCache.sessionStats, entityCacheCumulativeStats);
                serverRuntimeMBean.setEntityCacheHistoricalRuntime(entityCacheCumulativeStats);
                entityCache.sessionStats = new Statistics(entityCache);
                EntityCacheCumulativeStats entityCacheCumulativeStats2 = entityCache.registerCumulativeStatsMBean("EntityCacheCumulative_", entityCache.sessionStats);
                serverRuntimeMBean.setEntityCacheCumulativeRuntime(entityCacheCumulativeStats2);
                entityCache.statisticsMonitor.addSubject(entityCache.sessionStats, entityCacheCumulativeStats2);
                entityCache.currentStats = new Statistics(entityCache);
                EntityCacheCurrentStats entityCacheCurrentStats = new EntityCacheCurrentStats(entityCache);
                entityCache.statisticsMonitor.addSubject(entityCache.currentStats, entityCacheCurrentStats);
                serverRuntimeMBean.setEntityCacheCurrentStateRuntime(entityCacheCurrentStats);
                if (xMLEntityCacheMBean != null) {
                    xMLEntityCacheMBean.setEntityCacheHistoricalRuntime(entityCacheCumulativeStats);
                    xMLEntityCacheMBean.setEntityCacheSessionRuntime(entityCacheCumulativeStats2);
                    xMLEntityCacheMBean.setEntityCacheCurrentRuntime(entityCacheCurrentStats);
                }
                entityCache.statisticsMonitor.start();
            }
            catch (ManagementException managementException) {
                throw new CX.EntityCacheException(managementException);
            }
        }
        return entityCache;
    }

    public String getName() {
        return this.name;
    }

    public void addEntry(Serializable serializable, CacheEntry cacheEntry) throws CX.EntityCacheException {
        this.addEntry(serializable, cacheEntry, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(Serializable serializable, CacheEntry cacheEntry, boolean bl) throws CX.EntityCacheException {
        EntityCache entityCache = this;
        synchronized (entityCache) {
            this.removeEntry(serializable);
            cacheEntry.setPersistent(bl);
            this.findSpace(cacheEntry);
            this.put(serializable, cacheEntry);
            this.accessList.addMostRecent(cacheEntry);
            this.memoryUsed += cacheEntry.getSize();
            cacheEntry.setFileName(this.getNewFileName());
        }
        if (bl) {
            Persister.get().add(cacheEntry);
        }
        if (this.stats != null) {
            this.stats.addEntry(cacheEntry);
        }
        if (this.sessionStats != null) {
            this.sessionStats.addEntry(cacheEntry);
        }
        this.notifyListener(new Event.EntryAddEvent(this, cacheEntry));
        this.statsCurrentModification = true;
    }

    public Object getData(Serializable serializable) throws CX.EntityCacheException {
        Object object = null;
        CacheEntry cacheEntry = this.get(serializable);
        if (cacheEntry != null) {
            if (!cacheEntry.isExpired()) {
                object = cacheEntry.getData();
            } else {
                throw new CX.EntryExpired(cacheEntry);
            }
        }
        return object;
    }

    public synchronized CacheEntry renewLease(Serializable serializable) throws CX.EntityCacheException {
        CacheEntry cacheEntry = this.get(serializable);
        if (cacheEntry != null) {
            cacheEntry.renewLease();
        }
        return cacheEntry;
    }

    public synchronized CacheEntry putrify(Serializable serializable) throws CX.EntityCacheException {
        CacheEntry cacheEntry = this.get(serializable);
        if (cacheEntry != null) {
            cacheEntry.stopLease();
        }
        return cacheEntry;
    }

    public synchronized CacheEntry renewLease(Serializable serializable, long l) throws CX.EntityCacheException {
        CacheEntry cacheEntry = this.get(serializable);
        if (cacheEntry != null) {
            cacheEntry.renewLease(l);
            this.accessList.moveMostRecent(cacheEntry);
        }
        return cacheEntry;
    }

    public synchronized CacheEntry removeEntry(Serializable serializable) throws CX.EntityCacheException {
        CacheEntry cacheEntry = this.get(serializable);
        if (cacheEntry != null) {
            this.remove(serializable);
            this.accessList.remove(cacheEntry);
            this.reduceMemoryUsed(cacheEntry.getSize());
            cacheEntry.delete();
            this.notifyListener(new Event.EntryDeleteEvent(this, cacheEntry));
        }
        this.statsCurrentModification = true;
        return cacheEntry;
    }

    public synchronized long getMemoryFootprint() {
        return this.maxMemory;
    }

    public synchronized void setMemoryFootprint(long l) throws CX.EntityCacheException {
        long l2 = this.memoryUsed - l;
        if (l2 == 0L) {
            return;
        }
        if (l2 > 0L) {
            this.purge(l2);
        }
        this.maxMemory = l;
    }

    public synchronized long getDiskFootprint() {
        return this.maxDisk;
    }

    public synchronized void setDiskFootprint(long l) throws CX.EntityCacheException {
        long l2 = this.diskUsed - l;
        if (l2 == 0L) {
            return;
        }
        if (l2 > 0L) {
            this.purgeDisk(l2);
        }
        this.maxDisk = l;
    }

    public synchronized void close() throws CX.EntityCacheException {
        caches.remove(this.rootPath);
        if (this.statisticsMonitor != null) {
            this.statisticsMonitor.finish();
        }
        this.notifyListener(new Event.CacheCloseEvent(this));
        this.listener = null;
    }

    synchronized void notifyListener(Event.CacheUtilityEvent cacheUtilityEvent) {
        if (this.listener != null) {
            this.listener.notify(cacheUtilityEvent);
        }
    }

    public void makeMostRecent(CacheEntry cacheEntry) {
        cacheEntry.updateAccessed();
        this.accessList.moveMostRecent(cacheEntry);
    }

    protected EntityCache(String string, String string2) {
        this(string, 2000000L, 5000000L, 5, string2);
    }

    protected EntityCache(String string, long l, long l2, int n, String string2) {
        this.name = string;
        this.maxMemory = l;
        this.maxDisk = l2;
        this.sizeBias = (double)n / 100.0;
        this.rootPath = string2;
    }

    void put(Serializable serializable, CacheEntry cacheEntry) {
        this.entries.put(serializable, cacheEntry);
    }

    CacheEntry get(Serializable serializable) {
        CacheEntry cacheEntry = this.entries.get(serializable);
        return cacheEntry;
    }

    CacheEntry remove(Serializable serializable) {
        CacheEntry cacheEntry = this.entries.remove(serializable);
        return cacheEntry;
    }

    public String getIndexFilePath(String string) {
        return EntityCache.getIndexFilePath(this.rootPath, string);
    }

    public String getDataFilePath(String string) {
        return EntityCache.getDataFilePath(this.rootPath, string);
    }

    static String getIndexFilePath(String string, String string2) {
        return EntityCache.getIndexDirectory(string) + string2;
    }

    static String getIndexDirectory(String string) {
        return string + "index" + File.separatorChar;
    }

    static String getDataFilePath(String string, String string2) {
        return EntityCache.getDataDirectory(string) + string2;
    }

    static String getDataDirectory(String string) {
        return string + "data" + File.separatorChar;
    }

    static String getCacheFilePath(String string) {
        return string + File.separatorChar + "cache";
    }

    static String getStatsFilePath(String string) {
        return string + File.separatorChar + "stats";
    }

    protected static EntityCache open(String string, CacheSpec cacheSpec) throws CX.EntityCacheException {
        EntityCache entityCache = null;
        try {
            block22: {
                try {
                    entityCache = (EntityCache)EntityCache.loadFile(EntityCache.getCacheFilePath(string));
                    entityCache.initTransientInfo(string, cacheSpec);
                    if (cacheSpec.cacheListener != null) {
                        cacheSpec.cacheListener.notify(new Event.CacheLoadEvent(entityCache));
                    }
                }
                catch (CX.FileLoadOutOfMemory fileLoadOutOfMemory) {
                    Tools.log("Unable to load cache data record from disk (too big!): " + string + ". Rebuilding from index...");
                    if (cacheSpec.cacheListener != null) {
                        cacheSpec.cacheListener.notify(new Event.OutOfMemoryLoadingCacheEvent(string));
                    }
                }
                catch (CX.FileLoad fileLoad) {
                    Tools.log("Unable to load cache data record from disk (corrupted?): " + string + ". Rebuilding from index...");
                    if (EntityCache.canRead(EntityCache.getCacheFilePath(string))) {
                        if (cacheSpec.cacheListener != null) {
                            cacheSpec.cacheListener.notify(new Event.CacheCorruptionEvent(string));
                        }
                    }
                    if (cacheSpec.cacheListener == null) break block22;
                    cacheSpec.cacheListener.notify(new Event.FileAccessErrorForCacheEvent(null, string, false));
                }
            }
            if (entityCache == null) {
                entityCache = EntityCache.create(string, cacheSpec);
            } else {
                entityCache.name = cacheSpec.name;
                entityCache.setMemoryFootprint(cacheSpec.memSize);
                entityCache.setDiskFootprint(cacheSpec.diskSize);
            }
            String[] stringArray = new File(EntityCache.getIndexDirectory(string)).list();
            for (int i = 0; i < stringArray.length; ++i) {
                long l = 0L;
                try {
                    Long.parseLong(stringArray[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                CacheEntry cacheEntry = null;
                String string2 = EntityCache.getIndexFilePath(string, stringArray[i]);
                String string3 = EntityCache.getDataFilePath(string, stringArray[i]);
                try {
                    cacheEntry = (CacheEntry)EntityCache.loadFile(string2);
                }
                catch (CX.FileLoadOutOfMemory fileLoadOutOfMemory) {
                    Tools.log("Unable to load cache index data record from disk (too big!). Deleting entry...");
                    entityCache.notifyListener(new Event.OutOfMemoryLoadingEntryEvent(entityCache, null, string));
                    continue;
                }
                catch (CX.FileLoad fileLoad) {
                    if (EntityCache.canRead(string2)) {
                        entityCache.notifyListener(new Event.EntryCorruptionEvent(entityCache, null, string));
                    } else {
                        entityCache.notifyListener(new Event.FileAccessErrorForEntryEvent(entityCache, null, string, false));
                    }
                    Tools.log("Unable to load cache index data record from disk (corrupted?). Deleting entry...");
                    entityCache.deleteEntryData(stringArray[i], true);
                    continue;
                }
                if (cacheEntry == null) continue;
                long l2 = new File(string3).length();
                cacheEntry.reactivateFromDisk(entityCache, stringArray[i], l2);
                entityCache.put(cacheEntry.getKey(), cacheEntry);
                entityCache.accessList.addSorted(cacheEntry);
                entityCache.diskUsed += l2;
                if (l <= entityCache.fileNameCounter) continue;
                entityCache.fileNameCounter = l;
            }
            try {
                EntityCache.saveFile(entityCache, EntityCache.getCacheFilePath(entityCache.rootPath));
            }
            catch (Exception exception) {
                entityCache.notifyListener(new Event.FileAccessErrorForCacheEvent(entityCache, string, true));
            }
        }
        catch (Exception exception) {
            if (cacheSpec.cacheListener != null) {
                cacheSpec.cacheListener.notify(new Event.CacheFailureEvent(entityCache, string, "Exception while opening cache."));
            }
            entityCache = null;
        }
        return entityCache;
    }

    protected void initTransientInfo(String string, CacheSpec cacheSpec) {
        this.entries = new ConcurrentHashMap();
        this.accessList = new AccessList();
        this.rootPath = string;
        this.memoryUsed = 0L;
        this.diskUsed = 0L;
        this.listener = cacheSpec.cacheListener;
    }

    protected static EntityCache create(String string, CacheSpec cacheSpec) throws CX.EntityCacheException {
        EntityCache entityCache = null;
        try {
            entityCache = new EntityCache(cacheSpec.name, cacheSpec.memSize, cacheSpec.diskSize, cacheSpec.sizeBias, string);
            entityCache.initTransientInfo(string, cacheSpec);
            if (cacheSpec.cacheListener != null) {
                cacheSpec.cacheListener.notify(new Event.CacheCreationEvent(entityCache));
            }
        }
        catch (Exception exception) {
            if (cacheSpec.cacheListener != null) {
                cacheSpec.cacheListener.notify(new Event.CacheFailureEvent(entityCache, string, "Exception while creating cache."));
            }
            entityCache = null;
        }
        return entityCache;
    }

    String getRootPath() {
        return this.rootPath;
    }

    String getNewFileName() throws CX.EntityCacheException {
        try {
            ++this.fileNameCounter;
            while (new File(EntityCache.getIndexFilePath(this.rootPath, "" + this.fileNameCounter)).exists()) {
                ++this.fileNameCounter;
            }
            try {
                EntityCache.saveFile(this, EntityCache.getCacheFilePath(this.rootPath));
            }
            catch (Exception exception) {
                this.notifyListener(new Event.FileAccessErrorForCacheEvent(this, EntityCache.getCacheFilePath(this.rootPath), true));
                throw exception;
            }
        }
        catch (Exception exception) {
            throw new CX.EntityCacheException(exception);
        }
        return "" + this.fileNameCounter;
    }

    protected synchronized void findSpace(CacheEntry cacheEntry) throws CX.EntityCacheException {
        if (cacheEntry.getSize() > this.maxMemory) {
            if (this.stats != null) {
                this.stats.rejection(cacheEntry);
            }
            if (this.sessionStats != null) {
                this.sessionStats.rejection(cacheEntry);
            }
            this.notifyListener(new Event.EntryRejectionEvent(this, cacheEntry));
            throw new CX.EntryTooLargeMemory(cacheEntry, this.maxMemory);
        }
        if (this.memoryUsed + cacheEntry.getSize() > this.maxMemory) {
            this.purge(cacheEntry.getSize() - (this.maxMemory - this.memoryUsed));
        }
    }

    synchronized void purge(long l) throws CX.EntityCacheException {
        Vector vector = this.findEntitiesToPurge(l);
        long l2 = this.memoryUsed;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CacheEntry cacheEntry = (CacheEntry)enumeration.nextElement();
            cacheEntry.purge();
        }
        long l3 = l2 - this.memoryUsed;
        long l4 = l3 - l;
        if (l4 < 0L) {
            l4 = 0L;
        }
        this.memLossTotal += l4;
        if (this.stats != null) {
            this.stats.memoryPurge(vector.size(), l3);
        }
        if (this.sessionStats != null) {
            this.sessionStats.memoryPurge(vector.size(), l3);
        }
        this.statsCurrentModification = true;
        this.notifyListener(new Event.MemoryPurgeEvent(this, vector));
    }

    protected Vector findEntitiesToPurge(long l) {
        int n = 0;
        Vector<CacheEntry> vector = new Vector<CacheEntry>();
        CacheEntry cacheEntry = this.accessList.oldestEntry;
        while (cacheEntry != null && (long)n < l) {
            long l2 = cacheEntry.getMemorySize();
            if (l2 != 0L) {
                vector.addElement(cacheEntry);
                n = (int)((long)n + l2);
            }
            cacheEntry = cacheEntry.prevAccess;
        }
        return vector;
    }

    protected void purgeDisk(long l) throws CX.EntityCacheException {
        this.purgeDisk(l, null);
    }

    protected synchronized void purgeDisk(long l, CacheEntry cacheEntry) throws CX.EntityCacheException {
        Vector vector = this.findDiskEntitiesToPurge(l, cacheEntry);
        long l2 = this.diskUsed;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CacheEntry cacheEntry2 = (CacheEntry)enumeration.nextElement();
            cacheEntry2.makeTransient(false);
        }
        long l3 = l2 - this.diskUsed - l;
        this.diskLossTotal += l2 - this.diskUsed - l;
        if (this.stats != null) {
            this.stats.diskPurge(vector.size(), l2 - this.diskUsed);
        }
        if (this.sessionStats != null) {
            this.sessionStats.diskPurge(vector.size(), l2 - this.diskUsed);
        }
        this.notifyListener(new Event.DiskPurgeEvent(this, vector));
        this.statsCurrentModification = true;
    }

    synchronized void reduceDiskUsed(long l) {
        this.diskUsed -= l;
    }

    synchronized void reduceMemoryUsed(long l) {
        this.memoryUsed -= l;
    }

    synchronized void loadCacheEntry(CacheEntry cacheEntry) throws CX.EntityCacheException {
        this.findSpace(cacheEntry);
        Serializable serializable = cacheEntry.getKey();
        String string = EntityCache.getDataFilePath(this.rootPath, cacheEntry.getFileName());
        try {
            cacheEntry.loadBytesCallback(string);
            this.memoryUsed += cacheEntry.getMemorySize();
        }
        catch (CX.FileLoadOutOfMemory fileLoadOutOfMemory) {
            Tools.log("Unable to load cache entry data record from disk (too big!): " + serializable + ". Deleting entry...");
            this.removeEntry(serializable);
            this.notifyListener(new Event.OutOfMemoryLoadingEntryEvent(this, serializable, string));
            throw fileLoadOutOfMemory;
        }
        catch (CX.FileLoad fileLoad) {
            Tools.log("Unable to load cache entry data record from disk (corrupted?): " + serializable + ". Deleting entry...");
            if (EntityCache.canRead(string)) {
                this.notifyListener(new Event.EntryCorruptionEvent(this, serializable, string));
            } else {
                this.notifyListener(new Event.FileAccessErrorForEntryEvent(this, null, string, false));
            }
            this.removeEntry(serializable);
            throw fileLoad;
        }
        this.notifyListener(new Event.EntryLoadEvent(this, cacheEntry));
    }

    protected synchronized Vector findDiskEntitiesToPurge(long l, CacheEntry cacheEntry) {
        int n = 0;
        Vector<CacheEntry> vector = new Vector<CacheEntry>();
        CacheEntry cacheEntry2 = this.accessList.oldestEntry;
        while (cacheEntry2 != null) {
            if (cacheEntry2 != cacheEntry && cacheEntry2.isPersisted()) {
                if ((long)n >= l) break;
                vector.addElement(cacheEntry2);
                n = (int)((long)n + cacheEntry2.getDiskSize());
            }
            cacheEntry2 = cacheEntry2.prevAccess;
        }
        return vector;
    }

    long getBestFitRetryCount() {
        double d = this.factorial(this.entries.size()) - 1.0;
        long l = (long)(d * this.sizeBias);
        return l;
    }

    double factorial(long l) {
        long l2 = 1L;
        for (long i = 2L; i < l + 1L; ++i) {
            l2 *= l;
        }
        return l2;
    }

    static boolean canRead(String string) {
        try {
            return new File(string).canRead();
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    static void saveFile(Serializable serializable, String string) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
        objectOutputStream.writeObject(serializable);
        objectOutputStream.flush();
        objectOutputStream.close();
        fileOutputStream.close();
    }

    synchronized void deleteEntryData(String string, boolean bl) {
        String string2 = null;
        File file = null;
        string2 = this.getIndexFilePath(string);
        file = new File(string2);
        if (bl) {
            try {
                file.delete();
            }
            catch (Throwable throwable) {}
        } else {
            file.delete();
        }
        string2 = this.getDataFilePath(string);
        file = new File(string2);
        this.reduceDiskUsed(file.length());
        if (bl) {
            try {
                file.delete();
            }
            catch (Throwable throwable) {}
        } else {
            file.delete();
        }
    }

    static final Serializable loadFile(String string) throws CX.FileLoadOutOfMemory, CX.FileLoad {
        Serializable serializable = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            serializable = (Serializable)objectInputStream.readObject();
            objectInputStream.close();
            fileInputStream.close();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new CX.FileLoadOutOfMemory(string, outOfMemoryError);
        }
        catch (Exception exception) {
            Tools.px(exception);
            throw new CX.FileLoad(string, exception);
        }
        return serializable;
    }

    public EntityCacheCumulativeStats registerCumulativeStatsMBean(String string, Statistics statistics) throws ManagementException {
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        ServerRuntimeMBean serverRuntimeMBean = ManagementService.getRuntimeAccess(authenticatedSubject).getServerRuntime();
        String string2 = string + serverRuntimeMBean.getName();
        EntityCacheCumulativeStats entityCacheCumulativeStats = new EntityCacheCumulativeStats(string2, serverRuntimeMBean, this, statistics);
        return entityCacheCumulativeStats;
    }

    public void initializeStatisticsMBeans() {
    }

    class AccessList {
        transient AtomicReference<CacheEntry> mostRecentlyAccessed = new AtomicReference();
        CacheEntry oldestEntry = null;

        AccessList() {
        }

        boolean isMostRecent(CacheEntry cacheEntry) {
            return this.mostRecentlyAccessed.get() == cacheEntry;
        }

        synchronized void addMostRecent(CacheEntry cacheEntry) {
            CacheEntry cacheEntry2 = this.mostRecentlyAccessed.get();
            this.mostRecentlyAccessed.set(cacheEntry);
            cacheEntry.nextAccess = cacheEntry2;
            cacheEntry.prevAccess = null;
            if (cacheEntry2 != null) {
                cacheEntry2.prevAccess = cacheEntry;
            }
            if (this.oldestEntry == null) {
                this.oldestEntry = cacheEntry;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void moveMostRecent(CacheEntry cacheEntry) {
            if (this.mostRecentlyAccessed.get() != cacheEntry) {
                AccessList accessList = this;
                synchronized (accessList) {
                    if (this.mostRecentlyAccessed.get() != cacheEntry) {
                        this.remove(cacheEntry);
                        this.addMostRecent(cacheEntry);
                    }
                }
            }
        }

        synchronized void remove(CacheEntry cacheEntry) {
            if (cacheEntry.prevAccess != null) {
                cacheEntry.prevAccess.nextAccess = cacheEntry.nextAccess;
            } else {
                this.mostRecentlyAccessed.set(cacheEntry.nextAccess);
            }
            if (cacheEntry.nextAccess != null) {
                cacheEntry.nextAccess.prevAccess = cacheEntry.prevAccess;
            } else {
                this.oldestEntry = cacheEntry.prevAccess;
            }
        }

        synchronized void addSorted(CacheEntry cacheEntry) {
            CacheEntry cacheEntry2 = this.mostRecentlyAccessed.get();
            while (cacheEntry2 != null) {
                if (cacheEntry.olderThan(cacheEntry2)) {
                    cacheEntry.prevAccess = cacheEntry2.prevAccess;
                    cacheEntry2.prevAccess.nextAccess = cacheEntry;
                    cacheEntry2.prevAccess = cacheEntry;
                    if (cacheEntry2.nextAccess == null) {
                        this.oldestEntry = cacheEntry;
                    }
                    return;
                }
                cacheEntry2 = cacheEntry2.nextAccess;
            }
            if (this.oldestEntry != null) {
                this.oldestEntry.nextAccess = cacheEntry;
            }
            cacheEntry.prevAccess = this.oldestEntry;
            this.oldestEntry = cacheEntry;
        }
    }

    public static class CacheSpec {
        public String name = null;
        public String path = "EntityCache";
        public long memSize = 2000000L;
        public long diskSize = 5000000L;
        int sizeBias = 5;
        public CacheListener cacheListener = null;
        Vector eventsOfInterest = null;
    }
}

