/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.cache.entitycache;

import java.io.Serializable;
import java.security.AccessController;
import java.util.Enumeration;
import weblogic.management.ManagementException;
import weblogic.management.provider.ManagementService;
import weblogic.management.runtime.EntityCacheCurrentStateRuntimeMBean;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.service.PrivilegedActions;
import weblogic.xml.util.cache.entitycache.CacheEntry;
import weblogic.xml.util.cache.entitycache.EntityCache;
import weblogic.xml.util.cache.entitycache.EntityCacheStats;
import weblogic.xml.util.cache.entitycache.Statistics;

public class EntityCacheCurrentStats
extends EntityCacheStats
implements EntityCacheCurrentStateRuntimeMBean {
    private static final long serialVersionUID = 3556632666101847510L;

    Statistics getStats() {
        this.cache.currentStats.clear();
        Enumeration<Serializable> enumeration = this.cache.entries.keys();
        while (enumeration.hasMoreElements()) {
            Serializable serializable = enumeration.nextElement();
            CacheEntry cacheEntry = this.cache.entries.get(serializable);
            this.cache.currentStats.addEntry(cacheEntry);
            if (!cacheEntry.isPersisted()) continue;
            this.cache.currentStats.writeEntry(cacheEntry);
        }
        return this.cache.currentStats;
    }

    boolean changesMade() {
        return this.cache.statsCurrentModification;
    }

    public EntityCacheCurrentStats(EntityCache entityCache) throws ManagementException {
        super("EntityCacheCurrentState_" + ManagementService.getRuntimeAccess((AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction())).getServerName(), null, entityCache);
        AuthenticatedSubject authenticatedSubject = (AuthenticatedSubject)AccessController.doPrivileged(PrivilegedActions.getKernelIdentityAction());
        ManagementService.getRuntimeAccess(authenticatedSubject).getServerRuntime().setEntityCacheCurrentStateRuntime(this);
    }

    public synchronized long getMemoryUsage() {
        return this.getStats().getTotalEntries();
    }

    public synchronized long getDiskUsage() {
        return this.getStats().getTotalEntries();
    }
}

