/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.cache.entitycache;

import java.util.Enumeration;
import java.util.Vector;
import weblogic.management.ManagementException;
import weblogic.management.runtime.EntityCacheRuntimeMBean;
import weblogic.management.runtime.RuntimeMBean;
import weblogic.management.runtime.RuntimeMBeanDelegate;
import weblogic.xml.util.cache.entitycache.EntityCache;
import weblogic.xml.util.cache.entitycache.Statistics;

public abstract class EntityCacheStats
extends RuntimeMBeanDelegate
implements EntityCacheRuntimeMBean {
    EntityCache cache = null;
    Statistics oldValues = null;

    public EntityCacheStats(String string, RuntimeMBean runtimeMBean, EntityCache entityCache) throws ManagementException {
        super(string, runtimeMBean);
        this.cache = entityCache;
    }

    abstract Statistics getStats();

    boolean changesMade() {
        return true;
    }

    synchronized void doNotifications() {
        if (!this.changesMade()) {
            return;
        }
        Vector vector = null;
        Statistics statistics = this.getStats().copy();
        if (this.oldValues != null && (vector = this.diff(this.oldValues, statistics)) != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                AttributeDiff attributeDiff = (AttributeDiff)enumeration.nextElement();
                this._postSet(attributeDiff.attributeName, attributeDiff.oldValue, attributeDiff.newValue);
            }
        }
        this.oldValues = statistics;
    }

    Vector diff(Statistics statistics, Statistics statistics2) {
        Vector<AttributeDiff> vector = new Vector<AttributeDiff>();
        long l = 0L;
        long l2 = 0L;
        double d = 0.0;
        double d2 = 0.0;
        l = statistics.getTotalEntries();
        if (l != (l2 = statistics2.getTotalEntries())) {
            vector.addElement(new AttributeDiff("TotalCurrentEntries", "" + l, "" + l2, "java.lang.long"));
        }
        if ((d = statistics.getMinEntryTimeout()) != (d2 = statistics2.getMinEntryTimeout())) {
            vector.addElement(new AttributeDiff("MinEntryTimeout", "" + d, "" + d2, "java.lang.double"));
        }
        if ((d = statistics.getMaxEntryTimeout()) != (d2 = statistics2.getMaxEntryTimeout())) {
            vector.addElement(new AttributeDiff("MaxEntryTimeout", "" + d, "" + d2, "java.lang.double"));
        }
        if ((l = statistics.getMinEntryMemorySize()) != (l2 = statistics2.getMinEntryMemorySize())) {
            vector.addElement(new AttributeDiff("MinEntryMemorySize", "" + l, "" + l2, "java.lang.long"));
        }
        if ((l = statistics.getMaxEntryMemorySize()) != (l2 = statistics2.getMaxEntryMemorySize())) {
            vector.addElement(new AttributeDiff("MaxEntryMemorySize", "" + l, "" + l2, "java.lang.long"));
        }
        if ((l = statistics.getMaxEntryMemorySizeRequested()) != (l2 = statistics2.getMaxEntryMemorySizeRequested())) {
            vector.addElement(new AttributeDiff("MaxEntryMemorySizeRequested", "" + l, "" + l2, "java.lang.long"));
        }
        if ((l = statistics.getTotalNumberMemoryPurges()) != (l2 = statistics2.getTotalNumberMemoryPurges())) {
            vector.addElement(new AttributeDiff("TotalNumberMemoryPurges", "" + l, "" + l2, "java.lang.long"));
        }
        if ((l = statistics.getTotalNumberDiskPurges()) != (l2 = statistics2.getTotalNumberDiskPurges())) {
            vector.addElement(new AttributeDiff("TotalNumberDiskPurges", "" + l, "" + l2, "java.lang.long"));
        }
        if ((l = statistics.getTotalNumberOfRejections()) != (l2 = statistics2.getTotalNumberOfRejections())) {
            vector.addElement(new AttributeDiff("TotalNumberOfRejections", "" + l, "" + l2, "java.lang.long"));
        }
        if ((l = statistics.getTotalNumberOfRenewals()) != (l2 = statistics2.getTotalNumberOfRenewals())) {
            vector.addElement(new AttributeDiff("TotalNumberOfRenewals", "" + l, "" + l2, "java.lang.long"));
        }
        return vector;
    }

    public synchronized long getTotalCurrentEntries() {
        return this.getStats().getTotalEntries();
    }

    public synchronized long getTotalPersistentCurrentEntries() {
        return this.getStats().getTotalPersistentEntries();
    }

    public synchronized long getTotalTransientCurrentEntries() {
        return this.getStats().getTotalTransientEntries();
    }

    public synchronized double getAvgPercentTransient() {
        return this.getStats().getAvgPercentTransient();
    }

    public synchronized double getAvgPercentPersistent() {
        return this.getStats().getAvgPercentPersistent();
    }

    public synchronized double getAvgTimeout() {
        return this.getStats().getAvgTimout();
    }

    public synchronized double getMinEntryTimeout() {
        return this.getStats().getMinEntryTimeout();
    }

    public synchronized double getMaxEntryTimeout() {
        return this.getStats().getMaxEntryTimeout();
    }

    public synchronized double getAvgPerEntryMemorySize() {
        return this.getStats().getAvgPerEntryMemorySize();
    }

    public synchronized long getMaxEntryMemorySize() {
        return this.getStats().getMaxEntryMemorySize();
    }

    public synchronized long getMinEntryMemorySize() {
        return this.getStats().getMinEntryMemorySize();
    }

    public synchronized double getAvgPerEntryDiskSize() {
        return this.getStats().getAvgPerEntryDiskSize();
    }

    class AttributeDiff {
        String attributeName = null;
        String newValue = null;
        String oldValue = null;
        String type = null;

        AttributeDiff(String string, String string2, String string3, String string4) {
            this.attributeName = string;
            this.newValue = string2;
            this.oldValue = string3;
            this.type = string4;
        }
    }
}

