/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.cache.entitycache;

import java.io.Serializable;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import weblogic.xml.util.cache.entitycache.CX;
import weblogic.xml.util.cache.entitycache.CacheEntry;
import weblogic.xml.util.cache.entitycache.EntityCache;

public class Event {

    public static class CacheFailureEvent
    extends CacheEvent {
        public String path;
        public String message;

        CacheFailureEvent(EntityCache entityCache, String string, String string2) throws CX.EntityCacheException {
            super(entityCache);
            this.path = this.path;
            this.message = string2;
        }
    }

    public static class OutOfMemoryLoadingStatisticsEvent
    extends OutOfMemoryOnLoadEvent {
        OutOfMemoryLoadingStatisticsEvent(EntityCache entityCache, String string) throws CX.EntityCacheException {
            super(entityCache, string);
        }
    }

    public static class OutOfMemoryLoadingCacheEvent
    extends OutOfMemoryOnLoadEvent {
        OutOfMemoryLoadingCacheEvent(String string) throws CX.EntityCacheException {
            super(null, string);
        }
    }

    public static class OutOfMemoryLoadingEntryEvent
    extends OutOfMemoryOnLoadEvent {
        public Serializable key;

        OutOfMemoryLoadingEntryEvent(EntityCache entityCache, Serializable serializable, String string) throws CX.EntityCacheException {
            super(entityCache, string);
            this.key = serializable;
        }
    }

    public static abstract class OutOfMemoryOnLoadEvent
    extends OutOfMemoryEvent {
        public String path;

        OutOfMemoryOnLoadEvent(EntityCache entityCache, String string) throws CX.EntityCacheException {
            super(entityCache);
            this.path = string;
        }
    }

    public static abstract class OutOfMemoryEvent
    extends CacheEvent {
        OutOfMemoryEvent(EntityCache entityCache) throws CX.EntityCacheException {
            super(entityCache);
        }
    }

    public static class FileAccessErrorForStatisticsEvent
    extends FileAccessErrorEvent {
        FileAccessErrorForStatisticsEvent(EntityCache entityCache, String string, boolean bl) throws CX.EntityCacheException {
            super(entityCache, string, bl);
        }
    }

    public static class FileAccessErrorForCacheEvent
    extends FileAccessErrorEvent {
        FileAccessErrorForCacheEvent(EntityCache entityCache, String string, boolean bl) throws CX.EntityCacheException {
            super(entityCache, string, bl);
        }
    }

    public static class FileAccessErrorForEntryEvent
    extends FileAccessErrorEvent {
        public CacheEntry cacheEntry;

        FileAccessErrorForEntryEvent(EntityCache entityCache, CacheEntry cacheEntry, String string, boolean bl) throws CX.EntityCacheException {
            super(entityCache, string, bl);
            this.cacheEntry = this.cacheEntry;
        }
    }

    public static abstract class FileAccessErrorEvent
    extends FileErrorEvent {
        public boolean onRead;
        public boolean onWrite;

        FileAccessErrorEvent(EntityCache entityCache, String string, boolean bl) throws CX.EntityCacheException {
            super(entityCache, string);
            this.onWrite = bl;
            this.onRead = !bl;
        }
    }

    public static abstract class FileErrorEvent
    extends CacheEvent {
        public String path;

        FileErrorEvent(EntityCache entityCache, String string) throws CX.EntityCacheException {
            super(entityCache);
            this.path = string;
        }
    }

    public static class StatisticsCorruptionEvent
    extends CorruptionEvent {
        StatisticsCorruptionEvent(EntityCache entityCache, String string) throws CX.EntityCacheException {
            super(entityCache, string);
            this.cache = this.cache;
        }
    }

    public static class EntryCorruptionEvent
    extends CorruptionEvent {
        public Serializable key;

        EntryCorruptionEvent(EntityCache entityCache, Serializable serializable, String string) throws CX.EntityCacheException {
            super(entityCache, string);
            this.key = serializable;
            this.cache = this.cache;
        }
    }

    public static class CacheCorruptionEvent
    extends CorruptionEvent {
        CacheCorruptionEvent(String string) throws CX.EntityCacheException {
            super(null, string);
        }
    }

    public static abstract class CorruptionEvent
    extends CacheEvent {
        public String path;

        CorruptionEvent(EntityCache entityCache, String string) throws CX.EntityCacheException {
            super(entityCache);
            this.path = string;
        }
    }

    public static class CacheCloseEvent
    extends CacheEvent {
        CacheCloseEvent(EntityCache entityCache) throws CX.EntityCacheException {
            super(entityCache);
        }
    }

    public static class CacheLoadEvent
    extends CacheEvent {
        CacheLoadEvent(EntityCache entityCache) throws CX.EntityCacheException {
            super(entityCache);
        }
    }

    public static class CacheCreationEvent
    extends CacheEvent {
        CacheCreationEvent(EntityCache entityCache) throws CX.EntityCacheException {
            super(entityCache);
        }
    }

    public static class StatCheckpointEvent
    extends CacheEvent {
        StatCheckpointEvent(EntityCache entityCache) throws CX.EntityCacheException {
            super(entityCache);
        }
    }

    public static class EntryLoadEvent
    extends SingleEntryEvent {
        EntryLoadEvent(EntityCache entityCache, CacheEntry cacheEntry) throws CX.EntityCacheException {
            super(entityCache, cacheEntry);
        }
    }

    public static class EntryPersistEvent
    extends SingleEntryEvent {
        EntryPersistEvent(EntityCache entityCache, CacheEntry cacheEntry) throws CX.EntityCacheException {
            super(entityCache, cacheEntry);
        }
    }

    public static class EntryDeleteEvent
    extends SingleEntryEvent {
        EntryDeleteEvent(EntityCache entityCache, CacheEntry cacheEntry) throws CX.EntityCacheException {
            super(entityCache, cacheEntry);
        }
    }

    public static class EntryAddEvent
    extends SingleEntryEvent {
        EntryAddEvent(EntityCache entityCache, CacheEntry cacheEntry) throws CX.EntityCacheException {
            super(entityCache, cacheEntry);
        }
    }

    public static class EntryDiskRejectionEvent
    extends SingleEntryEvent {
        EntryDiskRejectionEvent(EntityCache entityCache, CacheEntry cacheEntry) throws CX.EntityCacheException {
            super(entityCache, cacheEntry);
        }
    }

    public static class EntryRejectionEvent
    extends SingleEntryEvent {
        EntryRejectionEvent(EntityCache entityCache, CacheEntry cacheEntry) throws CX.EntityCacheException {
            super(entityCache, cacheEntry);
        }
    }

    public static abstract class SingleEntryEvent
    extends CacheEvent {
        public CacheEntry cacheEntry = null;
        public long memorySize = -1L;
        public long diskSize = -1L;
        public long secondsUntilExpiration = -1L;

        SingleEntryEvent(EntityCache entityCache, CacheEntry cacheEntry) throws CX.EntityCacheException {
            super(entityCache);
            this.cacheEntry = cacheEntry;
            this.memorySize = cacheEntry.getMemorySize();
            this.diskSize = cacheEntry.getDiskSize();
            this.secondsUntilExpiration = cacheEntry.getSecondsUntilExpiration();
        }
    }

    public static class DiskPurgeEvent
    extends MultipleEntryEvent {
        DiskPurgeEvent(EntityCache entityCache, Vector vector) throws CX.EntityCacheException {
            super(entityCache, vector);
        }
    }

    public static class MemoryPurgeEvent
    extends MultipleEntryEvent {
        MemoryPurgeEvent(EntityCache entityCache, Vector vector) throws CX.EntityCacheException {
            super(entityCache, vector);
        }
    }

    public static abstract class MultipleEntryEvent
    extends CacheEvent {
        public Vector cacheEntries;
        public long combinedMemorySize = 0L;
        public long combinedDiskSize = 0L;

        MultipleEntryEvent(EntityCache entityCache, Vector vector) throws CX.EntityCacheException {
            super(entityCache);
            this.cacheEntries = vector;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                CacheEntry cacheEntry = (CacheEntry)enumeration.nextElement();
                this.combinedMemorySize += cacheEntry.getMemorySize();
                this.combinedDiskSize += cacheEntry.getDiskSize();
            }
        }
    }

    public static abstract class CacheEvent
    extends CacheUtilityEvent {
        public EntityCache cache = null;
        public long currentMemorySize;
        public long currentDiskSize;

        CacheEvent(EntityCache entityCache) throws CX.EntityCacheException {
            this.cache = entityCache;
            if (entityCache != null) {
                this.currentMemorySize = entityCache.memoryUsed;
                this.currentDiskSize = entityCache.diskUsed;
            }
        }
    }

    public static abstract class CacheUtilityEvent {
        public Date timeStamp = new Date();

        CacheUtilityEvent() throws CX.EntityCacheException {
        }
    }
}

