/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.cache.entitycache;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import weblogic.xml.util.cache.entitycache.CX;
import weblogic.xml.util.cache.entitycache.CacheEntry;
import weblogic.xml.util.cache.entitycache.EntityCache;
import weblogic.xml.util.cache.entitycache.Event;

public class Statistics
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    transient boolean isPersistent = false;
    transient EntityCache cache = null;
    transient String path = null;
    StatsData statsData = new StatsData();

    Statistics(EntityCache entityCache) {
        this.cache = entityCache;
    }

    private void touch() {
        this.cache.statsCumulativeModification = true;
    }

    static Statistics initialize(EntityCache entityCache, String string) {
        Statistics statistics = null;
        if (new File(string).exists()) {
            try {
                statistics = (Statistics)EntityCache.loadFile(string);
                statistics.statsData.sessionStartClock = new Date().getTime();
                statistics.statsData.lastOngoingClockUpdate = statistics.statsData.sessionStartClock;
            }
            catch (CX.FileLoadOutOfMemory fileLoadOutOfMemory) {
                try {
                    entityCache.notifyListener(new Event.OutOfMemoryLoadingStatisticsEvent(entityCache, string));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                statistics = null;
            }
            catch (Exception exception) {
                if (EntityCache.canRead(string)) {
                    try {
                        entityCache.notifyListener(new Event.StatisticsCorruptionEvent(entityCache, string));
                    }
                    catch (Exception exception2) {}
                } else {
                    try {
                        entityCache.notifyListener(new Event.FileAccessErrorForStatisticsEvent(entityCache, string, false));
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                statistics = null;
            }
        }
        if (statistics == null) {
            statistics = new Statistics(entityCache);
            statistics.touch();
        }
        statistics.cache = entityCache;
        statistics.isPersistent = true;
        statistics.path = string;
        return statistics;
    }

    synchronized Statistics copy() {
        try {
            Statistics statistics = (Statistics)this.clone();
            statistics.statsData = this.statsData.copy();
            return statistics;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    void clear() {
        this.statsData = new StatsData();
    }

    public Date getStartOfSampleCollection() {
        return this.statsData.startOfSampleCollection;
    }

    public synchronized double getHoursUpSinceSampleStart() {
        this.updateClock();
        return this.statsData.ongoingClock / 3600000.0;
    }

    public synchronized double getHoursThisSession() {
        return ((double)new Date().getTime() - this.statsData.sessionStartClock) / 3600000.0;
    }

    public long getTotalEntries() {
        return this.statsData.totalEntries;
    }

    public long getTotalTransientEntries() {
        return this.statsData.totalTransientEntries;
    }

    public long getTotalPersistentEntries() {
        return this.statsData.totalEntries - this.statsData.totalTransientEntries;
    }

    public long getTotalPersistedEntries() {
        return this.statsData.totalPersistedEntries;
    }

    public double getAvgPercentTransient() {
        return this.statsData.totalEntries != 0L ? (double)this.statsData.totalTransientEntries / (double)this.statsData.totalEntries * 100.0 : 0.0;
    }

    public double getAvgPercentPersistent() {
        return this.statsData.totalEntries != 0L ? ((double)this.statsData.totalEntries - (double)this.statsData.totalTransientEntries) / (double)this.statsData.totalEntries * 100.0 : 0.0;
    }

    public double getAvgTimout() {
        return this.statsData.avgTimout;
    }

    public double getMinEntryTimeout() {
        return this.statsData.minEntryTimeout;
    }

    public double getMaxEntryTimeout() {
        return this.statsData.maxEntryTimeout;
    }

    public double getAvgPerEntryMemorySize() {
        return this.statsData.avgPerEntryMemorySize;
    }

    public long getMaxEntryMemorySize() {
        return this.statsData.maxEntryMemorySize;
    }

    public long getMinEntryMemorySize() {
        return this.statsData.minEntryMemorySize;
    }

    public long getMaxEntryMemorySizeRequested() {
        return this.statsData.maxEntryMemorySizeRequested;
    }

    public double getAvgPerEntryDiskSize() {
        return this.statsData.avgPerEntryDiskSize;
    }

    public long getTotalNumberMemoryPurges() {
        return this.statsData.totalNumberMemoryPurges;
    }

    public long getTotalItemsMemoryPurged() {
        return this.statsData.totalItemsMemoryPurged;
    }

    public double getAvgEntrySizeMemoryPurged() {
        return this.statsData.avgEntrySizeMemoryPurged;
    }

    public Date getMostRecentMemoryPurge() {
        return this.statsData.mostRecentMemoryPurge;
    }

    public synchronized double getMemoryPurgesPerHour() {
        this.updateClock();
        double d = this.statsData.ongoingClock;
        if (d == 0.0) {
            d = 1.0;
        }
        double d2 = d / 3600000.0;
        double d3 = (double)this.statsData.totalNumberMemoryPurges / d2;
        return d3;
    }

    public long getTotalNumberDiskPurges() {
        return this.statsData.totalNumberDiskPurges;
    }

    public long getTotalItemsDiskPurged() {
        return this.statsData.totalItemsDiskPurged;
    }

    public double getAvgEntrySizeDiskPurged() {
        return this.statsData.avgEntrySizeDiskPurged;
    }

    public Date getMostRecentDiskPurge() {
        return this.statsData.mostRecentDiskPurge;
    }

    public synchronized double getDiskPurgesPerHour() {
        this.updateClock();
        double d = this.statsData.ongoingClock;
        if (d == 0.0) {
            d = 1.0;
        }
        double d2 = d / 3600000.0;
        double d3 = (double)this.statsData.totalNumberDiskPurges / d2;
        return d3;
    }

    public long getTotalNumberOfRejections() {
        return this.statsData.totalNumberOfRejections;
    }

    public long getTotalSizeOfRejections() {
        return this.statsData.totalSizeOfRejections;
    }

    public synchronized double getPercentRejected() {
        if (this.statsData.totalEntries == 0L) {
            return 0.0;
        }
        double d = (double)this.statsData.totalNumberOfRejections + (double)this.statsData.totalEntries;
        return (double)this.statsData.totalNumberOfRejections / d * 100.0;
    }

    public long getTotalNumberOfRenewals() {
        return this.statsData.totalNumberOfRenewals;
    }

    synchronized void addEntry(CacheEntry cacheEntry) {
        long l = cacheEntry.getSize();
        if (this.statsData.minEntryMemorySize == 0L) {
            this.statsData.minEntryMemorySize = l;
        } else if (l < this.statsData.minEntryMemorySize) {
            this.statsData.minEntryMemorySize = l;
        }
        if (l > this.statsData.maxEntryMemorySize) {
            this.statsData.maxEntryMemorySize = l;
        }
        this.statsData.avgPerEntryMemorySize = ((double)this.statsData.totalEntries * this.statsData.avgPerEntryMemorySize + (double)l) / (double)(this.statsData.totalEntries + 1L);
        long l2 = cacheEntry.getLeaseInterval();
        if (this.statsData.minEntryTimeout == 0.0) {
            this.statsData.minEntryTimeout = l2;
        } else if ((double)l2 < this.statsData.minEntryTimeout) {
            this.statsData.minEntryTimeout = l2;
        }
        if ((double)l2 > this.statsData.maxEntryTimeout) {
            this.statsData.maxEntryTimeout = l2;
        }
        this.statsData.avgTimout = ((double)this.statsData.totalEntries * this.statsData.avgTimout + (double)l2) / (double)(this.statsData.totalEntries + 1L);
        this.statsData.totalEntries++;
        if (!cacheEntry.isPersistentNoStupidException()) {
            this.statsData.totalTransientEntries++;
        }
        this.touch();
    }

    synchronized void writeEntry(CacheEntry cacheEntry) {
        this.statsData.totalPersistedEntries++;
        this.statsData.avgPerEntryDiskSize = ((double)(this.statsData.totalPersistedEntries - 1L) * this.statsData.avgPerEntryDiskSize + (double)cacheEntry.getDiskSizeNoStupidException()) / (double)this.statsData.totalPersistedEntries;
        this.touch();
    }

    synchronized void memoryPurge(long l, long l2) {
        this.statsData.avgEntrySizeMemoryPurged = ((double)this.statsData.totalItemsMemoryPurged * this.statsData.avgEntrySizeMemoryPurged + (double)l2) / (double)(this.statsData.totalItemsMemoryPurged + l);
        this.statsData.totalNumberMemoryPurges++;
        this.statsData.totalItemsMemoryPurged += l;
        this.statsData.mostRecentMemoryPurge = new Date();
        this.touch();
    }

    synchronized void diskPurge(long l, long l2) {
        this.statsData.avgEntrySizeDiskPurged = ((double)this.statsData.totalItemsDiskPurged * this.statsData.avgEntrySizeDiskPurged + (double)l2) / (double)(this.statsData.totalItemsDiskPurged + l);
        this.statsData.totalNumberDiskPurges++;
        this.statsData.totalItemsDiskPurged += l;
        this.statsData.mostRecentDiskPurge = new Date();
        this.touch();
    }

    synchronized void rejection(CacheEntry cacheEntry) {
        this.statsData.totalNumberOfRejections++;
        this.statsData.totalSizeOfRejections += cacheEntry.getSize();
        this.touch();
    }

    void renewal(CacheEntry cacheEntry) {
        this.statsData.totalNumberOfRenewals++;
        this.touch();
    }

    private void updateClock() {
        this.statsData.ongoingClock += (double)new Date().getTime() - this.statsData.lastOngoingClockUpdate;
        this.statsData.lastOngoingClockUpdate = new Date().getTime();
    }

    synchronized void save() throws CX.EntityCacheException {
        if (!this.isPersistent) {
            return;
        }
        if (!this.cache.statsCumulativeModification) {
            return;
        }
        this.updateClock();
        try {
            EntityCache.saveFile(this, this.path);
        }
        catch (Exception exception) {
            this.cache.notifyListener(new Event.FileAccessErrorForStatisticsEvent(this.cache, this.path, true));
        }
    }

    class StatsData
    implements Serializable,
    Cloneable {
        static final long serialVersionUID = 1L;
        Date startOfSampleCollection = new Date();
        volatile long totalDiskUpdates = 0L;
        volatile long totalLostUpdates = 0L;
        private volatile double ongoingClock = 0.0;
        private volatile transient double sessionStartClock;
        private volatile transient double lastOngoingClockUpdate = this.sessionStartClock = (double)System.currentTimeMillis();
        private volatile long totalEntries = 0L;
        private volatile long totalPersistedEntries = 0L;
        private volatile long totalTransientEntries = 0L;
        private volatile double avgTimout = 0.0;
        private volatile double minEntryTimeout = 0.0;
        private volatile double maxEntryTimeout = 0.0;
        private volatile double avgPerEntryMemorySize = 0.0;
        private volatile long maxEntryMemorySize = 0L;
        private volatile long minEntryMemorySize = 0L;
        private volatile long maxEntryMemorySizeRequested = 0L;
        private volatile double avgPerEntryDiskSize = 0.0;
        private volatile long totalNumberMemoryPurges = 0L;
        private volatile long totalItemsMemoryPurged = 0L;
        private volatile double avgEntrySizeMemoryPurged = 0.0;
        private Date mostRecentMemoryPurge = null;
        private volatile long totalNumberDiskPurges = 0L;
        private volatile long totalItemsDiskPurged = 0L;
        private volatile double avgEntrySizeDiskPurged = 0.0;
        private Date mostRecentDiskPurge = null;
        private volatile long totalNumberOfRejections = 0L;
        private volatile long totalSizeOfRejections = 0L;
        private volatile long totalNumberOfRenewals = 0L;

        StatsData() {
        }

        synchronized StatsData copy() {
            try {
                StatsData statsData = (StatsData)this.clone();
                return statsData;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }
}

