/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.cache.entitycache;

import java.util.Enumeration;
import java.util.Vector;
import weblogic.timers.Timer;
import weblogic.timers.TimerListener;
import weblogic.timers.TimerManagerFactory;
import weblogic.xml.util.cache.entitycache.EntityCache;
import weblogic.xml.util.cache.entitycache.EntityCacheStats;
import weblogic.xml.util.cache.entitycache.Statistics;
import weblogic.xml.util.cache.entitycache.StatisticsMonitorSubject;

class StatisticsMonitor
implements TimerListener {
    EntityCache cache = null;
    Vector subjects = new Vector();
    long diskWriteInterval = 0L;
    Timer timer;

    StatisticsMonitor(EntityCache entityCache, long l) {
        this.cache = entityCache;
        this.diskWriteInterval = l;
    }

    void addSubject(Statistics statistics, EntityCacheStats entityCacheStats) {
        StatisticsMonitorSubject statisticsMonitorSubject = new StatisticsMonitorSubject(statistics, entityCacheStats);
        this.subjects.addElement(statisticsMonitorSubject);
    }

    void addMBean(Statistics statistics, EntityCacheStats entityCacheStats) {
        Enumeration enumeration = this.subjects.elements();
        while (enumeration.hasMoreElements()) {
            StatisticsMonitorSubject statisticsMonitorSubject = (StatisticsMonitorSubject)enumeration.nextElement();
            if (statisticsMonitorSubject.stats != statistics) continue;
            statisticsMonitorSubject.mBean = entityCacheStats;
            break;
        }
    }

    void setDiskWriteInterval(long l) {
        this.diskWriteInterval = l;
    }

    public void timerExpired(Timer timer) {
        try {
            Enumeration enumeration = this.subjects.elements();
            while (enumeration.hasMoreElements()) {
                StatisticsMonitorSubject statisticsMonitorSubject = (StatisticsMonitorSubject)enumeration.nextElement();
                statisticsMonitorSubject.stats.save();
                if (statisticsMonitorSubject.mBean == null) continue;
                statisticsMonitorSubject.mBean.doNotifications();
            }
            this.cache.statsCumulativeModification = false;
            this.cache.statsCurrentModification = false;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void start() {
        this.timer = TimerManagerFactory.getTimerManagerFactory().getDefaultTimerManager().schedule((TimerListener)this, this.diskWriteInterval, this.diskWriteInterval);
    }

    public void finish() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }
}

