/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.xed;

import java.util.ArrayList;
import java.util.Iterator;
import weblogic.xml.util.xed.Command;
import weblogic.xml.util.xed.Context;
import weblogic.xml.util.xed.StreamEditorException;
import weblogic.xml.util.xed.Variable;

public class Assignment
extends Command {
    private String name;
    private Variable lhs;
    private ArrayList rhs = new ArrayList();

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public Object evaluate(Context context) throws StreamEditorException {
        Iterator iterator = this.rhs.iterator();
        if (!iterator.hasNext()) {
            throw new StreamEditorException("Evaluation error:invalid right hand side" + this.toString());
        }
        String string = (String)((Variable)iterator.next()).evaluate(context);
        while (iterator.hasNext()) {
            string = string + (String)((Variable)iterator.next()).evaluate(context);
        }
        this.lhs.assign(string, context);
        return this.lhs;
    }

    public Variable getLHS() {
        return this.lhs;
    }

    public ArrayList getRHS() {
        return this.rhs;
    }

    public void setLHS(Variable variable) {
        this.lhs = variable;
    }

    public void addRHS(Variable variable) {
        this.rhs.add(variable);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lhs + "=");
        Iterator iterator = this.rhs.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
        }
        while (iterator.hasNext()) {
            stringBuffer.append("+" + iterator.next().toString());
        }
        return stringBuffer.toString();
    }
}

