/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.xed;

import java.util.ArrayList;
import java.util.List;
import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.AttributeIterator;
import weblogic.xml.stream.CharacterData;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.events.AttributeImpl;
import weblogic.xml.stream.events.CharacterDataEvent;
import weblogic.xml.stream.events.ElementEvent;
import weblogic.xml.stream.events.Name;
import weblogic.xml.stream.events.StartElementEvent;
import weblogic.xml.util.xed.StreamEditorException;
import weblogic.xml.util.xed.Variable;

public class Context {
    private Name name;
    private Name attName;
    private ElementEvent currentEvent;
    private AttributeImpl att;

    public void set(XMLEvent xMLEvent) {
        this.currentEvent = (ElementEvent)xMLEvent;
        this.name = (Name)xMLEvent.getName();
    }

    public void set(XMLEvent xMLEvent, Attribute attribute) {
        this.currentEvent = (ElementEvent)xMLEvent;
        this.name = (Name)xMLEvent.getName();
        this.att = (AttributeImpl)attribute;
        this.attName = (Name)attribute.getName();
    }

    public String getPrefix() {
        return this.name.getPrefix();
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public String getUri() {
        return this.name.getNamespaceUri();
    }

    public String getText() {
        return ((CharacterData)this.currentEvent).getContent();
    }

    public String getAttLocalName() {
        return this.attName.getLocalName();
    }

    public String getAttPrefix() {
        return this.attName.getPrefix();
    }

    public String getAttValue() {
        return this.att.getValue();
    }

    public void setPrefix(String string) {
        this.name.setPrefix(string);
    }

    public void setUri(String string) {
        this.name.setNamespaceUri(string);
    }

    public void setLocalName(String string) {
        this.name.setLocalName(string);
    }

    public List getAttributes() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        AttributeIterator attributeIterator = ((StartElement)this.currentEvent).getAttributesAndNamespaces();
        while (attributeIterator.hasNext()) {
            arrayList.add(attributeIterator.next());
        }
        return arrayList;
    }

    public void setAttributes(List list) {
        ((StartElementEvent)this.currentEvent).setAttributes(list);
    }

    public void setText(String string) {
        ((CharacterDataEvent)this.currentEvent).setContent(string);
    }

    public void setAttLocalName(String string) {
        this.attName.setLocalName(string);
    }

    public void setAttPrefix(String string) {
        this.attName.setPrefix(string);
    }

    public void setAttValue(String string) {
        this.att.setValue(string);
    }

    public int getEventType() {
        return this.currentEvent.getType();
    }

    public Object lookup(Variable variable) throws StreamEditorException {
        if ("prefix".equals(variable.getName())) {
            return this.getPrefix();
        }
        if ("localName".equals(variable.getName())) {
            return this.getLocalName();
        }
        if ("uri".equals(variable.getName())) {
            return this.getUri();
        }
        if ("text".equals(variable.getName())) {
            return this.getText();
        }
        if ("@prefix".equals(variable.getName())) {
            return this.getAttPrefix();
        }
        if ("@localName".equals(variable.getName())) {
            return this.getAttLocalName();
        }
        if ("@value".equals(variable.getName())) {
            return this.getAttValue();
        }
        if ("@attributes".equals(variable.getName())) {
            return this.getAttributes();
        }
        throw new StreamEditorException("Unknown variable:" + variable.getName());
    }

    public void assign(Variable variable, Object object) throws StreamEditorException {
        if ("prefix".equals(variable.getName())) {
            this.setPrefix((String)object);
        } else if ("localName".equals(variable.getName())) {
            this.setLocalName((String)object);
        } else if ("uri".equals(variable.getName())) {
            this.setUri((String)object);
        } else if ("text".equals(variable.getName())) {
            this.setText((String)object);
        } else if ("@prefix".equals(variable.getName())) {
            this.setAttPrefix((String)object);
        } else if ("@localName".equals(variable.getName())) {
            this.setAttLocalName((String)object);
        } else if ("@value".equals(variable.getName())) {
            this.setAttValue((String)object);
        } else if ("@attributes".equals(variable.getName())) {
            this.setAttributes((List)object);
        } else {
            throw new StreamEditorException("Unknown variable:" + variable.getName());
        }
    }
}

