/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.xed;

import weblogic.xml.stream.Attribute;
import weblogic.xml.stream.StartElement;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.util.xed.Command;
import weblogic.xml.util.xed.Context;
import weblogic.xml.util.xed.StreamEditorException;
import weblogic.xml.xpath.XPathStreamObserver;

public class Controller
implements XPathStreamObserver {
    private Context context;
    private Command command;
    private static final boolean debug = false;

    public Controller(Context context, Command command) {
        this.context = context;
        this.command = command;
    }

    public void observe(XMLEvent xMLEvent) {
        this.context.set(xMLEvent);
        this.evaluate();
    }

    public void observeAttribute(StartElement startElement, Attribute attribute) {
        this.context.set((XMLEvent)startElement, attribute);
        this.evaluate();
    }

    public void observeNamespace(StartElement startElement, Attribute attribute) {
        this.context.set((XMLEvent)startElement, attribute);
        this.evaluate();
    }

    public XMLInputStream getResult() throws XMLStreamException {
        return this.command.getResult();
    }

    private void evaluate() {
        try {
            this.command.evaluate(this.context);
        }
        catch (StreamEditorException streamEditorException) {
            streamEditorException.printStackTrace();
            System.out.println("Error: " + streamEditorException);
        }
    }
}

