/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.xed;

import java.io.Reader;
import java.io.StringReader;
import weblogic.xml.stream.BufferedXMLInputStream;
import weblogic.xml.stream.ElementFilter;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.util.TypeFilter;
import weblogic.xml.util.xed.Command;
import weblogic.xml.util.xed.Context;
import weblogic.xml.util.xed.StreamEditorException;

public class InsertCommand
extends Command {
    private String xml;
    private BufferedXMLInputStream xis;
    private boolean hit = false;

    public String getName() {
        return "insert";
    }

    public void setXML(String string) throws StreamEditorException {
        try {
            this.xml = string;
            XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
            xMLInputStreamFactory.setFilter((ElementFilter)new TypeFilter(86));
            this.xis = xMLInputStreamFactory.newBufferedInputStream(xMLInputStreamFactory.newInputStream((Reader)new StringReader(string)));
            this.xis.mark();
            while (this.xis.hasNext()) {
                this.xis.next();
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new StreamEditorException(xMLStreamException.toString());
        }
    }

    public Object evaluate(Context context) throws StreamEditorException {
        this.hit = true;
        return null;
    }

    public String getXML() {
        return this.xml;
    }

    public String toString() {
        return super.toString() + " [" + this.getXML() + "]";
    }

    public XMLInputStream getResult() throws XMLStreamException {
        if (this.hit) {
            this.hit = false;
            this.xis.reset();
            this.xis.mark();
            return this.xis;
        }
        return null;
    }
}

