/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.xed;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLInputStreamFactory;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.util.xed.Command;
import weblogic.xml.util.xed.Context;
import weblogic.xml.util.xed.Controller;
import weblogic.xml.util.xed.Delete;
import weblogic.xml.xpath.StreamXPath;
import weblogic.xml.xpath.XPathException;
import weblogic.xml.xpath.XPathStreamFactory;
import weblogic.xml.xpath.XPathStreamObserver;

public class Operation {
    private ArrayList commands = new ArrayList();
    private XPathStreamFactory factory = new XPathStreamFactory();

    public void add(Command command) {
        this.commands.add(command);
    }

    public ArrayList getPre() throws XMLStreamException {
        ArrayList<XMLInputStream> arrayList = new ArrayList<XMLInputStream>();
        for (Command command : this.commands) {
            XMLInputStream xMLInputStream;
            if (!command.isInsertBefore() || (xMLInputStream = command.getResult()) == null) continue;
            arrayList.add(xMLInputStream);
        }
        return arrayList;
    }

    public ArrayList getChild() throws XMLStreamException {
        ArrayList<XMLInputStream> arrayList = new ArrayList<XMLInputStream>();
        for (Command command : this.commands) {
            XMLInputStream xMLInputStream;
            if (!command.isInsertChild() || (xMLInputStream = command.getResult()) == null) continue;
            arrayList.add(xMLInputStream);
        }
        return arrayList;
    }

    public ArrayList getPost() throws XMLStreamException {
        ArrayList<XMLInputStream> arrayList = new ArrayList<XMLInputStream>();
        for (Command command : this.commands) {
            XMLInputStream xMLInputStream;
            if (!command.isInsertAfter() || (xMLInputStream = command.getResult()) == null) continue;
            arrayList.add(xMLInputStream);
        }
        return arrayList;
    }

    public boolean needToDelete() {
        for (Command command : this.commands) {
            if (!command.isDelete() || !((Delete)command).wasHit()) continue;
            return true;
        }
        return false;
    }

    public ArrayList getCommands() {
        return this.commands;
    }

    public void prepare() throws XPathException, XMLStreamException {
        for (Command command : this.commands) {
            Controller controller = new Controller(new Context(), command);
            StreamXPath streamXPath = new StreamXPath(command.getXPath());
            this.factory.install(streamXPath, (XPathStreamObserver)controller);
        }
    }

    public XMLInputStream getStream(String string) throws XPathException, XMLStreamException {
        XMLInputStreamFactory xMLInputStreamFactory = XMLInputStreamFactory.newInstance();
        XMLInputStream xMLInputStream = xMLInputStreamFactory.newInputStream(new File(string));
        return this.factory.createStream(xMLInputStream);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = this.commands.iterator();
        stringBuffer.append("-------[\n");
        while (iterator.hasNext()) {
            stringBuffer.append("[" + iterator.next() + "]\n");
        }
        stringBuffer.append("\n]-------\n");
        return stringBuffer.toString();
    }
}

