/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.util.xed;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import weblogic.xml.util.xed.Assignment;
import weblogic.xml.util.xed.AttributeAssignment;
import weblogic.xml.util.xed.AttributeReference;
import weblogic.xml.util.xed.AttributeVariable;
import weblogic.xml.util.xed.Command;
import weblogic.xml.util.xed.Delete;
import weblogic.xml.util.xed.InsertAfter;
import weblogic.xml.util.xed.InsertBefore;
import weblogic.xml.util.xed.InsertChild;
import weblogic.xml.util.xed.Operation;
import weblogic.xml.util.xed.Replace;
import weblogic.xml.util.xed.StreamEditorException;
import weblogic.xml.util.xed.StringConstant;
import weblogic.xml.util.xed.Variable;

public class XEDParser {
    private Reader reader;
    private char current;
    private boolean EOF = false;
    private static final boolean debug = true;
    private int line = 1;

    public XEDParser(Reader reader) throws IOException, StreamEditorException {
        this.reader = reader;
        this.accept();
    }

    public boolean reachedEOF() {
        return this.EOF;
    }

    public char current() {
        return this.current;
    }

    public boolean isSpace() {
        return this.current == ' ' || this.current == '\r' || this.current == '\t' || this.current == '\n';
    }

    public void skipSpace() throws IOException {
        while (this.isSpace() && !this.reachedEOF()) {
            this.accept();
        }
    }

    public String error() {
        return "\nParse error at line:" + this.line + " char:" + this.current();
    }

    public void accept() throws IOException {
        int n = this.reader.read();
        if (n == -1) {
            this.EOF = true;
        }
        this.current = (char)n;
        if (n == 10) {
            ++this.line;
        }
    }

    public void accept(char c) throws IOException, StreamEditorException {
        if (this.current() != c) {
            throw new StreamEditorException("Unable to match character[" + c + "]" + this.error());
        }
        this.accept();
    }

    public void accept(String string) throws IOException, StreamEditorException {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == this.current()) {
                this.accept();
                continue;
            }
            throw new StreamEditorException("Unable to match string[" + string + "]" + this.error());
        }
    }

    public String readString() throws IOException, StreamEditorException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.current() != ' ' && this.current() != '=' && this.current() != '+' && this.current() != ';' && !this.reachedEOF()) {
            stringBuffer.append(this.current());
            this.accept();
        }
        return stringBuffer.toString();
    }

    public String readString(char c) throws IOException, StreamEditorException {
        StringBuffer stringBuffer = new StringBuffer();
        while (this.current() != c && !this.reachedEOF()) {
            stringBuffer.append(this.current());
            this.accept();
        }
        return stringBuffer.toString();
    }

    public String readXPathString(char c) throws IOException, StreamEditorException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (this.current() != c && !this.reachedEOF()) {
            if (this.current() == '(') {
                ++n;
            }
            if (this.current() == ')') {
                --n;
            }
            if (n < 0) break;
            stringBuffer.append(this.current());
            this.accept();
        }
        return stringBuffer.toString();
    }

    public String readXMLString() throws IOException, StreamEditorException {
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (this.current() != ';' && !this.reachedEOF()) {
            if (this.current() == '(') {
                ++n;
            }
            if (this.current() == ')') {
                --n;
            }
            if (n < 0) break;
            stringBuffer.append(this.current());
            this.accept();
        }
        return stringBuffer.toString();
    }

    public Operation parse() throws IOException, StreamEditorException {
        Operation operation = this.parseOperation();
        if (this.reachedEOF()) {
            System.out.println("Input parsed successfully");
        }
        return operation;
    }

    public Operation parseOperation() throws IOException, StreamEditorException {
        Operation operation = new Operation();
        this.skipSpace();
        while (!this.reachedEOF()) {
            Command command = null;
            switch (this.current()) {
                case 'i': {
                    this.accept("insert-");
                    if (this.current() == 'b') {
                        command = this.parseInsertBefore();
                        break;
                    }
                    if (this.current() == 'a') {
                        command = this.parseInsertAfter();
                        break;
                    }
                    if (this.current() == 'c') {
                        command = this.parseInsertChild();
                        break;
                    }
                    throw new StreamEditorException("Valid commands are insert-before, insert-child,  or insert-after" + this.error());
                }
                case 'd': {
                    command = this.parseDelete();
                    break;
                }
                case 'r': {
                    command = this.parseReplace();
                    break;
                }
                default: {
                    throw new StreamEditorException("Valid commands areinsert-before insert-child insert-after replace delete" + this.error());
                }
            }
            this.skipSpace();
            operation.add(command);
        }
        return operation;
    }

    public String parseXML() throws IOException, StreamEditorException {
        String string;
        this.skipSpace();
        if (this.current() == '<') {
            string = this.readXMLString();
        } else {
            String string2 = this.readString(')');
            this.skipSpace();
            System.out.println("file ----->" + string2);
            FileReader fileReader = new FileReader(new File(string2));
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (!bl) {
                int n = ((Reader)fileReader).read();
                if (n == -1) {
                    bl = true;
                    break;
                }
                stringBuffer.append((char)n);
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public Command parseInsertBefore() throws IOException, StreamEditorException {
        InsertBefore insertBefore = new InsertBefore();
        this.accept("before");
        this.skipSpace();
        this.accept('(');
        this.skipSpace();
        String string = this.readXPathString(',');
        this.accept(',');
        this.skipSpace();
        insertBefore.setXPath(string);
        insertBefore.setXML(this.parseXML());
        this.skipSpace();
        this.accept(')');
        this.skipSpace();
        this.accept(';');
        System.out.println("[INSERTBEFORE][" + string + "][" + insertBefore.getXML() + "]");
        return insertBefore;
    }

    public Command parseInsertChild() throws IOException, StreamEditorException {
        InsertChild insertChild = new InsertChild();
        this.accept("child");
        this.skipSpace();
        this.accept('(');
        this.skipSpace();
        String string = this.readXPathString(',');
        this.accept(',');
        this.skipSpace();
        insertChild.setXPath(string);
        insertChild.setXML(this.parseXML());
        this.skipSpace();
        this.accept(')');
        this.skipSpace();
        this.accept(';');
        System.out.println("[INSERTCHILD][" + string + "][" + insertChild.getXML() + "]");
        return insertChild;
    }

    public Command parseInsertAfter() throws IOException, StreamEditorException {
        InsertAfter insertAfter = new InsertAfter();
        this.accept("after");
        this.skipSpace();
        this.accept('(');
        this.skipSpace();
        String string = this.readXPathString(',');
        this.accept(',');
        this.skipSpace();
        insertAfter.setXPath(string);
        insertAfter.setXML(this.parseXML());
        this.skipSpace();
        this.accept(')');
        this.skipSpace();
        this.accept(';');
        System.out.println("[INSERTAFTER][" + string + "][" + insertAfter.getXML() + "]");
        return insertAfter;
    }

    public Command parseDelete() throws IOException, StreamEditorException {
        Delete delete = new Delete();
        this.accept("delete");
        this.skipSpace();
        this.accept('(');
        this.skipSpace();
        String string = this.readXPathString(';');
        this.skipSpace();
        delete.setXPath(string);
        this.skipSpace();
        this.accept(')');
        this.skipSpace();
        this.accept(';');
        System.out.println("[DELETE][" + string + "]");
        return delete;
    }

    public Command parseReplace() throws IOException, StreamEditorException {
        Replace replace = new Replace();
        this.accept("replace");
        this.skipSpace();
        this.accept('(');
        this.skipSpace();
        String string = this.readXPathString(',');
        replace.setXPath(string);
        this.skipSpace();
        System.out.print("[REPLACE][" + string + "]");
        switch (this.current()) {
            case ',': {
                this.accept();
                this.skipSpace();
                String string2 = this.readXMLString();
                this.skipSpace();
                replace.setXML(string2);
                this.skipSpace();
                this.accept(')');
                this.skipSpace();
                this.accept(';');
                System.out.println("[" + string2 + "]");
                break;
            }
            case ')': {
                this.accept();
                this.skipSpace();
                this.parseAction(replace);
                break;
            }
            default: {
                throw new StreamEditorException("Replace command has the following structure:'replace' Xpath (XML ';' | { Assignments ... })" + this.error());
            }
        }
        return replace;
    }

    public void parseAction(Replace replace) throws IOException, StreamEditorException {
        this.accept('{');
        System.out.print("\n\t");
        this.skipSpace();
        while (this.current == '$') {
            replace.add(this.parseAssignment());
        }
        this.accept('}');
    }

    public Variable parseVariable() throws IOException, StreamEditorException {
        Variable variable;
        this.accept('$');
        if (this.current() == '@') {
            this.accept();
            variable = new AttributeReference();
        } else {
            variable = new Variable();
        }
        variable.setName(this.readString());
        return variable;
    }

    public Assignment parseAssignment() throws IOException, StreamEditorException {
        String string;
        Variable variable;
        Variable variable2 = this.parseVariable();
        Assignment assignment = variable2.isAttributeRef() ? new AttributeAssignment() : new Assignment();
        assignment.setLHS(variable2);
        System.out.print("[" + variable2 + "=");
        this.skipSpace();
        this.accept('=');
        this.skipSpace();
        switch (this.current()) {
            case '$': {
                variable = this.parseVariable();
                System.out.print(variable);
                assignment.addRHS(variable);
                break;
            }
            case '[': {
                this.parseAttributeList(assignment);
                break;
            }
            case '\"': 
            case '\'': {
                string = this.parseConstant();
                System.out.print("'" + string + "'");
                assignment.addRHS(new StringConstant(string));
            }
        }
        this.skipSpace();
        while (this.current() == '+') {
            System.out.print("+");
            this.accept();
            switch (this.current()) {
                case '$': {
                    variable = this.parseVariable();
                    assignment.addRHS(variable);
                    System.out.print(variable);
                    break;
                }
                case '[': {
                    this.parseAttributeList(assignment);
                    break;
                }
                case '\"': 
                case '\'': {
                    string = this.parseConstant();
                    assignment.addRHS(new StringConstant(string));
                    System.out.print("'" + string + "'");
                }
            }
            this.skipSpace();
        }
        System.out.println("]");
        this.accept(';');
        this.skipSpace();
        return assignment;
    }

    public String parseConstant() throws IOException, StreamEditorException {
        String string = "";
        if (this.current() == '\"') {
            this.accept();
            string = this.readString('\"');
        } else if (this.current() == '\'') {
            this.accept();
            string = this.readString('\'');
        } else {
            throw new StreamEditorException("String consants must be enclosed in quotes" + this.error());
        }
        this.accept();
        return string;
    }

    public void parseAttributeList(Assignment assignment) throws IOException, StreamEditorException {
        this.accept('[');
        while (this.current != ']' && !this.reachedEOF()) {
            this.skipSpace();
            String string = this.readString();
            this.skipSpace();
            this.accept('=');
            String string2 = this.parseConstant();
            System.out.print("[" + string + "=" + string2 + "]");
            assignment.addRHS(new AttributeVariable(string, string2));
        }
        this.accept(']');
    }

    public static void main(String[] stringArray) throws Exception {
        XEDParser xEDParser = new XEDParser(new FileReader(stringArray[0]));
        System.out.println(xEDParser.parse());
    }
}

