/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.cluster;

import java.util.ArrayList;
import java.util.HashMap;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.ServiceContext;
import weblogic.corba.client.cluster.ClusterComponent;
import weblogic.corba.client.cluster.VendorInfoCluster;
import weblogic.corba.client.cluster.VendorInfoClusterHelper;
import weblogic.corba.iiop.cluster.Selector;
import weblogic.corba.iiop.cluster.SelectorFactory;

public final class TargetInfo {
    private static final boolean DEBUG = false;
    private static final HashMap objectTable = new HashMap();
    static final TargetInfo NULL_TARGET_INFO = new TargetInfo();
    VendorInfoCluster clusterContext;
    ClusterComponent clusterComponent;
    private Object[] replicas;
    private static final Object[] OBJECT_ARRAY_TYPE = new Object[0];
    private long version;
    private ServiceContext versionContext;
    private final Selector selector;
    private int current;
    private ThreadLocal inInvoke = new ThreadLocal(){

        protected java.lang.Object initialValue() {
            return new Boolean(false);
        }
    };

    private TargetInfo() {
        this.selector = null;
    }

    TargetInfo(ClusterComponent cc, Codec codec) {
        this.clusterComponent = cc;
        this.replicas = cc.replicas;
        this.version = cc.version;
        this.createVersionClusterContext(codec);
        this.current = 0;
        this.selector = SelectorFactory.getSelector(cc.algorithm);
    }

    final long getVersion() {
        return this.version;
    }

    final ServiceContext getVersionContext() {
        return this.versionContext;
    }

    private void createVersionClusterContext(Codec codec) {
        try {
            VendorInfoCluster vic = new VendorInfoCluster(this.version, new Object[0]);
            Any a = ORB.init().create_any();
            VendorInfoClusterHelper.insert(a, vic);
            byte[] cdr = codec.encode_value(a);
            this.versionContext = new ServiceContext(1111834883, cdr);
        }
        catch (InvalidTypeForEncoding invalidTypeForEncoding) {
            // empty catch block
        }
    }

    final Object[] getReplicas() {
        return this.replicas;
    }

    final boolean invoking() {
        return (Boolean)this.inInvoke.get();
    }

    final void setInvoking(boolean val) {
        this.inInvoke.set(new Boolean(val));
    }

    final boolean onlyOneTarget() {
        return this.replicas == null || this.replicas.length <= 1;
    }

    final Object selectNextTarget() {
        if (this.replicas == null || this.replicas.length == 0) {
            return null;
        }
        int prev = this.current;
        if (!this.clusterComponent.stickToFirstServer) {
            this.current = this.selector.select(this.current, this.replicas.length);
        }
        if (prev == this.current) {
            return null;
        }
        return this.replicas[this.current];
    }

    final Object selectFailoverTarget() {
        this.current = this.selector.select(this.current, this.replicas.length);
        return this.replicas[this.current];
    }

    private static final ObjectKey delegate(Object obj) {
        return new ObjectKey(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTargetInfo(Object obj, VendorInfoCluster vic, Codec codec) {
        if (vic != null) {
            HashMap hashMap = objectTable;
            synchronized (hashMap) {
                int i;
                TargetInfo ti = (TargetInfo)objectTable.get(TargetInfo.delegate(obj));
                for (i = 0; i < ti.replicas.length; ++i) {
                    if (ti.replicas[i] == obj || TargetInfo.delegate(ti.replicas[i]).equals(TargetInfo.delegate(obj))) continue;
                    objectTable.remove(TargetInfo.delegate(ti.replicas[i]));
                }
                ti.clusterContext = vic;
                ti.version = vic.version;
                ti.createVersionClusterContext(codec);
                ti.replicas = vic.replicas;
                for (i = 0; i < ti.replicas.length; ++i) {
                    objectTable.put(TargetInfo.delegate(ti.replicas[i]), ti);
                }
            }
        }
    }

    public void removeMember(Object thisone) {
        if (this.replicas.length > 0) {
            ArrayList<Object> newreplicas = new ArrayList<Object>(this.replicas.length - 1);
            for (int i = 0; i < this.replicas.length; ++i) {
                if (this.replicas[i]._is_equivalent(thisone)) continue;
                newreplicas.add(this.replicas[i]);
            }
            this.replicas = newreplicas.toArray(OBJECT_ARRAY_TYPE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetInfo findOrCreateTargetInfo(Object obj, ClusterComponent cc, Codec codec) {
        TargetInfo ti = null;
        ObjectKey delegate = TargetInfo.delegate(obj);
        HashMap hashMap = objectTable;
        synchronized (hashMap) {
            ti = (TargetInfo)objectTable.get(delegate);
            if (ti == null && cc != null) {
                ti = new TargetInfo(cc, codec);
                objectTable.put(delegate, ti);
                for (int i = 0; i < ti.replicas.length; ++i) {
                    objectTable.put(TargetInfo.delegate(ti.replicas[i]), ti);
                }
            }
        }
        return ti;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TargetInfo findTargetInfo(Object obj) {
        TargetInfo ti = null;
        ObjectKey delegate = TargetInfo.delegate(obj);
        HashMap hashMap = objectTable;
        synchronized (hashMap) {
            ti = (TargetInfo)objectTable.get(delegate);
        }
        return ti;
    }

    protected static void p(String s) {
        System.err.println("<TargetInfo> " + s);
    }

    private static final class ObjectKey {
        private final int hash;
        private final ObjectImpl obj;
        private final Delegate del;
        private static final String OBJECT_ID = "IDL:omg.org/CORBA/Object:1.0";
        private static final int OBJECT_HASH = "IDL:omg.org/CORBA/Object:1.0".hashCode();

        ObjectKey(Object obj) {
            this.obj = (ObjectImpl)obj;
            this.del = this.obj._get_delegate();
            this.hash = this.del.hashCode();
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(java.lang.Object other) {
            try {
                if (this.hashCode() != other.hashCode()) {
                    return false;
                }
                ObjectKey okey = (ObjectKey)other;
                if (!(this.obj._ids()[0].equals(okey.obj._ids()[0]) || this.obj._ids().length != 1 || okey.obj._ids().length != 1 || this.obj._ids()[0].equals(OBJECT_ID) || okey.obj._ids()[0].equals(OBJECT_ID))) {
                    return false;
                }
                return this.del.equals((Object)this.obj, (java.lang.Object)okey.obj);
            }
            catch (ClassCastException cce) {
                return false;
            }
        }
    }
}

