/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.iiop;

import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IIOP.ListenPoint;
import weblogic.corba.client.ClientORBInitializer;
import weblogic.corba.client.cluster.DummySocket;
import weblogic.corba.client.iiop.BiDirInterceptor;
import weblogic.corba.client.iiop.BiDirServerSocket;
import weblogic.corba.client.iiop.BiDirSocket;
import weblogic.corba.client.iiop.BiDirSocketImpl;
import weblogic.corba.client.utils.ORBWrapper;
import weblogic.corba.j2ee.naming.ORBHelper;
import weblogic.rmi.extensions.DisconnectEvent;
import weblogic.rmi.extensions.DisconnectListener;

public class BiDirSocketFactory
implements RMIClientSocketFactory,
RMIServerSocketFactory {
    private static final String ENABLE_CLUSTER_FAILOVER_PROPERTY_NAME = "weblogic.thinclient.enableClusterFailOver";
    private int timeout;
    private static final boolean ENABLE_CLUSTER_FAILOVER = BiDirSocketFactory.initializeEnableClusterFailOverProperty();
    protected static final boolean DEBUG = BiDirSocketFactory.getDebug();
    private final LinkedList serverSockets;
    private final LinkedList serverImpls;
    private boolean initialized;
    private ServerSocket dummySocket;
    private InetSocketAddress localAddress;
    private boolean peerGone;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.iiop");
        }
        catch (Exception e) {
            return false;
        }
    }

    public BiDirSocketFactory() {
        block3: {
            this.timeout = -1;
            this.serverSockets = new LinkedList();
            this.serverImpls = new LinkedList();
            this.initialized = false;
            this.peerGone = false;
            if (DEBUG) {
                BiDirSocketFactory.p("initialized");
            }
            try {
                this.dummySocket = new ServerSocket(0);
                this.localAddress = new InetSocketAddress(InetAddress.getLocalHost(), this.dummySocket.getLocalPort());
            }
            catch (IOException ioe) {
                if (!DEBUG) break block3;
                ioe.printStackTrace();
            }
        }
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        if (DEBUG) {
            BiDirSocketFactory.p("createServerSocket(" + port + ")");
        }
        BiDirServerSocket ssock = new BiDirServerSocket(port, this);
        return ssock;
    }

    public Socket createSocket(String host, int port) throws IOException {
        if (DEBUG) {
            BiDirSocketFactory.p("createSocket(" + host + ":" + port + ")");
        }
        try {
            return new BiDirSocket(host, port, this);
        }
        catch (IOException ie) {
            if (!ENABLE_CLUSTER_FAILOVER) {
                throw ie;
            }
            if (ie instanceof ConnectException || ie instanceof NoRouteToHostException || ie instanceof SocketTimeoutException) {
                if (DEBUG) {
                    BiDirSocketFactory.p("created DummySocket()");
                }
                return new DummySocket();
            }
            throw ie;
        }
    }

    public Socket createSocket(String host, int port, Socket sock) throws IOException {
        if (DEBUG) {
            BiDirSocketFactory.p("createSocket(" + host + ":" + port + ")");
        }
        return new BiDirSocket(host, port, sock, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeInterceptor(final ORB orb) {
        if (DEBUG) {
            BiDirSocketFactory.p("initializeInterceptor(" + orb + ")");
        }
        if (!this.initialized) {
            BiDirSocketFactory biDirSocketFactory = this;
            synchronized (biDirSocketFactory) {
                block8: {
                    if (!this.initialized) {
                        this.timeout = ORBHelper.getORBHelper().getORBTimeout(orb);
                        try {
                            this.initialized = true;
                            BiDirInterceptor bidir = (BiDirInterceptor)orb.resolve_initial_references("BiDirInterceptor");
                            bidir.setListenPoint(new ListenPoint(this.localAddress.getAddress().getHostAddress(), (short)this.localAddress.getPort()));
                            bidir.setDeferredRegistration(new Runnable(){

                                public void run() {
                                    try {
                                        ClientORBInitializer.getDisconnectMonitor().addDisconnectListener(new ORBWrapper(orb), new BiDirListener());
                                    }
                                    catch (INTERNAL one) {
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                            });
                        }
                        catch (InvalidName in) {
                            if (!DEBUG) break block8;
                            in.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BiDirSocketImpl getOrQueueServerSocket(ServerSocket ss) {
        if (DEBUG) {
            BiDirSocketFactory.p("getOrQueueServerSocket(" + ss + ")");
        }
        LinkedList linkedList = this.serverSockets;
        synchronized (linkedList) {
            try {
                return (BiDirSocketImpl)this.serverImpls.removeFirst();
            }
            catch (NoSuchElementException nsee) {
                this.serverSockets.add(ss);
                return null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void acceptOrQueueServerImpl(BiDirSocketImpl serverImpl) {
        if (DEBUG) {
            BiDirSocketFactory.p("acceptOrQueueServerImpl(" + serverImpl + ")");
        }
        LinkedList linkedList = this.serverSockets;
        synchronized (linkedList) {
            try {
                ((BiDirServerSocket)this.serverSockets.removeFirst()).accept(serverImpl);
            }
            catch (NoSuchElementException nsee) {
                this.serverImpls.add(serverImpl);
            }
        }
    }

    boolean isPeerGone() {
        return this.peerGone;
    }

    protected static void p(String s) {
        System.err.println("<BiDirSocketFactory> " + s);
    }

    private static boolean initializeEnableClusterFailOverProperty() {
        boolean enabled = true;
        try {
            enabled = System.getProperty(ENABLE_CLUSTER_FAILOVER_PROPERTY_NAME, "true").equals("true");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return enabled;
    }

    public void removeServerImpl(BiDirSocketImpl serverImpl) {
        this.serverImpls.remove(serverImpl);
    }

    public int getTimeout() {
        return this.timeout;
    }

    private final class BiDirListener
    implements DisconnectListener {
        private BiDirListener() {
        }

        public void onDisconnect(DisconnectEvent reason) {
            BiDirSocketFactory.this.peerGone = true;
        }
    }
}

