/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.security;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.AccessController;
import javax.security.auth.Subject;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.UserException;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.MessageInContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.InvalidSlot;
import weblogic.corba.client.security.ClientSecurityContext;
import weblogic.corba.client.security.CompoundSecMechListImpl;
import weblogic.corba.client.security.EstablishContextImpl;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.security.subject.SubjectProxy;

public final class SecurityInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    private static final boolean DEBUG = SecurityInterceptor.getDebug();
    public static final String NAME = "SecurityInterceptor";
    public static final int SecurityAttributeService = 15;
    private AbstractSubject kernelId = null;
    public int CEMinor = 1;
    public int CEMajorInvalidEvidence = 1;
    public int CEMajorInvalidMechanism = 2;
    public int CEMajorConflictingEvidence = 3;
    public int CEMajorNoContext = 4;
    private Current piCurrent;
    private Codec codec;
    private int slot;

    private static final boolean getDebug() {
        try {
            return Boolean.getBoolean("weblogic.debug.client.security");
        }
        catch (Exception e) {
            return false;
        }
    }

    public SecurityInterceptor(Current piCurrent, Codec codec, int slot) {
        this.piCurrent = piCurrent;
        this.codec = codec;
        this.slot = slot;
        try {
            this.kernelId = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
        }
        catch (AccessControlException ace) {
            // empty catch block
        }
    }

    public String name() {
        return NAME;
    }

    public void setSubject(Subject as) {
        try {
            Any any = ORB.init().create_any();
            if (as != null) {
                any.insert_Value((Serializable)as);
            }
            this.piCurrent.set_slot(this.slot, any);
        }
        catch (InvalidSlot is) {
            throw new SecurityException(is.getMessage());
        }
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        if (DEBUG) {
            SecurityInterceptor.p("send_request(<" + Integer.toHexString(ri.effective_target()._hash(Integer.MAX_VALUE)) + ">." + ri.operation() + ")");
        }
        try {
            AbstractSubject subject = SubjectManager.getSubjectManager().getCurrentSubject(this.kernelId);
            if (subject == SubjectProxy.ANON) {
                return;
            }
            if (subject instanceof SubjectProxy) {
                Subject ctx = ((SubjectProxy)subject).getSubject();
                if (ctx != null) {
                    ClientSecurityContext csc = ClientSecurityContext.getClientContext(ctx);
                    if (csc != null && csc.getMessageInContext() != null) {
                        if (DEBUG) {
                            SecurityInterceptor.p("adding MessageInContext");
                        }
                        ri.add_request_service_context(csc.getMessageInContext(), true);
                    } else {
                        TaggedComponent[] comp = ri.get_effective_components(33);
                        if (DEBUG) {
                            SecurityInterceptor.p("adding security context from " + comp.length + " components for " + ctx);
                        }
                        ri.add_request_service_context(this.createEstablishContext(comp[0], ctx), true);
                    }
                } else if (DEBUG) {
                    SecurityInterceptor.p("null security context for " + Thread.currentThread());
                }
            } else if (DEBUG) {
                SecurityInterceptor.p("no security context for " + Thread.currentThread());
            }
        }
        catch (UserException ue) {
            if (DEBUG) {
                SecurityInterceptor.p("couldn't marshal security context: " + (Object)((Object)ue));
            }
        }
        catch (UnsupportedEncodingException uee) {
            if (DEBUG) {
                SecurityInterceptor.p("couldn't marshal security context: " + uee);
            }
        }
        catch (BAD_PARAM bp) {
            switch (bp.minor) {
                case 1330446364: {
                    if (!DEBUG) break;
                    SecurityInterceptor.p("no mech list in request target for: " + ri.operation() + "()");
                    break;
                }
                default: {
                    if (DEBUG) {
                        bp.printStackTrace();
                    }
                    if (DEBUG) {
                        SecurityInterceptor.p("couldn't marshal security context: " + (Object)((Object)bp));
                    }
                    throw bp;
                }
            }
        }
    }

    public void send_poll(ClientRequestInfo ri) {
        if (DEBUG) {
            SecurityInterceptor.p("send_poll(" + ri.operation() + ")");
        }
    }

    public void receive_reply(ClientRequestInfo ri) {
        block4: {
            if (DEBUG) {
                SecurityInterceptor.p("receive_reply(" + ri.operation() + ")");
            }
            try {
                CompleteEstablishContext cec = this.getCompleteEstablishContext(ri);
                if (cec != null && cec.context_stateful) {
                    ClientSecurityContext.getClientContext(cec.client_context_id).setMessageInContext(this.createMessageInContext(cec.client_context_id));
                }
            }
            catch (UserException ue) {
                if (!DEBUG) break block4;
                ue.printStackTrace();
            }
        }
    }

    public void receive_exception(ClientRequestInfo ri) throws ForwardRequest {
        block9: {
            if (DEBUG) {
                SecurityInterceptor.p("receive_exception(" + ri.operation() + ")");
            }
            try {
                ContextError ce = this.getContextError(ri);
                if (ce != null) {
                    if (ce.minor_status == this.CEMinor && ce.major_status == this.CEMajorNoContext && ClientSecurityContext.getClientContext(ce.client_context_id) != null) {
                        ClientSecurityContext.removeClientContext(ce.client_context_id);
                        if (DEBUG) {
                            SecurityInterceptor.p("client context not valid, retrying");
                        }
                        throw new ForwardRequest(ri.effective_target());
                    }
                    if (DEBUG) {
                        SecurityInterceptor.p("SAS authentication failed: " + ce);
                    }
                }
            }
            catch (TypeMismatch tm) {
                if (DEBUG) {
                    tm.printStackTrace();
                }
            }
            catch (FormatMismatch fm) {
                if (!DEBUG) break block9;
                fm.printStackTrace();
            }
        }
    }

    public void receive_other(ClientRequestInfo ri) {
        if (DEBUG) {
            SecurityInterceptor.p("receive_other(" + ri.operation() + ")");
        }
    }

    private ServiceContext createEstablishContext(TaggedComponent comp, Subject subject) throws InvalidTypeForEncoding, UnsupportedEncodingException, FormatMismatch, TypeMismatch {
        Any a = this.codec.decode_value(comp.component_data, CompoundSecMechListHelper.type());
        CompoundSecMechListImpl csml = new CompoundSecMechListImpl(CompoundSecMechListHelper.extract(a), this.codec);
        SASContextBody sas = new SASContextBody();
        EstablishContextImpl ec = new EstablishContextImpl(csml, subject, this.codec);
        sas.establish_msg(ec.getContext());
        SASContextBodyHelper.insert(a, sas);
        byte[] cdr = this.codec.encode_value(a);
        return new ServiceContext(15, cdr);
    }

    private ServiceContext createMessageInContext(long contextId) throws InvalidTypeForEncoding, FormatMismatch {
        SASContextBody sas = new SASContextBody();
        sas.in_context_msg(new MessageInContext(contextId, false));
        Any a = ORB.init().create_any();
        SASContextBodyHelper.insert(a, sas);
        byte[] cdr = this.codec.encode_value(a);
        return new ServiceContext(15, cdr);
    }

    private CompleteEstablishContext getCompleteEstablishContext(ClientRequestInfo ri) throws TypeMismatch, FormatMismatch {
        try {
            ServiceContext secsc = ri.get_reply_service_context(15);
            if (DEBUG) {
                SecurityInterceptor.p("found SAS context for " + ri.operation() + "()");
            }
            Any a = this.codec.decode_value(secsc.context_data, SASContextBodyHelper.type());
            SASContextBody sas = SASContextBodyHelper.extract(a);
            switch (sas.discriminator()) {
                case 1: {
                    return sas.complete_msg();
                }
                case 4: {
                    throw new MARSHAL("CSI authentication error");
                }
            }
            throw new MARSHAL("Unsupported CSI reply");
        }
        catch (BAD_PARAM bpe) {
            if (bpe.minor != 1330446362) {
                throw bpe;
            }
            return null;
        }
    }

    private ContextError getContextError(ClientRequestInfo ri) throws TypeMismatch, FormatMismatch {
        if (ri.reply_status() != 1) {
            return null;
        }
        try {
            Any a;
            SASContextBody sas;
            ServiceContext secsc = ri.get_reply_service_context(15);
            if (DEBUG) {
                SecurityInterceptor.p("found SAS ContextError for " + ri.operation() + "()");
            }
            if ((sas = SASContextBodyHelper.extract(a = this.codec.decode_value(secsc.context_data, SASContextBodyHelper.type()))).discriminator() == 4) {
                return sas.error_msg();
            }
            return null;
        }
        catch (BAD_PARAM bpe) {
            if (bpe.minor != 1330446362) {
                throw bpe;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    protected static void p(String s) {
        System.err.println("<SecurityInterceptor> " + s);
    }
}

