/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.utils;

import java.io.IOException;
import java.io.NotSerializableException;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.portable.InputStream;
import weblogic.workarea.WorkContext;
import weblogic.workarea.WorkContextInput;

class ContextInputImpl
implements WorkContextInput {
    private InputStream delegate;

    ContextInputImpl(InputStream in) {
        this.delegate = in;
    }

    public String readASCII() throws IOException {
        return this.delegate.read_string();
    }

    public WorkContext readContext() throws IOException, ClassNotFoundException {
        Class rcClass = Util.loadClass((String)this.readASCII(), null, null);
        try {
            WorkContext runtimeContext = (WorkContext)rcClass.newInstance();
            runtimeContext.readContext(this);
            return runtimeContext;
        }
        catch (InstantiationException ie) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(ie);
        }
        catch (IllegalAccessException iae) {
            throw (IOException)new NotSerializableException("WorkContext must have a public no-arg constructor").initCause(iae);
        }
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException("readLine");
    }

    public int readInt() throws IOException {
        return this.delegate.read_long();
    }

    public String readUTF() throws IOException {
        return this.delegate.read_wstring();
    }

    public long readLong() throws IOException {
        return this.delegate.read_longlong();
    }

    public byte readByte() throws IOException {
        return this.delegate.read_octet();
    }

    public short readShort() throws IOException {
        return this.delegate.read_short();
    }

    public float readFloat() throws IOException {
        return this.delegate.read_float();
    }

    public char readChar() throws IOException {
        return this.delegate.read_wchar();
    }

    public void readFully(byte[] byteArray) throws IOException {
        this.delegate.read_octet_array(byteArray, 0, byteArray.length);
    }

    public void readFully(byte[] byteArray, int n, int n1) throws IOException {
        this.delegate.read_octet_array(byteArray, n, n1);
    }

    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException("skip()");
    }

    public boolean readBoolean() throws IOException {
        return this.delegate.read_boolean();
    }

    public int readUnsignedByte() throws IOException {
        return this.delegate.read_octet();
    }

    public int readUnsignedShort() throws IOException {
        return this.delegate.read_short();
    }

    public double readDouble() throws IOException {
        return this.delegate.read_double();
    }
}

