/*
 * Decompiled with CFR 0.152.
 */
package weblogic.corba.client.utils;

import com.sun.corba.se.spi.transport.SocketInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class EndPointInfo
implements SocketInfo {
    private final String host;
    private String addr;
    private final int port;
    private final String type;

    public EndPointInfo(String host, int port) {
        this(host, port, "IIOP_CLEAR_TEXT");
    }

    public EndPointInfo(String host, int port, String type) {
        this.type = type;
        this.host = host;
        this.port = port;
        try {
            this.addr = InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException uhe) {
            this.addr = host;
        }
    }

    public String getType() {
        return this.type;
    }

    public String getHost() {
        return this.addr;
    }

    public int getPort() {
        return this.port;
    }

    public int hashCode() {
        return this.addr.hashCode() ^ this.port ^ this.type.hashCode();
    }

    public boolean equals(Object o) {
        EndPointInfo epi = (EndPointInfo)o;
        return epi == this || epi.port == this.port && epi.addr.equals(this.addr) && epi.type.equals(this.type);
    }
}

